/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Iterables;
import edu.stanford.nlp.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;

public class CollectionUtilsTest
extends TestCase {
    File outputDir;

    protected void setUp() throws Exception {
        super.setUp();
        this.outputDir = File.createTempFile("IOUtilsTest", ".dir");
        CollectionUtilsTest.assertTrue((boolean)this.outputDir.delete());
        CollectionUtilsTest.assertTrue((boolean)this.outputDir.mkdir());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.remove(this.outputDir);
    }

    protected void remove(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.remove(child);
            }
        }
        file.delete();
    }

    public void testLoadCollection() throws Exception {
        File collectionFile = new File(this.outputDir, "string.collection");
        StringUtils.printToFile(collectionFile, "-1\n42\n122\n-3.14");
        HashSet actualSet = new HashSet();
        CollectionUtils.loadCollection(collectionFile, String.class, actualSet);
        HashSet<String> expectedSet = new HashSet<String>(Arrays.asList("-1 42 122 -3.14".split(" ")));
        Assert.assertEquals(expectedSet, actualSet);
        ArrayList<TestDouble> actualList = new ArrayList<TestDouble>();
        actualList.add(new TestDouble("95.2"));
        CollectionUtils.loadCollection(collectionFile.getPath(), TestDouble.class, actualList);
        ArrayList<TestDouble> expectedList = new ArrayList<TestDouble>();
        expectedList.add(new TestDouble("95.2"));
        expectedList.add(new TestDouble("-1"));
        expectedList.add(new TestDouble("42"));
        expectedList.add(new TestDouble("122"));
        expectedList.add(new TestDouble("-3.14"));
        Assert.assertEquals(expectedList, actualList);
    }

    public void testSorted() throws Exception {
        List<Integer> inputInts = Arrays.asList(5, 4, 3, 2, 1);
        List<Integer> expectedInts = Arrays.asList(1, 2, 3, 4, 5);
        Assert.assertEquals(expectedInts, CollectionUtils.sorted(inputInts));
        HashSet<String> inputStrings = new HashSet<String>(Arrays.asList("d a c b".split(" ")));
        List<String> expectedStrings = Arrays.asList("a b c d".split(" "));
        Assert.assertEquals(expectedStrings, CollectionUtils.sorted(inputStrings));
    }

    public void testToList() {
        Iterable<String> iter = Iterables.take(Arrays.asList("a", "b", "c"), 2);
        Assert.assertEquals(Arrays.asList("a", "b"), CollectionUtils.toList(iter));
    }

    public void testToSet() {
        Iterable<String> iter = Iterables.drop(Arrays.asList("c", "a", "b", "a"), 1);
        Assert.assertEquals(new HashSet<String>(Arrays.asList("a", "b")), CollectionUtils.toSet(iter));
    }

    public void testGetNGrams() {
        List<String> items = CollectionUtilsTest.splitOne("a#b#c#d#e");
        List<List<String>> expected = CollectionUtilsTest.split("a b c d e");
        List<List<String>> actual = CollectionUtils.getNGrams(items, 1, 1);
        Assert.assertEquals(expected, actual);
        items = CollectionUtilsTest.splitOne("a#b#c#d#e");
        expected = CollectionUtilsTest.split("a#b b#c c#d d#e");
        actual = CollectionUtils.getNGrams(items, 2, 2);
        Assert.assertEquals(expected, actual);
        items = CollectionUtilsTest.splitOne("a#b#c#d#e");
        expected = CollectionUtilsTest.split("a a#b b b#c c c#d d d#e e");
        actual = CollectionUtils.getNGrams(items, 1, 2);
        Assert.assertEquals(expected, actual);
        items = CollectionUtilsTest.splitOne("a#b#c#d#e");
        expected = CollectionUtilsTest.split("a#b#c#d a#b#c#d#e b#c#d#e");
        actual = CollectionUtils.getNGrams(items, 4, 6);
        Assert.assertEquals(expected, actual);
        items = CollectionUtilsTest.splitOne("a#b#c#d#e");
        expected = new ArrayList<List<String>>();
        actual = CollectionUtils.getNGrams(items, 6, 6);
        Assert.assertEquals(expected, actual);
    }

    private static List<String> splitOne(String wordString) {
        return Arrays.asList(wordString.split("#"));
    }

    private static List<List<String>> split(String wordListsString) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (String wordString : wordListsString.split(" ")) {
            result.add(CollectionUtilsTest.splitOne(wordString));
        }
        return result;
    }

    public void testGetIndex() {
        int startIndex = 4;
        List<String> list = Arrays.asList("this", "is", "a", "test", "which", "test", "is", "it");
        int index = CollectionUtils.getIndex(list, "test", startIndex);
        Assert.assertEquals((long)5L, (long)index);
        startIndex = 0;
        list = Arrays.asList("Biology", "is", "a", "test", "which", "test", "is", "it");
        index = CollectionUtils.getIndex(list, "Biology", startIndex);
        Assert.assertEquals((long)0L, (long)index);
    }

    public void testContainsAny() {
        List<String> list = Arrays.asList("this", "is", "a", "test", "which", "test", "is", "it");
        List<String> toCheck = Arrays.asList("a", "which");
        Assert.assertTrue((boolean)CollectionUtils.containsAny(list, toCheck));
        toCheck = Arrays.asList("not", "a");
        Assert.assertTrue((boolean)CollectionUtils.containsAny(list, toCheck));
        toCheck = Arrays.asList("not", "here");
        Assert.assertFalse((boolean)CollectionUtils.containsAny(list, toCheck));
    }

    public void testIsSubList() {
        List<String> t1 = Arrays.asList("this", "is", "test");
        List<String> t2 = Arrays.asList("well", "this", "this", "again", "is", "test");
        Assert.assertTrue((boolean)CollectionUtils.isSubList(t1, t2));
        t1 = Arrays.asList("test", "this", "is");
        Assert.assertFalse((boolean)CollectionUtils.isSubList(t1, t2));
    }

    public void testMaxIndex() {
        List<Integer> t1 = Arrays.asList(2, -1, 4);
        Assert.assertEquals((long)2L, (long)CollectionUtils.maxIndex(t1));
    }

    public void testIteratorConcatEmpty() {
        Iterator iter = CollectionUtils.concatIterators(new Iterator[0]);
        CollectionUtilsTest.assertFalse((boolean)iter.hasNext());
    }

    public void testIteratorConcatSingleIter() {
        Iterator iter = CollectionUtils.concatIterators(new ArrayList<String>(){
            {
                this.add("foo");
            }
        }.iterator());
        CollectionUtilsTest.assertTrue((boolean)iter.hasNext());
        CollectionUtilsTest.assertEquals((String)"foo", (String)((String)iter.next()));
        CollectionUtilsTest.assertFalse((boolean)iter.hasNext());
    }

    public void testIteratorConcatMultiIter() {
        Iterator iter = CollectionUtils.concatIterators(new ArrayList<String>(){
            {
                this.add("foo");
            }
        }.iterator(), new ArrayList<String>(){
            {
                this.add("bar");
                this.add("baz");
            }
        }.iterator(), new ArrayList<String>(){
            {
                this.add("boo");
            }
        }.iterator());
        CollectionUtilsTest.assertTrue((boolean)iter.hasNext());
        CollectionUtilsTest.assertEquals((String)"foo", (String)((String)iter.next()));
        CollectionUtilsTest.assertTrue((boolean)iter.hasNext());
        CollectionUtilsTest.assertEquals((String)"bar", (String)((String)iter.next()));
        CollectionUtilsTest.assertTrue((boolean)iter.hasNext());
        CollectionUtilsTest.assertEquals((String)"baz", (String)((String)iter.next()));
        CollectionUtilsTest.assertTrue((boolean)iter.hasNext());
        CollectionUtilsTest.assertEquals((String)"boo", (String)((String)iter.next()));
        CollectionUtilsTest.assertFalse((boolean)iter.hasNext());
    }

    public void testIteratorConcatEmptyIter() {
        Iterator iter = CollectionUtils.concatIterators(new ArrayList<String>(){
            {
                this.add("foo");
            }
        }.iterator(), new ArrayList<String>(){}.iterator(), new ArrayList<String>(){
            {
                this.add("boo");
            }
        }.iterator());
        CollectionUtilsTest.assertTrue((boolean)iter.hasNext());
        CollectionUtilsTest.assertEquals((String)"foo", (String)((String)iter.next()));
        CollectionUtilsTest.assertTrue((boolean)iter.hasNext());
        CollectionUtilsTest.assertEquals((String)"boo", (String)((String)iter.next()));
        CollectionUtilsTest.assertFalse((boolean)iter.hasNext());
    }

    public void testIteratorConcaatRemove() {
        ArrayList<String> a = new ArrayList<String>(){
            {
                this.add("foo");
            }
        };
        ArrayList<String> b = new ArrayList<String>(){};
        ArrayList<String> c = new ArrayList<String>(){
            {
                this.add("bar");
                this.add("baz");
            }
        };
        Iterator iter = CollectionUtils.concatIterators(a.iterator(), b.iterator(), c.iterator());
        CollectionUtilsTest.assertTrue((boolean)iter.hasNext());
        CollectionUtilsTest.assertEquals((String)"foo", (String)((String)iter.next()));
        CollectionUtilsTest.assertTrue((boolean)iter.hasNext());
        CollectionUtilsTest.assertEquals((String)"bar", (String)((String)iter.next()));
        iter.remove();
        CollectionUtilsTest.assertTrue((boolean)iter.hasNext());
        CollectionUtilsTest.assertEquals((String)"baz", (String)((String)iter.next()));
        CollectionUtilsTest.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("foo");
            }
        }, (Object)a);
        CollectionUtilsTest.assertEquals((Object)new ArrayList<String>(){}, (Object)b);
        CollectionUtilsTest.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("baz");
            }
        }, (Object)c);
    }

    public static class TestDouble {
        public double d;

        public TestDouble(String string) {
            this.d = Double.parseDouble(string);
        }

        public boolean equals(Object other) {
            return this.d == ((TestDouble)other).d;
        }

        public String toString() {
            return String.format("%f", this.d);
        }
    }
}

