/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.Comparators;
import java.util.Arrays;
import java.util.Comparator;
import junit.framework.TestCase;

public class ComparatorsTest
extends TestCase {
    public void testNullSafeComparator() {
        Comparator<Integer> comp = Comparators.nullSafeNaturalComparator();
        ComparatorsTest.assertEquals((int)0, (int)comp.compare(null, null));
        ComparatorsTest.assertEquals((int)-1, (int)comp.compare(null, 42));
        ComparatorsTest.assertEquals((int)1, (int)comp.compare(42, null));
        ComparatorsTest.assertEquals((int)-1, (int)comp.compare(11, 18));
        ComparatorsTest.assertEquals((int)0, (int)comp.compare(11, 11));
    }

    public void testListComparator() {
        Comparator lc = Comparators.getListComparator();
        String[] one = new String[]{"hello", "foo"};
        String[] two = new String[]{"hi", "foo"};
        String[] three = new String[]{"hi", "foo", "bar"};
        ComparatorsTest.assertTrue((lc.compare(Arrays.asList(one), Arrays.asList(one)) == 0 ? 1 : 0) != 0);
        ComparatorsTest.assertTrue((lc.compare(Arrays.asList(one), Arrays.asList(two)) < 0 ? 1 : 0) != 0);
        ComparatorsTest.assertTrue((lc.compare(Arrays.asList(one), Arrays.asList(three)) < 0 ? 1 : 0) != 0);
        ComparatorsTest.assertTrue((lc.compare(Arrays.asList(three), Arrays.asList(two)) > 0 ? 1 : 0) != 0);
    }

    private static <C extends Comparable> void compare(C[] a1, C[] a2) {
        System.out.printf("compare(%s, %s) = %d%n", Arrays.toString(a1), Arrays.toString(a2), ArrayUtils.compareArrays(a1, a2));
    }

    public void testArrayComparator() {
        Comparator<C[]> ac = Comparators.getArrayComparator();
        ComparatorsTest.assertTrue((ac.compare(new Boolean[]{true, false, true}, new Boolean[]{true, false, true}) == 0 ? 1 : 0) != 0);
        ComparatorsTest.assertTrue((ac.compare(new Boolean[]{true, false, true}, new Boolean[]{true, false}) > 0 ? 1 : 0) != 0);
        ComparatorsTest.assertTrue((ac.compare(new Boolean[]{true, false, true}, new Boolean[]{true, false, true, false}) < 0 ? 1 : 0) != 0);
        ComparatorsTest.assertTrue((ac.compare(new Boolean[]{false, false, true}, new Boolean[]{true, false, true}) < 0 ? 1 : 0) != 0);
    }
}

