/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.TypesafeMap;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CoreMaps {
    private CoreMaps() {
    }

    public static CoreMap merge(CoreMap base, CoreMap toBeMerged) {
        ArrayCoreMap rtn = new ArrayCoreMap(base.size());
        for (Class<?> key : base.keySet()) {
            rtn.set(key, base.get(key));
        }
        for (Class<?> key : toBeMerged.keySet()) {
            rtn.set(key, toBeMerged.get(key));
        }
        return rtn;
    }

    public static CoreLabel merge(CoreLabel base, CoreLabel toBeMerged) {
        CoreLabel rtn = new CoreLabel(base.size());
        for (Class<?> key : base.keySet()) {
            rtn.set(key, base.get(key));
        }
        for (Class<?> key : toBeMerged.keySet()) {
            rtn.set(key, toBeMerged.get(key));
        }
        return rtn;
    }

    public static <V, CM extends CoreMap, COLL extends Collection<CM>> Map<CM, V> asMap(final COLL coremaps, final Class<? extends TypesafeMap.Key<V>> valueKey) {
        final IdentityHashMap<CoreMap, Boolean> references = new IdentityHashMap<CoreMap, Boolean>();
        for (CoreMap map : coremaps) {
            references.put(map, true);
        }
        final AbstractSet entrySet = new AbstractSet<Map.Entry<CM, V>>(){

            @Override
            public Iterator<Map.Entry<CM, V>> iterator() {
                return new Iterator<Map.Entry<CM, V>>(){
                    Iterator<CM> it;
                    CM last;
                    {
                        this.it = coremaps.iterator();
                        this.last = null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Map.Entry<CM, V> next() {
                        final CoreMap next = (CoreMap)this.it.next();
                        this.last = next;
                        return new Map.Entry<CM, V>(){

                            @Override
                            public CM getKey() {
                                return next;
                            }

                            @Override
                            public V getValue() {
                                return next.get(valueKey);
                            }

                            @Override
                            public V setValue(V value) {
                                return next.set(valueKey, value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        references.remove(this.last);
                        this.it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return coremaps.size();
            }
        };
        return new AbstractMap<CM, V>(){

            @Override
            public int size() {
                return coremaps.size();
            }

            @Override
            public boolean containsKey(Object key) {
                return coremaps.contains(key);
            }

            @Override
            public V get(Object key) {
                if (!references.containsKey(key)) {
                    return null;
                }
                return ((CoreMap)key).get(valueKey);
            }

            @Override
            public V put(CM key, V value) {
                if (!references.containsKey(key)) {
                    coremaps.add(key);
                    references.put(key, true);
                }
                return key.set(valueKey, value);
            }

            @Override
            public V remove(Object key) {
                if (!references.containsKey(key)) {
                    return null;
                }
                return coremaps.remove(key) ? (Object)((CoreMap)key).get(valueKey) : null;
            }

            @Override
            public Set<Map.Entry<CM, V>> entrySet() {
                return entrySet;
            }
        };
    }

    public static String dumpCoreMap(CoreMap cm) {
        StringBuilder sb = new StringBuilder();
        CoreMaps.dumpCoreMapToStringBuilder(cm, sb);
        return sb.toString();
    }

    public static void dumpCoreMapToStringBuilder(CoreMap cm, StringBuilder sb) {
        Iterator<Class<?>> iterator = cm.keySet().iterator();
        while (iterator.hasNext()) {
            Class<?> rawKey;
            Class<?> key = rawKey = iterator.next();
            String className = key.getSimpleName();
            Object value = cm.get(key);
            sb.append(className).append(": ").append(value).append("\n");
        }
    }
}

