/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HashIndexTest {
    protected Index<String> index;

    @Before
    public void setUp() {
        this.index = new HashIndex<String>();
        this.index.add("The");
        this.index.add("Beast");
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)2L, (long)this.index.size());
    }

    @Test
    public void testGet() {
        Assert.assertEquals((long)2L, (long)this.index.size());
        Assert.assertEquals((Object)"The", (Object)this.index.get(0));
        Assert.assertEquals((Object)"Beast", (Object)this.index.get(1));
    }

    @Test
    public void testIndexOf() {
        Assert.assertEquals((long)2L, (long)this.index.size());
        Assert.assertEquals((long)0L, (long)this.index.indexOf("The"));
        Assert.assertEquals((long)1L, (long)this.index.indexOf("Beast"));
    }

    @Test
    public void testIterator() {
        Iterator i = this.index.iterator();
        Assert.assertEquals((Object)"The", i.next());
        Assert.assertEquals((Object)"Beast", i.next());
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test
    public void testToArray() {
        String[] strs = new String[2];
        strs = this.index.objectsList().toArray(strs);
        Assert.assertEquals((Object)"The", (Object)strs[0]);
        Assert.assertEquals((Object)"Beast", (Object)strs[1]);
        Assert.assertEquals((long)2L, (long)strs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmodifiableViewEtc() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("A");
        list.add("B");
        list.add("A");
        list.add("C");
        HashIndex<String> index4 = new HashIndex<String>(list);
        HashIndex<String> index5 = new HashIndex<String>();
        index5.addAll(list);
        Assert.assertEquals((String)"Equality failure", index4, index5);
        index5.addToIndex("D");
        index5.addToIndex("E");
        index5.indexOf("F");
        index5.addAll(list);
        Assert.assertEquals((long)5L, (long)index5.size());
        Assert.assertEquals((long)3L, (long)index4.size());
        Assert.assertTrue((boolean)index4.contains("A"));
        Assert.assertEquals((long)0L, (long)index4.indexOf("A"));
        Assert.assertEquals((long)1L, (long)index4.indexOf("B"));
        Assert.assertEquals((long)2L, (long)index4.indexOf("C"));
        Assert.assertEquals((Object)"A", index4.get(0));
        HashIndex<String> index4u = index4.unmodifiableView();
        Assert.assertEquals((long)3L, (long)index4u.size());
        Assert.assertTrue((boolean)index4u.contains("A"));
        Assert.assertEquals((long)0L, (long)index4u.indexOf("A"));
        Assert.assertEquals((long)1L, (long)index4u.indexOf("B"));
        Assert.assertEquals((long)2L, (long)index4u.indexOf("C"));
        Assert.assertEquals((Object)"A", index4u.get(0));
        Assert.assertEquals((long)-1L, (long)index4u.addToIndex("D"));
        boolean okay = false;
        try {
            index4u.unlock();
        }
        catch (UnsupportedOperationException uoe) {
            okay = true;
        }
        finally {
            Assert.assertTrue((boolean)okay);
        }
    }

    @Test
    public void testCopyConstructor() {
        HashIndex<String> test = new HashIndex<String>();
        test.add("Beauty");
        test.add("And");
        test.add("The");
        test.add("Beast");
        HashIndex copy = new HashIndex(test);
        Assert.assertEquals(test, copy);
    }
}

