/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Functions;
import edu.stanford.nlp.util.MapFactory;
import edu.stanford.nlp.util.TwoDimensionalMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Function;
import junit.framework.TestCase;

public class TwoDimensionalMapTest
extends TestCase {
    public void testBasicOperations() {
        TwoDimensionalMap<String, String, String> map = new TwoDimensionalMap<String, String, String>();
        TwoDimensionalMapTest.assertEquals((int)0, (int)map.size());
        TwoDimensionalMapTest.assertTrue((boolean)map.isEmpty());
        map.put("A", "B", "C");
        TwoDimensionalMapTest.assertEquals((String)"C", (String)((String)map.get("A", "B")));
        TwoDimensionalMapTest.assertEquals((int)1, (int)map.size());
        TwoDimensionalMapTest.assertFalse((boolean)map.isEmpty());
        TwoDimensionalMapTest.assertTrue((boolean)map.contains("A", "B"));
        TwoDimensionalMapTest.assertFalse((boolean)map.contains("A", "C"));
        TwoDimensionalMapTest.assertFalse((boolean)map.contains("B", "F"));
        map.put("A", "B", "D");
        TwoDimensionalMapTest.assertEquals((String)"D", (String)((String)map.get("A", "B")));
        TwoDimensionalMapTest.assertEquals((int)1, (int)map.size());
        TwoDimensionalMapTest.assertFalse((boolean)map.isEmpty());
        TwoDimensionalMapTest.assertTrue((boolean)map.contains("A", "B"));
        TwoDimensionalMapTest.assertFalse((boolean)map.contains("A", "C"));
        TwoDimensionalMapTest.assertFalse((boolean)map.contains("B", "F"));
        map.put("A", "C", "E");
        TwoDimensionalMapTest.assertEquals((String)"D", (String)((String)map.get("A", "B")));
        TwoDimensionalMapTest.assertEquals((String)"E", (String)((String)map.get("A", "C")));
        TwoDimensionalMapTest.assertEquals((int)2, (int)map.size());
        TwoDimensionalMapTest.assertFalse((boolean)map.isEmpty());
        TwoDimensionalMapTest.assertTrue((boolean)map.contains("A", "B"));
        TwoDimensionalMapTest.assertTrue((boolean)map.contains("A", "C"));
        TwoDimensionalMapTest.assertFalse((boolean)map.contains("B", "F"));
        map.put("B", "F", "G");
        TwoDimensionalMapTest.assertEquals((String)"D", (String)((String)map.get("A", "B")));
        TwoDimensionalMapTest.assertEquals((String)"E", (String)((String)map.get("A", "C")));
        TwoDimensionalMapTest.assertEquals((String)"G", (String)((String)map.get("B", "F")));
        TwoDimensionalMapTest.assertEquals((int)3, (int)map.size());
        TwoDimensionalMapTest.assertFalse((boolean)map.isEmpty());
        TwoDimensionalMapTest.assertTrue((boolean)map.contains("A", "B"));
        TwoDimensionalMapTest.assertTrue((boolean)map.contains("A", "C"));
        TwoDimensionalMapTest.assertTrue((boolean)map.contains("B", "F"));
        map.clear();
        TwoDimensionalMapTest.assertEquals((int)0, (int)map.size());
        TwoDimensionalMapTest.assertTrue((boolean)map.isEmpty());
    }

    public void testBasicIterator() {
        TwoDimensionalMap<String, String, String> map = new TwoDimensionalMap<String, String, String>();
        Iterator mapIterator = map.iterator();
        TwoDimensionalMapTest.assertFalse((boolean)mapIterator.hasNext());
        map.put("A", "B", "C");
        mapIterator = map.iterator();
        TwoDimensionalMapTest.assertTrue((boolean)mapIterator.hasNext());
        TwoDimensionalMap.Entry entry = mapIterator.next();
        TwoDimensionalMapTest.assertEquals((String)"A", (String)((String)entry.getFirstKey()));
        TwoDimensionalMapTest.assertEquals((String)"B", (String)((String)entry.getSecondKey()));
        TwoDimensionalMapTest.assertEquals((String)"C", (String)((String)entry.getValue()));
        TwoDimensionalMapTest.assertFalse((boolean)mapIterator.hasNext());
        map.put("A", "E", "F");
        map.put("D", "E", "F");
        map.put("G", "H", "I");
        map.put("J", "K", "L");
        TwoDimensionalMapTest.assertEquals((int)5, (int)map.size());
        int count = 0;
        HashSet<String> firstKeys = new HashSet<String>();
        HashSet<String> values = new HashSet<String>();
        for (TwoDimensionalMap.Entry e : map) {
            ++count;
            firstKeys.add((String)e.getFirstKey());
            values.add((String)e.getValue());
        }
        TwoDimensionalMapTest.assertTrue((boolean)firstKeys.contains("A"));
        TwoDimensionalMapTest.assertTrue((boolean)firstKeys.contains("D"));
        TwoDimensionalMapTest.assertTrue((boolean)firstKeys.contains("G"));
        TwoDimensionalMapTest.assertTrue((boolean)firstKeys.contains("J"));
        TwoDimensionalMapTest.assertTrue((boolean)values.contains("C"));
        TwoDimensionalMapTest.assertTrue((boolean)values.contains("F"));
        TwoDimensionalMapTest.assertTrue((boolean)values.contains("I"));
        TwoDimensionalMapTest.assertTrue((boolean)values.contains("L"));
        TwoDimensionalMapTest.assertEquals((int)5, (int)count);
        TwoDimensionalMapTest.assertEquals((int)4, (int)firstKeys.size());
        TwoDimensionalMapTest.assertEquals((int)4, (int)values.size());
    }

    public void testMapFactory() {
        TwoDimensionalMap map = new TwoDimensionalMap(MapFactory.identityHashMapFactory(), MapFactory.identityHashMapFactory());
        map.put(new String("A"), "B", "C");
        map.put(new String("A"), "B", "C");
        TwoDimensionalMapTest.assertEquals((int)2, (int)map.size());
    }

    public void testTreeMapIterator() {
        TwoDimensionalMap map = new TwoDimensionalMap(MapFactory.treeMapFactory(), MapFactory.treeMapFactory());
        map.put("A", "B", "C");
        map.put("Z", "Y", "X");
        map.put("Z", "B", "C");
        map.put("A", "Y", "X");
        map.put("D", "D", "D");
        map.put("D", "F", "E");
        map.put("K", "G", "B");
        map.put("G", "F", "E");
        map.put("D", "D", "E");
        TwoDimensionalMapTest.assertEquals((int)8, (int)map.size());
        Iterator mapIterator = map.iterator();
        TwoDimensionalMap.Entry entry = mapIterator.next();
        TwoDimensionalMapTest.assertEquals((String)"A", (String)((String)entry.getFirstKey()));
        TwoDimensionalMapTest.assertEquals((String)"B", (String)((String)entry.getSecondKey()));
        TwoDimensionalMapTest.assertEquals((String)"C", (String)((String)entry.getValue()));
        entry = mapIterator.next();
        TwoDimensionalMapTest.assertEquals((String)"A", (String)((String)entry.getFirstKey()));
        TwoDimensionalMapTest.assertEquals((String)"Y", (String)((String)entry.getSecondKey()));
        TwoDimensionalMapTest.assertEquals((String)"X", (String)((String)entry.getValue()));
        entry = mapIterator.next();
        TwoDimensionalMapTest.assertEquals((String)"D", (String)((String)entry.getFirstKey()));
        TwoDimensionalMapTest.assertEquals((String)"D", (String)((String)entry.getSecondKey()));
        TwoDimensionalMapTest.assertEquals((String)"E", (String)((String)entry.getValue()));
        entry = mapIterator.next();
        TwoDimensionalMapTest.assertEquals((String)"D", (String)((String)entry.getFirstKey()));
        TwoDimensionalMapTest.assertEquals((String)"F", (String)((String)entry.getSecondKey()));
        TwoDimensionalMapTest.assertEquals((String)"E", (String)((String)entry.getValue()));
        entry = mapIterator.next();
        TwoDimensionalMapTest.assertEquals((String)"G", (String)((String)entry.getFirstKey()));
        TwoDimensionalMapTest.assertEquals((String)"F", (String)((String)entry.getSecondKey()));
        TwoDimensionalMapTest.assertEquals((String)"E", (String)((String)entry.getValue()));
        entry = mapIterator.next();
        TwoDimensionalMapTest.assertEquals((String)"K", (String)((String)entry.getFirstKey()));
        TwoDimensionalMapTest.assertEquals((String)"G", (String)((String)entry.getSecondKey()));
        TwoDimensionalMapTest.assertEquals((String)"B", (String)((String)entry.getValue()));
        entry = mapIterator.next();
        TwoDimensionalMapTest.assertEquals((String)"Z", (String)((String)entry.getFirstKey()));
        TwoDimensionalMapTest.assertEquals((String)"B", (String)((String)entry.getSecondKey()));
        TwoDimensionalMapTest.assertEquals((String)"C", (String)((String)entry.getValue()));
        entry = mapIterator.next();
        TwoDimensionalMapTest.assertEquals((String)"Z", (String)((String)entry.getFirstKey()));
        TwoDimensionalMapTest.assertEquals((String)"Y", (String)((String)entry.getSecondKey()));
        TwoDimensionalMapTest.assertEquals((String)"X", (String)((String)entry.getValue()));
        TwoDimensionalMapTest.assertFalse((boolean)mapIterator.hasNext());
        Iterator valueIterator = map.valueIterator();
        TwoDimensionalMapTest.assertTrue((boolean)valueIterator.hasNext());
        TwoDimensionalMapTest.assertEquals((String)"C", (String)((String)valueIterator.next()));
        TwoDimensionalMapTest.assertEquals((String)"X", (String)((String)valueIterator.next()));
        TwoDimensionalMapTest.assertEquals((String)"E", (String)((String)valueIterator.next()));
        TwoDimensionalMapTest.assertEquals((String)"E", (String)((String)valueIterator.next()));
        TwoDimensionalMapTest.assertEquals((String)"E", (String)((String)valueIterator.next()));
        TwoDimensionalMapTest.assertEquals((String)"B", (String)((String)valueIterator.next()));
        TwoDimensionalMapTest.assertEquals((String)"C", (String)((String)valueIterator.next()));
        TwoDimensionalMapTest.assertEquals((String)"X", (String)((String)valueIterator.next()));
        TwoDimensionalMapTest.assertFalse((boolean)valueIterator.hasNext());
    }

    public void testAddAll() {
        TwoDimensionalMap<String, String, String> m1 = TwoDimensionalMap.hashMap();
        m1.put("A", "B", "1");
        m1.put("Z", "Y", "2");
        m1.put("Z", "B", "3");
        m1.put("A", "Y", "4");
        m1.put("D", "D", "5");
        m1.put("D", "F", "6");
        m1.put("K", "G", "7");
        m1.put("G", "F", "8");
        TwoDimensionalMap m2 = TwoDimensionalMap.treeMap();
        m2.addAll(m1, Functions.identityFunction());
        TwoDimensionalMapTest.assertEquals(m1, m2);
        Function<String, Integer> valueOf = input -> Integer.valueOf(input);
        TwoDimensionalMap<String, String, Integer> m3 = TwoDimensionalMap.hashMap();
        m3.addAll(m1, valueOf);
        TwoDimensionalMapTest.assertEquals((int)m1.size(), (int)m3.size());
        TwoDimensionalMapTest.assertEquals((int)3, (int)((Integer)m3.get("Z", "B")));
    }
}

