/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.wordseg;

import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.wordseg.AffixDictionary;
import edu.stanford.nlp.wordseg.CorpusChar;

class TagAffixDetector {
    private static final Redwood.RedwoodChannels logger = Redwood.channels(TagAffixDetector.class);
    private static final boolean VERBOSE = false;
    private final CorpusChar cc;
    private final AffixDictionary aD;
    private static final String DEFAULT_CORPORA_DICT = "/u/nlp/data/gale/segtool/stanford-seg/data";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TagAffixDetector(SeqClassifierFlags flags) {
        String adPath;
        String ccPath;
        String corporaDict = flags.sighanCorporaDict != null ? flags.sighanCorporaDict : DEFAULT_CORPORA_DICT;
        if (!corporaDict.isEmpty() && !corporaDict.endsWith("/")) {
            corporaDict = corporaDict + '/';
        }
        if (flags.useChPos || flags.useCTBChar2 || flags.usePKChar2) {
            if (flags.useASBCChar2 || flags.useHKChar2 || flags.useMSRChar2) {
                throw new RuntimeException("only support settings for CTB and PK now.");
            }
            if (flags.useCTBChar2) {
                ccPath = corporaDict + "dict/character_list";
                adPath = corporaDict + "dict/in.ctb";
            } else {
                if (!flags.usePKChar2) throw new RuntimeException("none of flags.useXXXChar2 are on");
                ccPath = corporaDict + "dict/pos_open/character_list.pku.utf8";
                adPath = corporaDict + "dict/in.pk";
            }
        } else {
            ccPath = corporaDict + "dict/pos_close/char.ctb.list";
            adPath = corporaDict + "dict/in.ctb";
        }
        this.cc = new CorpusChar(ccPath);
        this.aD = new AffixDictionary(adPath);
    }

    String checkDic(String t2, String c2) {
        if (this.cc.getTag(t2, c2).equals("1")) {
            return "1";
        }
        return "0";
    }

    String checkInDic(String c2) {
        if (this.aD.getInDict(c2).equals("1")) {
            return "1";
        }
        return "0";
    }
}

