/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.wordseg.demo;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;

public class SegDemo {
    private static final String basedir = System.getProperty("SegDemo", "data");

    public static void main(String[] args) throws Exception {
        System.setOut(new PrintStream((OutputStream)System.out, true, "utf-8"));
        Properties props = new Properties();
        props.setProperty("sighanCorporaDict", basedir);
        props.setProperty("serDictionary", basedir + "/dict-chris6.ser.gz");
        if (args.length > 0) {
            props.setProperty("testFile", args[0]);
        }
        props.setProperty("inputEncoding", "UTF-8");
        props.setProperty("sighanPostProcessing", "true");
        CRFClassifier segmenter = new CRFClassifier(props);
        segmenter.loadClassifierNoExceptions(basedir + "/ctb.gz", props);
        for (String filename : args) {
            segmenter.classifyAndWriteAnswers(filename);
        }
        String sample = "\u6211\u4f4f\u5728\u7f8e\u56fd\u3002";
        List<String> segmented = segmenter.segmentString(sample);
        System.out.println(segmented);
    }
}

