/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.ner.webapp;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ie.crf.NERGUI;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;

public class NERServlet
extends HttpServlet {
    private static final long serialVersionUID = 1584102147050497227L;
    private String format;
    private boolean spacing;
    private String defaultClassifier;
    private List<String> classifiers = new ArrayList<String>();
    private Map<String, CRFClassifier<CoreMap>> ners;
    private static final int MAXIMUM_QUERY_LENGTH = 3000;

    public void init() throws ServletException {
        this.format = this.getServletConfig().getInitParameter("outputFormat");
        if (this.format == null || this.format.trim().isEmpty()) {
            throw new ServletException("Invalid outputFormat setting.");
        }
        String spacingStr = this.getServletConfig().getInitParameter("preserveSpacing");
        if (spacingStr == null || spacingStr.trim().isEmpty()) {
            throw new ServletException("Invalid preserveSpacing setting.");
        }
        spacingStr = spacingStr.trim().toLowerCase();
        this.spacing = "true".equals(spacingStr);
        String path = this.getServletContext().getRealPath("/WEB-INF/data/models");
        for (String classifier : new File(path).list()) {
            this.classifiers.add(classifier);
        }
        this.defaultClassifier = this.classifiers.get(0);
        for (String classifier : this.classifiers) {
            this.log(classifier);
        }
        this.ners = Generics.newHashMap();
        for (String classifier : this.classifiers) {
            CRFClassifier model = null;
            String filename = "/WEB-INF/data/models/" + classifier;
            InputStream is = this.getServletConfig().getServletContext().getResourceAsStream(filename);
            if (is == null) {
                throw new ServletException("File not found. Filename = " + filename);
            }
            try {
                is = filename.endsWith(".gz") ? new BufferedInputStream(new GZIPInputStream(is)) : new BufferedInputStream(is);
                model = CRFClassifier.getClassifier(is);
            }
            catch (IOException e) {
                throw new ServletException("IO problem reading classifier.");
            }
            catch (ClassCastException e) {
                throw new ServletException("Classifier class casting problem.");
            }
            catch (ClassNotFoundException e) {
                throw new ServletException("Classifier class not found problem.");
            }
            finally {
                IOUtils.closeIgnoringExceptions(is);
            }
            this.ners.put(classifier, model);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding("utf-8");
        }
        response.setContentType("text/html; charset=UTF-8");
        this.getServletContext().getRequestDispatcher("/header.jsp").include((ServletRequest)request, (ServletResponse)response);
        request.setAttribute("classifiers", this.classifiers);
        this.getServletContext().getRequestDispatcher("/ner.jsp").include((ServletRequest)request, (ServletResponse)response);
        this.addResults(request, response);
        this.getServletContext().getRequestDispatcher("/footer.jsp").include((ServletRequest)request, (ServletResponse)response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void addResults(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean preserveSpacing;
        String preserveSpacingStr;
        String input = request.getParameter("input");
        if (input == null) {
            return;
        }
        if ((input = input.trim()).isEmpty()) {
            return;
        }
        PrintWriter out2 = response.getWriter();
        if (input.length() > 3000) {
            out2.print("This query is too long.  If you want to run very long queries, please download and use our <a href=\"http://nlp.stanford.edu/software/CRF-NER.html\">publicly released distribution</a>.");
            return;
        }
        String outputFormat = request.getParameter("outputFormat");
        if (outputFormat == null || outputFormat.trim().isEmpty()) {
            outputFormat = this.format;
        }
        if ((preserveSpacingStr = request.getParameter("preserveSpacing")) == null || preserveSpacingStr.trim().isEmpty()) {
            preserveSpacing = this.spacing;
        } else {
            preserveSpacingStr = preserveSpacingStr.trim();
            preserveSpacing = Boolean.valueOf(preserveSpacingStr);
        }
        String classifier = request.getParameter("classifier");
        if (classifier == null || classifier.trim().isEmpty()) {
            classifier = this.defaultClassifier;
        }
        response.addHeader("classifier", classifier);
        response.addHeader("outputFormat", outputFormat);
        response.addHeader("preserveSpacing", String.valueOf(preserveSpacing));
        if (outputFormat.equals("highlighted")) {
            NERServlet.outputHighlighting(out2, this.ners.get(classifier), input);
        } else {
            out2.print(StringEscapeUtils.escapeHtml4((String)this.ners.get(classifier).classifyToString(input, outputFormat, preserveSpacing)));
        }
    }

    private static void outputHighlighting(PrintWriter out2, CRFClassifier<CoreMap> classifier, String input) {
        Set<String> labels = classifier.labels();
        String background = classifier.backgroundSymbol();
        List sentences = classifier.classify(input);
        Map<String, Color> tagToColorMap = NERGUI.makeTagToColorMap(labels, background);
        StringBuilder result = new StringBuilder();
        int lastEndOffset = 0;
        for (List list : sentences) {
            for (CoreMap word : list) {
                int beginOffset = (Integer)word.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                int endOffset = (Integer)word.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                String answer = (String)word.get(CoreAnnotations.AnswerAnnotation.class);
                if (beginOffset > lastEndOffset) {
                    result.append(StringEscapeUtils.escapeHtml4((String)input.substring(lastEndOffset, beginOffset)));
                }
                if (!background.equals(answer)) {
                    Color color = tagToColorMap.get(answer);
                    result.append("<span style=\"color:#ffffff;background:" + NERGUI.colorToHTML(color) + "\">");
                }
                result.append(StringEscapeUtils.escapeHtml4((String)input.substring(beginOffset, endOffset)));
                if (!background.equals(answer)) {
                    result.append("</span>");
                }
                lastEndOffset = endOffset;
            }
        }
        if (lastEndOffset < input.length()) {
            result.append(StringEscapeUtils.escapeHtml4((String)input.substring(lastEndOffset)));
        }
        result.append("<br><br>");
        result.append("Potential tags:");
        for (Map.Entry entry : tagToColorMap.entrySet()) {
            result.append("<br>&nbsp;&nbsp;");
            Color color = (Color)entry.getValue();
            result.append("<span style=\"color:#ffffff;background:" + NERGUI.colorToHTML(color) + "\">");
            result.append(StringEscapeUtils.escapeHtml4((String)((String)entry.getKey())));
            result.append("</span>");
        }
        out2.print(result);
    }
}

