/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.morph;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.international.arabic.ArabicTreeReaderFactory;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public final class AddMorphoAnnotations {
    private static Redwood.RedwoodChannels log = Redwood.channels(AddMorphoAnnotations.class);
    private static final int minArgs = 2;

    private static String usage() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Usage: java %s [OPTS] morph_file lemma_file < tree_file \n\n", AddMorphoAnnotations.class.getName()));
        sb.append("Options:\n");
        sb.append("  -e enc     : Encoding.\n");
        sb.append("  -g         : Morph file is gold tree file with morph analyses in the pre-terminals.");
        return sb.toString();
    }

    private static Map<String, Integer> argSpec() {
        Map<String, Integer> argSpec = Generics.newHashMap();
        argSpec.put("g", 0);
        argSpec.put("e", 1);
        return argSpec;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            log.info(AddMorphoAnnotations.usage());
            System.exit(-1);
        }
        Properties options = StringUtils.argsToProperties(args, AddMorphoAnnotations.argSpec());
        String encoding = options.getProperty("e", "UTF-8");
        boolean isMorphTreeFile = PropertiesUtils.getBool(options, "g", false);
        String[] parsedArgs = options.getProperty("").split("\\s+");
        if (parsedArgs.length != 2) {
            log.info(AddMorphoAnnotations.usage());
            System.exit(-1);
        }
        YieldIterator morphIter = new YieldIterator(parsedArgs[0], isMorphTreeFile);
        YieldIterator lemmaIter = new YieldIterator(parsedArgs[1], false);
        Pattern pParenStripper = Pattern.compile("[\\(\\)]");
        try {
            String line;
            BufferedReader brIn = new BufferedReader(new InputStreamReader(System.in, encoding));
            ArabicTreeReaderFactory.ArabicRawTreeReaderFactory trf = new ArabicTreeReaderFactory.ArabicRawTreeReaderFactory(true);
            int nTrees = 0;
            while ((line = brIn.readLine()) != null) {
                Tree tree = trf.newTreeReader(new StringReader(line)).readTree();
                List leaves = tree.getLeaves();
                if (!morphIter.hasNext()) {
                    throw new RuntimeException("Mismatch between number of morpho analyses and number of input lines.");
                }
                Object morphTags = morphIter.next();
                if (!lemmaIter.hasNext()) {
                    throw new RuntimeException("Mismatch between number of lemmas and number of input lines.");
                }
                Object lemmas = lemmaIter.next();
                assert (morphTags.size() == lemmas.size());
                assert (lemmas.size() == leaves.size());
                for (int i = 0; i < leaves.size(); ++i) {
                    String morphTag = (String)morphTags.get(i);
                    if (pParenStripper.matcher(morphTag).find()) {
                        morphTag = pParenStripper.matcher(morphTag).replaceAll("");
                    }
                    String newLeaf = String.format("%s%s%s%s%s", ((Tree)leaves.get(i)).value(), "~#", lemmas.get(i), "|||", morphTag);
                    ((Tree)leaves.get(i)).setValue(newLeaf);
                }
                System.out.println(tree.toString());
                ++nTrees;
            }
            assert (!morphIter.hasNext());
            assert (!lemmaIter.hasNext());
            System.err.printf("Processed %d trees%n", nTrees);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class YieldIterator
    implements Iterator<List<String>> {
        private List<String> nextYield = null;
        BufferedReader fileReader = null;
        TreeReader treeReader = null;

        public YieldIterator(String fileName, boolean isTree) {
            try {
                if (isTree) {
                    ArabicTreeReaderFactory.ArabicRawTreeReaderFactory trf = new ArabicTreeReaderFactory.ArabicRawTreeReaderFactory(true);
                    this.treeReader = trf.newTreeReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
                } else {
                    this.fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.primeNext();
        }

        private void primeNext() {
            try {
                if (this.treeReader != null) {
                    Tree tree = this.treeReader.readTree();
                    if (tree == null) {
                        this.nextYield = null;
                    } else {
                        List<CoreLabel> mLabeledLeaves = tree.taggedLabeledYield();
                        this.nextYield = new ArrayList<String>(mLabeledLeaves.size());
                        for (CoreLabel label : mLabeledLeaves) {
                            this.nextYield.add(label.tag());
                        }
                    }
                } else {
                    String line = this.fileReader.readLine();
                    this.nextYield = line == null ? null : Arrays.asList(line.split("\\s+"));
                }
            }
            catch (IOException e) {
                this.nextYield = null;
                e.printStackTrace();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextYield != null;
        }

        @Override
        public List<String> next() {
            if (this.nextYield == null) {
                try {
                    if (this.fileReader != null) {
                        this.fileReader.close();
                        this.fileReader = null;
                    } else if (this.treeReader != null) {
                        this.treeReader.close();
                        this.treeReader = null;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
            List<String> next = this.nextYield;
            this.primeNext();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

