/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.loglinear.storage;

import edu.stanford.nlp.loglinear.model.GraphicalModel;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class ModelBatch
extends ArrayList<GraphicalModel> {
    public ModelBatch() {
    }

    public ModelBatch(String filename) throws IOException {
        this(filename, (GraphicalModel model) -> {});
    }

    public ModelBatch(String filename, Consumer<GraphicalModel> featurizer) throws IOException {
        FileInputStream is = new FileInputStream(filename);
        this.readFrom(is, featurizer);
        ((InputStream)is).close();
    }

    public ModelBatch(InputStream inputStream) throws IOException {
        this(inputStream, (GraphicalModel model) -> {});
    }

    public ModelBatch(InputStream inputStream, Consumer<GraphicalModel> featurizer) throws IOException {
        this.readFrom(inputStream, featurizer);
    }

    private void readFrom(InputStream inputStream, Consumer<GraphicalModel> featurizer) throws IOException {
        GraphicalModel read;
        while ((read = GraphicalModel.readFromStream(inputStream)) != null) {
            featurizer.accept(read);
            this.add(read);
        }
    }

    public void writeToFile(String filename) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        this.writeToStream(fos);
        fos.close();
    }

    public void writeToFileWithoutFactors(String filename) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        this.writeToStreamWithoutFactors(fos);
        fos.close();
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        for (GraphicalModel model : this) {
            model.writeToStream(outputStream);
        }
    }

    public void writeToStreamWithoutFactors(OutputStream outputStream) throws IOException {
        HashSet<GraphicalModel.Factor> emptySet = new HashSet<GraphicalModel.Factor>();
        for (GraphicalModel model : this) {
            Set<GraphicalModel.Factor> cachedFactors = model.factors;
            model.factors = emptySet;
            model.writeToStream(outputStream);
            model.factors = cachedFactors;
        }
    }
}

