/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.naturalli.Util;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class UtilTest {
    private CoreLabel mkLabel(String word, String ner) {
        CoreLabel label = new CoreLabel();
        label.setWord(word);
        label.setOriginalText(word);
        label.setNER(ner);
        return label;
    }

    private List<CoreLabel> mockLabels(String input) {
        return Arrays.stream(input.split(" ")).map(x -> x.indexOf("_") > 0 ? this.mkLabel(x.substring(0, x.indexOf("_")), x.substring(x.indexOf("_") + 1)) : this.mkLabel((String)x, "O")).collect(Collectors.toList());
    }

    @Test
    public void guessNERSpan() {
        Assert.assertEquals((Object)"O", (Object)Util.guessNER(this.mockLabels("the black cat"), new Span(0, 3)));
        Assert.assertEquals((Object)"PERSON", (Object)Util.guessNER(this.mockLabels("the president Obama_PERSON"), new Span(0, 3)));
        Assert.assertEquals((Object)"TITLE", (Object)Util.guessNER(this.mockLabels("the President_TITLE Obama_PERSON"), new Span(0, 2)));
        Assert.assertEquals((Object)"PERSON", (Object)Util.guessNER(this.mockLabels("the President_TITLE Obama_PERSON"), new Span(2, 3)));
        Assert.assertEquals((Object)"PERSON", (Object)Util.guessNER(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON"), new Span(0, 4)));
    }

    @Test
    public void guessNER() {
        Assert.assertEquals((Object)"O", (Object)Util.guessNER(this.mockLabels("the black cat")));
        Assert.assertEquals((Object)"PERSON", (Object)Util.guessNER(this.mockLabels("the president Obama_PERSON")));
        Assert.assertEquals((Object)"PERSON", (Object)Util.guessNER(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON")));
    }

    @Test
    public void extractNER() {
        Assert.assertEquals((Object)"O", (Object)Util.guessNER(this.mockLabels("the black cat")));
        Assert.assertEquals((Object)new Span(2, 3), (Object)Util.extractNER(this.mockLabels("the president Obama_PERSON"), new Span(2, 3)));
        Assert.assertEquals((Object)new Span(2, 3), (Object)Util.extractNER(this.mockLabels("the president Obama_PERSON"), new Span(1, 3)));
        Assert.assertEquals((Object)new Span(2, 3), (Object)Util.extractNER(this.mockLabels("the president Obama_PERSON"), new Span(0, 3)));
        Assert.assertEquals((Object)new Span(2, 4), (Object)Util.extractNER(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON"), new Span(2, 4)));
        Assert.assertEquals((Object)new Span(2, 4), (Object)Util.extractNER(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON"), new Span(2, 3)));
        Assert.assertEquals((Object)new Span(1, 2), (Object)Util.extractNER(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON"), new Span(0, 2)));
        Assert.assertEquals((Object)new Span(1, 2), (Object)Util.extractNER(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON visited China_LOCATION"), new Span(0, 2)));
        Assert.assertEquals((Object)new Span(2, 4), (Object)Util.extractNER(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON visited China_LOCATION"), new Span(2, 5)));
        Assert.assertEquals((Object)new Span(2, 4), (Object)Util.extractNER(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON visited China_LOCATION"), new Span(2, 6)));
        Assert.assertEquals((Object)new Span(5, 6), (Object)Util.extractNER(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON visited China_LOCATION"), new Span(5, 6)));
        Assert.assertEquals((Object)new Span(5, 6), (Object)Util.extractNER(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON visited China_LOCATION"), new Span(4, 6)));
    }

    @Test
    public void extractNERDifferingTypes() {
        Assert.assertEquals((Object)new Span(2, 4), (Object)Util.extractNER(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON visited China_LOCATION"), new Span(0, 5)));
        Assert.assertEquals((Object)new Span(5, 10), (Object)Util.extractNER(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON visited The_LOCATION Peoples_LOCATION Republic_LOCATION of_LOCATION China_LOCATION"), new Span(0, 10)));
    }

    @Test
    public void extractNERNoNER() {
        Assert.assertEquals((Object)new Span(0, 1), (Object)Util.extractNER(this.mockLabels("the President_TITLE"), new Span(0, 1)));
        Assert.assertEquals((Object)new Span(0, 1), (Object)Util.extractNER(this.mockLabels("the honorable President_TITLE"), new Span(0, 1)));
        Assert.assertEquals((Object)new Span(0, 2), (Object)Util.extractNER(this.mockLabels("the honorable President_TITLE"), new Span(0, 2)));
        Assert.assertEquals((Object)new Span(0, 2), (Object)Util.extractNER(this.mockLabels("the honorable Mr. President_TITLE"), new Span(0, 2)));
        Assert.assertEquals((Object)new Span(1, 2), (Object)Util.extractNER(this.mockLabels("the honorable Mr. President_TITLE"), new Span(1, 2)));
    }

    @Test
    public void nerOverlap() {
        Assert.assertEquals((Object)true, (Object)Util.nerOverlap(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON visited China_LOCATION"), new Span(0, 1), new Span(0, 1)));
        Assert.assertEquals((Object)true, (Object)Util.nerOverlap(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON visited China_LOCATION"), new Span(1, 2), new Span(1, 2)));
        Assert.assertEquals((Object)true, (Object)Util.nerOverlap(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON visited China_LOCATION"), new Span(1, 2), new Span(0, 2)));
        Assert.assertEquals((Object)false, (Object)Util.nerOverlap(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON visited China_LOCATION"), new Span(1, 2), new Span(2, 4)));
        Assert.assertEquals((Object)true, (Object)Util.nerOverlap(this.mockLabels("the President_TITLE Barack_PERSON Obama_PERSON visited China_LOCATION"), new Span(1, 4), new Span(2, 4)));
    }
}

