/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.LexicalizedParserQuery;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTKLatticeReader {
    private static Redwood.RedwoodChannels log = Redwood.channels(HTKLatticeReader.class);
    public final boolean DEBUG;
    public final boolean PRETTYPRINT;
    public static final boolean USESUM = true;
    public static final boolean USEMAX = false;
    private final boolean mergeType;
    public static final String SILENCE = "<SIL>";
    private int numStates;
    private List<LatticeWord> latticeWords;
    private int[] nodeTimes;
    private ArrayList<LatticeWord>[] wordsAtTime;
    private ArrayList<LatticeWord>[] wordsStartAt;
    private ArrayList<LatticeWord>[] wordsEndAt;

    private void readInput(BufferedReader in) throws Exception {
        String line = in.readLine();
        while (line.trim().startsWith("#")) {
            line = in.readLine();
        }
        this.latticeWords = new ArrayList<LatticeWord>();
        Pattern wordLinePattern = Pattern.compile("(\\d+)\\s+(\\d+)\\s+lm=(-?\\d+\\.\\d+),am=(-?\\d+\\.\\d+)\\s+([^( ]+)(?:\\((\\d+)\\))?.*");
        Matcher wordLineMatcher = wordLinePattern.matcher(line);
        while (wordLineMatcher.matches()) {
            int startNode = Integer.parseInt(wordLineMatcher.group(1)) - 1;
            int endNode = Integer.parseInt(wordLineMatcher.group(2)) - 1;
            double lm = Double.parseDouble(wordLineMatcher.group(3));
            double am = Double.parseDouble(wordLineMatcher.group(4));
            String word = wordLineMatcher.group(5).toLowerCase();
            String pronun = wordLineMatcher.group(6);
            if (word.equalsIgnoreCase("<s>")) {
                line = in.readLine();
                wordLineMatcher = wordLinePattern.matcher(line);
                continue;
            }
            if (word.equalsIgnoreCase("</s>")) {
                word = ".$.";
            }
            int pronunciation = pronun == null ? 0 : Integer.parseInt(pronun);
            LatticeWord lw = new LatticeWord(word, startNode, endNode, lm, am, pronunciation, this.mergeType);
            if (this.DEBUG) {
                log.info(lw);
            }
            this.latticeWords.add(lw);
            line = in.readLine();
            wordLineMatcher = wordLinePattern.matcher(line);
        }
        this.numStates = Integer.parseInt(line.trim());
        if (this.DEBUG) {
            log.info(this.numStates);
        }
        this.nodeTimes = new int[this.numStates];
        Pattern nodeTimePattern = Pattern.compile("(\\d+)\\s+t=(\\d+)\\s*");
        for (int i = 0; i < this.numStates; ++i) {
            Matcher nodeTimeMatcher = nodeTimePattern.matcher(in.readLine());
            if (!nodeTimeMatcher.matches()) {
                log.info("Input File Error");
                System.exit(1);
            }
            this.nodeTimes[i] = Integer.parseInt(nodeTimeMatcher.group(2));
            if (!this.DEBUG) continue;
            log.info(i + "\tt=" + this.nodeTimes[i]);
        }
    }

    private void mergeSimultaneousNodes() {
        int[] indexMap = new int[this.nodeTimes.length];
        indexMap[0] = 0;
        int prevNode = 0;
        int prevTime = this.nodeTimes[0];
        if (this.DEBUG) {
            log.info("0 (" + this.nodeTimes[0] + ")-->" + 0 + " (" + this.nodeTimes[0] + ") ++");
        }
        for (int i = 1; i < this.nodeTimes.length; ++i) {
            if (prevTime == this.nodeTimes[i]) {
                indexMap[i] = prevNode;
                if (!this.DEBUG) continue;
                log.info(i + " (" + this.nodeTimes[i] + ")-->" + prevNode + " (" + this.nodeTimes[prevNode] + ") **");
                continue;
            }
            indexMap[i] = prevNode = i;
            prevTime = this.nodeTimes[i];
            if (!this.DEBUG) continue;
            log.info(i + " (" + this.nodeTimes[i] + ")-->" + prevNode + " (" + this.nodeTimes[prevNode] + ") ++");
        }
        for (LatticeWord lw : this.latticeWords) {
            lw.startNode = indexMap[lw.startNode];
            lw.endNode = indexMap[lw.endNode];
            if (!this.DEBUG) continue;
            log.info(lw);
        }
    }

    private void removeEmptyNodes() {
        int[] indexMap = new int[this.numStates];
        int j = 0;
        for (int i = 0; i < this.numStates; ++i) {
            indexMap[i] = j;
            if (this.wordsStartAt[i].size() == 0 && this.wordsEndAt[i].size() == 0) continue;
            ++j;
        }
        for (LatticeWord lw : this.latticeWords) {
            int i;
            this.wordsStartAt[lw.startNode].remove(lw);
            this.wordsEndAt[lw.endNode].remove(lw);
            for (i = lw.startNode; i < lw.endNode; ++i) {
                this.wordsAtTime[i].remove(lw);
            }
            lw.startNode = indexMap[lw.startNode];
            lw.endNode = indexMap[lw.endNode];
            this.wordsStartAt[lw.startNode].add(lw);
            this.wordsEndAt[lw.endNode].add(lw);
            for (i = lw.startNode; i < lw.endNode; ++i) {
                this.wordsAtTime[i].add(lw);
            }
        }
        this.numStates = j;
        ArrayList<LatticeWord>[] tmp = this.wordsAtTime;
        this.wordsAtTime = new ArrayList[this.numStates];
        System.arraycopy(tmp, 0, this.wordsAtTime, 0, this.numStates);
        tmp = this.wordsStartAt;
        this.wordsStartAt = new ArrayList[this.numStates];
        System.arraycopy(tmp, 0, this.wordsStartAt, 0, this.numStates);
        tmp = this.wordsEndAt;
        this.wordsEndAt = new ArrayList[this.numStates];
        System.arraycopy(tmp, 0, this.wordsEndAt, 0, this.numStates);
    }

    private void buildWordTimeArrays() {
        this.buildWordsAtTime();
        this.buildWordsStartAt();
        this.buildWordsEndAt();
    }

    private void buildWordsAtTime() {
        this.wordsAtTime = new ArrayList[this.numStates];
        for (int i = 0; i < this.wordsAtTime.length; ++i) {
            this.wordsAtTime[i] = new ArrayList();
        }
        for (LatticeWord lw : this.latticeWords) {
            for (int j = lw.startNode; j <= lw.endNode; ++j) {
                this.wordsAtTime[j].add(lw);
            }
        }
    }

    private void buildWordsStartAt() {
        this.wordsStartAt = new ArrayList[this.numStates];
        for (int i = 0; i < this.wordsStartAt.length; ++i) {
            this.wordsStartAt[i] = new ArrayList();
        }
        for (LatticeWord lw : this.latticeWords) {
            this.wordsStartAt[lw.startNode].add(lw);
        }
    }

    private void buildWordsEndAt() {
        this.wordsEndAt = new ArrayList[this.numStates];
        for (int i = 0; i < this.wordsEndAt.length; ++i) {
            this.wordsEndAt[i] = new ArrayList();
        }
        for (LatticeWord lw : this.latticeWords) {
            this.wordsEndAt[lw.endNode].add(lw);
        }
    }

    private void removeRedundency() {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (ArrayList<LatticeWord> aWordsAtTime : this.wordsAtTime) {
                if (aWordsAtTime.size() < 2) continue;
                block2: for (int j = 0; j < aWordsAtTime.size() - 1; ++j) {
                    LatticeWord w1 = aWordsAtTime.get(j);
                    for (int k = j + 1; k < aWordsAtTime.size(); ++k) {
                        LatticeWord w2 = aWordsAtTime.get(k);
                        if (!w1.word.equalsIgnoreCase(w2.word) || !this.removeRedundentPair(w1, w2)) continue;
                        changed = true;
                        continue block2;
                    }
                }
            }
        }
    }

    private boolean removeRedundentPair(LatticeWord w1, LatticeWord w2) {
        int oldEnd;
        int newEnd;
        int oldStart;
        int newStart;
        if (this.DEBUG) {
            log.info("trying to remove:");
            log.info(w1);
            log.info(w2);
        }
        int w1Start = w1.startNode;
        int w2Start = w2.startNode;
        int w1End = w1.endNode;
        int w2End = w2.endNode;
        if (w1Start < w2Start) {
            newStart = w2Start;
            oldStart = w1Start;
        } else {
            newStart = w1Start;
            oldStart = w2Start;
        }
        if (w1End < w2End) {
            newEnd = w1End;
            oldEnd = w2End;
        } else {
            newEnd = w2End;
            oldEnd = w1End;
        }
        for (LatticeWord lw : this.wordsStartAt[oldStart]) {
            if (lw.endNode >= newStart && (lw.endNode != newStart || lw.endNode == lw.startNode)) continue;
            if (this.DEBUG) {
                log.info("failed");
            }
            return false;
        }
        for (LatticeWord lw : this.wordsEndAt[oldEnd]) {
            if (lw.startNode <= newEnd && (lw.startNode != newEnd || lw.endNode == lw.startNode)) continue;
            if (this.DEBUG) {
                log.info("failed");
            }
            return false;
        }
        this.changeStartTimes(this.wordsStartAt[oldEnd], newEnd);
        this.changeEndTimes(this.wordsEndAt[oldStart], newStart);
        this.changeStartTimes(this.wordsStartAt[oldStart], newStart);
        this.changeEndTimes(this.wordsEndAt[oldEnd], newEnd);
        if (this.DEBUG) {
            log.info("succeeded");
        }
        return true;
    }

    private void changeStartTimes(List<LatticeWord> words, int newStartTime) {
        ArrayList<LatticeWord> toRemove = new ArrayList<LatticeWord>();
        for (LatticeWord lw : words) {
            int i;
            this.latticeWords.remove(lw);
            int oldStartTime = lw.startNode;
            lw.startNode = newStartTime;
            if (this.latticeWords.contains(lw)) {
                if (this.DEBUG) {
                    log.info("duplicate found");
                }
                LatticeWord twin = this.latticeWords.get(this.latticeWords.indexOf(lw));
                lw.startNode = oldStartTime;
                twin.merge(lw);
                toRemove.add(lw);
                this.wordsEndAt[lw.endNode].remove(lw);
                for (int i2 = lw.startNode; i2 <= lw.endNode; ++i2) {
                    this.wordsAtTime[i2].remove(lw);
                }
                continue;
            }
            if (oldStartTime < newStartTime) {
                for (i = oldStartTime; i < newStartTime; ++i) {
                    this.wordsAtTime[i].remove(lw);
                }
            } else {
                for (i = newStartTime; i < oldStartTime; ++i) {
                    this.wordsAtTime[i].add(lw);
                }
            }
            this.latticeWords.add(lw);
            if (oldStartTime == newStartTime) continue;
            toRemove.add(lw);
            this.wordsStartAt[newStartTime].add(lw);
        }
        words.removeAll(toRemove);
    }

    private void changeEndTimes(List<LatticeWord> words, int newEndTime) {
        ArrayList<LatticeWord> toRemove = new ArrayList<LatticeWord>();
        for (LatticeWord lw : words) {
            int i;
            this.latticeWords.remove(lw);
            int oldEndTime = lw.endNode;
            lw.endNode = newEndTime;
            if (this.latticeWords.contains(lw)) {
                if (this.DEBUG) {
                    log.info("duplicate found");
                }
                LatticeWord twin = this.latticeWords.get(this.latticeWords.indexOf(lw));
                lw.endNode = oldEndTime;
                twin.merge(lw);
                this.wordsStartAt[lw.startNode].remove(lw);
                toRemove.add(lw);
                for (int i2 = lw.startNode; i2 <= lw.endNode; ++i2) {
                    this.wordsAtTime[i2].remove(lw);
                }
                continue;
            }
            if (oldEndTime > newEndTime) {
                for (i = newEndTime + 1; i <= oldEndTime; ++i) {
                    this.wordsAtTime[i].remove(lw);
                }
            } else {
                for (i = oldEndTime + 1; i <= newEndTime; ++i) {
                    this.wordsAtTime[i].add(lw);
                }
            }
            this.latticeWords.add(lw);
            if (oldEndTime == newEndTime) continue;
            toRemove.add(lw);
            this.wordsEndAt[newEndTime].add(lw);
        }
        words.removeAll(toRemove);
    }

    private void removeSilence() {
        ArrayList<LatticeWord> silences = new ArrayList<LatticeWord>();
        for (LatticeWord lw : this.latticeWords) {
            if (!lw.word.equalsIgnoreCase(SILENCE)) continue;
            silences.add(lw);
        }
        for (LatticeWord lw : silences) {
            this.changeEndTimes(this.wordsEndAt[lw.startNode], lw.endNode);
        }
        silences.clear();
        for (LatticeWord lw : this.latticeWords) {
            if (!lw.word.equalsIgnoreCase(SILENCE)) continue;
            silences.add(lw);
        }
        for (LatticeWord lw : silences) {
            if (!lw.word.equalsIgnoreCase(SILENCE)) continue;
            this.latticeWords.remove(lw);
            this.wordsStartAt[lw.startNode].remove(lw);
            this.wordsEndAt[lw.endNode].remove(lw);
            for (int j = lw.startNode; j <= lw.endNode; ++j) {
                this.wordsAtTime[j].remove(lw);
            }
        }
    }

    private int mergeDuplicates() {
        int numMerged = 0;
        for (int i = 0; i < this.latticeWords.size() - 1; ++i) {
            LatticeWord first = this.latticeWords.get(i);
            for (int j = i + 1; j < this.latticeWords.size(); ++j) {
                LatticeWord second = this.latticeWords.get(j);
                if (!first.equals(second)) continue;
                if (this.DEBUG) {
                    log.info("removed duplicate");
                }
                first.merge(second);
                this.latticeWords.remove(j);
                this.wordsStartAt[second.startNode].remove(second);
                this.wordsEndAt[second.endNode].remove(second);
                for (int k = second.startNode; k <= second.endNode; ++k) {
                    this.wordsAtTime[k].remove(second);
                }
                ++numMerged;
                --j;
            }
        }
        return numMerged;
    }

    public void printWords() {
        Collections.sort(this.latticeWords);
        System.out.println("Words: ");
        for (LatticeWord lw : this.latticeWords) {
            System.out.println(lw);
        }
    }

    private double getProb(LatticeWord lw) {
        return lw.am * 100.0 + lw.lm;
    }

    public void processLattice() {
        this.buildWordTimeArrays();
        this.removeSilence();
        this.mergeDuplicates();
        this.removeRedundency();
        this.removeEmptyNodes();
        if (this.PRETTYPRINT) {
            this.printWords();
        }
    }

    public HTKLatticeReader(String filename) throws Exception {
        this(filename, true, false, false);
    }

    public HTKLatticeReader(String filename, boolean mergeType) throws Exception {
        this(filename, mergeType, false, false);
    }

    public HTKLatticeReader(String filename, boolean mergeType, boolean debug, boolean prettyPrint) throws Exception {
        this.DEBUG = debug;
        this.PRETTYPRINT = prettyPrint;
        this.mergeType = mergeType;
        try (BufferedReader in = IOUtils.readerFromString(filename);){
            this.readInput(in);
            if (this.PRETTYPRINT) {
                this.printWords();
            }
            this.processLattice();
        }
    }

    public List<LatticeWord> getLatticeWords() {
        return this.latticeWords;
    }

    public int getNumStates() {
        return this.numStates;
    }

    public List<LatticeWord> getWordsOverSpan(int a, int b) {
        ArrayList<LatticeWord> words = new ArrayList<LatticeWord>();
        for (LatticeWord lw : this.wordsStartAt[a]) {
            if (lw.endNode != b) continue;
            words.add(lw);
        }
        return words;
    }

    public static void main(String[] args) throws Exception {
        boolean mergeType = true;
        boolean prettyPrint = true;
        boolean debug = false;
        String parseGram = null;
        String filename = args[0];
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-debug")) {
                debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-useMax")) {
                mergeType = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-useSum")) {
                mergeType = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-noPrettyPrint")) {
                prettyPrint = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-parser")) {
                parseGram = args[++i];
                continue;
            }
            log.info("unrecognized flag: " + args[i]);
            log.info("usage: java LatticeReader <file> [ -debug ] [ -useMax ] [ -useSum ] [ -noPrettyPrint ] [ -parser parserFile ]");
            System.exit(0);
        }
        HTKLatticeReader lr = new HTKLatticeReader(filename, mergeType, debug, prettyPrint);
        if (parseGram != null) {
            Options op = new Options();
            op.doDep = false;
            op.testOptions.maxLength = 80;
            op.testOptions.maxSpanForTags = 80;
            LexicalizedParser lp = LexicalizedParser.loadModel(parseGram, op, new String[0]);
            LexicalizedParserQuery pq = lp.lexicalizedParserQuery();
            pq.parse(lr);
            Tree t = pq.getBestParse();
            t.pennPrint();
        }
    }

    public static class LatticeWord
    implements Comparable<LatticeWord> {
        public String word;
        public int startNode;
        public int endNode;
        public double lm;
        public double am;
        public int pronunciation;
        public final boolean mergeType;

        public LatticeWord(String word, int startNode, int endNode, double lm, double am, int pronunciation, boolean mergeType) {
            this.word = word;
            this.startNode = startNode;
            this.endNode = endNode;
            this.lm = lm;
            this.am = am;
            this.pronunciation = pronunciation;
            this.mergeType = mergeType;
        }

        public void merge(LatticeWord lw) {
            if (!this.mergeType) {
                lw.am = this.am = Math.max(this.am, lw.am);
            } else if (this.mergeType) {
                double tmp = lw.am;
                lw.am += this.am;
                this.am += tmp;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.startNode).append("\t");
            sb.append(this.endNode).append("\t");
            sb.append("lm=").append(this.lm).append(",");
            sb.append("am=").append(this.am).append("\t");
            sb.append(this.word);
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof LatticeWord)) {
                return false;
            }
            LatticeWord other = (LatticeWord)o;
            if (!this.word.equalsIgnoreCase(other.word)) {
                return false;
            }
            if (this.startNode != other.startNode) {
                return false;
            }
            return this.endNode == other.endNode;
        }

        @Override
        public int compareTo(LatticeWord other) {
            if (this.startNode < other.startNode) {
                return -1;
            }
            if (this.startNode > other.startNode) {
                return 1;
            }
            if (this.endNode < other.endNode) {
                return -1;
            }
            if (this.endNode > other.endNode) {
                return 1;
            }
            return 0;
        }
    }
}

