/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceParser;
import edu.stanford.nlp.parser.shiftreduce.ShiftTransition;
import edu.stanford.nlp.parser.shiftreduce.State;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;

public class ShiftTransitionTest
extends TestCase {
    public void testTransition() {
        String[] words = new String[]{"This", "is", "a", "short", "test", "."};
        String[] tags = new String[]{"DT", "VBZ", "DT", "JJ", "NN", "."};
        ShiftTransitionTest.assertEquals((int)words.length, (int)tags.length);
        ArrayList<TaggedWord> sentence = SentenceUtils.toTaggedList(Arrays.asList(words), Arrays.asList(tags));
        State state = ShiftReduceParser.initialStateFromTaggedSentence(sentence);
        ShiftTransition shift = new ShiftTransition();
        for (int i = 0; i < 3; ++i) {
            state = shift.apply(state);
        }
        ShiftTransitionTest.assertEquals((int)3, (int)state.tokenPosition);
    }
}

