/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.SegmenterCoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChineseAnnotationPipelineITest {
    AnnotationPipeline pipeline;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        Class<ChineseAnnotationPipelineITest> clazz = ChineseAnnotationPipelineITest.class;
        synchronized (ChineseAnnotationPipelineITest.class) {
            if (this.pipeline == null) {
                this.pipeline = new StanfordCoreNLP("StanfordCoreNLP-chinese.properties");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Test
    public void testFullPipeline() {
        String query = "\u4f60\u9a6c\u4e0a\u56de\u6765\u5317\u4eac\u5417\uff1f";
        String[] expectedWords = new String[]{"\u4f60", "\u9a6c\u4e0a", "\u56de\u6765", "\u5317\u4eac", "\u5417", "\uff1f"};
        String[] expectedCharacters = new String[]{"\u4f60", "\u9a6c", "\u4e0a", "\u56de", "\u6765", "\u5317", "\u4eac", "\u5417", "\uff1f"};
        boolean[] expectedSegs = new boolean[]{true, true, false, true, false, true, false, true, true};
        String[] expectedNer = new String[]{"O", "O", "O", "STATE_OR_PROVINCE", "O", "O"};
        Assert.assertEquals((long)expectedCharacters.length, (long)expectedSegs.length);
        Assert.assertEquals((long)expectedWords.length, (long)expectedNer.length);
        Annotation ann = new Annotation(query);
        this.pipeline.annotate(ann);
        List sentences = (List)ann.get(CoreAnnotations.SentencesAnnotation.class);
        Assert.assertFalse((sentences == null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)sentences.size());
        List tokens = (List)((CoreMap)sentences.get(0)).get(CoreAnnotations.TokensAnnotation.class);
        Assert.assertEquals((long)expectedWords.length, (long)tokens.size());
        for (int i = 0; i < expectedWords.length; ++i) {
            Assert.assertEquals((Object)expectedWords[i], (Object)((CoreLabel)tokens.get(i)).word());
            Assert.assertEquals((Object)expectedNer[i], (Object)((CoreLabel)tokens.get(i)).ner());
        }
        List characters = (List)ann.get(SegmenterCoreAnnotations.CharactersAnnotation.class);
        Assert.assertEquals((long)expectedCharacters.length, (long)characters.size());
        for (int i = 0; i < expectedCharacters.length; ++i) {
            CoreLabel word = (CoreLabel)characters.get(i);
            Assert.assertEquals((Object)expectedCharacters[i], word.get(CoreAnnotations.ChineseCharAnnotation.class));
            Assert.assertEquals((Object)(expectedSegs[i] ? "1" : "0"), word.get(CoreAnnotations.ChineseSegAnnotation.class));
        }
    }

    @Test
    public void testTwoSentences() {
        String query = "\u4f60\u9a6c\u4e0a\u56de\u6765\u5317\u4eac\u5417\uff1f\u6211\u8981\u56de\u53bb\u7f8e\u56fd\u3002";
        Annotation ann = new Annotation(query);
        this.pipeline.annotate(ann);
        List sentences = (List)ann.get(CoreAnnotations.SentencesAnnotation.class);
        Assert.assertFalse((sentences == null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)sentences.size());
        String[][] expectedWords = new String[][]{{"\u4f60", "\u9a6c\u4e0a", "\u56de\u6765", "\u5317\u4eac", "\u5417", "\uff1f"}, {"\u6211", "\u8981", "\u56de\u53bb", "\u7f8e\u56fd", "\u3002"}};
        int[][] expectedPositions = new int[][]{{0, 1, 3, 5, 7, 8, 9}, {9, 10, 11, 13, 15, 16}};
        for (int i = 0; i < 2; ++i) {
            List tokens = (List)((CoreMap)sentences.get(i)).get(CoreAnnotations.TokensAnnotation.class);
            Assert.assertEquals((long)expectedWords[i].length, (long)tokens.size());
            for (int j = 0; j < expectedWords.length; ++j) {
                Assert.assertEquals((Object)expectedWords[i][j], (Object)((CoreLabel)tokens.get(j)).word());
                Assert.assertEquals((long)expectedPositions[i][j], (long)((CoreLabel)tokens.get(j)).beginPosition());
                Assert.assertEquals((long)expectedPositions[i][j + 1], (long)((CoreLabel)tokens.get(j)).endPosition());
            }
        }
    }
}

