/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.ChapterAnnotator;
import edu.stanford.nlp.quoteattribution.XMLToAnnotation;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class QuoteAttributionEvaluation {
    private static final String[] mentionKeyOrder = new String[]{"trigram CVQ", "trigram VCQ", "trigram PVQ", "trigram VPQ", "trigram QVC", "trigram QCV", "trigram QVP", "trigram QPV", "Deterministic depparse", "Deterministic oneNameSentence", "Deterministic Vocative -- name", "Deterministic Vocative -- animate noun", "Deterministic endQuoteClosestBefore", "Deterministic one speaker sentence", "supervised", "conv", "loose", null};
    private static final String[] speakerKeyOrder = new String[]{"automatic name", "coref", "Baseline Top conversation - prev", "Baseline Top conversation - next", "Baseline Top family animate", "Baseline Top"};

    private static String outputMapResultsDefaultKeys(Map<String, Counter<Result>> tagResults, String[] keyOrder) {
        StringBuilder output = new StringBuilder();
        Result[] order = new Result[]{Result.CORRECT, Result.INCORRECT, Result.SKIPPED};
        for (String tag : keyOrder) {
            double numIncorrect;
            Counter<Result> resultsCounter = tagResults.get(tag);
            if (resultsCounter == null) continue;
            if (tag == null) {
                output.append("No label\t");
            } else {
                output.append(tag + "\t");
            }
            for (Result result : order) {
                output.append(result.toString() + "\t" + resultsCounter.getCount((Object)result) + "\t");
            }
            double numCorrect = resultsCounter.getCount((Object)Result.CORRECT);
            double total = numCorrect + (numIncorrect = resultsCounter.getCount((Object)Result.INCORRECT));
            double precision = total == 0.0 ? 0.0 : numCorrect / total;
            output.append(total + "\t" + precision + "\n");
        }
        return output.toString();
    }

    private static int getQuoteChapter(Annotation doc, CoreMap quote) {
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        return (Integer)((CoreMap)sentences.get((Integer)quote.get(CoreAnnotations.SentenceBeginAnnotation.class))).get(ChapterAnnotator.ChapterAnnotation.class);
    }

    private static void evaluate(Annotation doc, List<XMLToAnnotation.GoldQuoteInfo> goldList) {
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        HashMap<String, Counter<Result>> mentionPredTypeResults = new HashMap<String, Counter<Result>>();
        HashMap<String, Counter<Result>> speakerPredTypeResults = new HashMap<String, Counter<Result>>();
        ClassicCounter<Result> mentionResults = new ClassicCounter<Result>();
        ClassicCounter<Result> speakerResults = new ClassicCounter<Result>();
        for (int i = 0; i < quotes.size(); ++i) {
            CoreMap quote = (CoreMap)quotes.get(i);
            XMLToAnnotation.GoldQuoteInfo gold = goldList.get(i);
            if (gold.speaker.equals("UNSURE") || gold.speaker.equals("NOTANUTTERANCE") || gold.mentionStartTokenIndex == -1) continue;
            String speakerPred = (String)quote.get(QuoteAttributionAnnotator.SpeakerAnnotation.class);
            Integer mentionBeginPred = (Integer)quote.get(QuoteAttributionAnnotator.MentionBeginAnnotation.class);
            Integer mentionEndPred = (Integer)quote.get(QuoteAttributionAnnotator.MentionEndAnnotation.class);
            Result mentionResult = mentionBeginPred == null ? Result.SKIPPED : (gold.mentionStartTokenIndex <= mentionBeginPred && gold.mentionEndTokenIndex >= mentionEndPred || gold.mentionStartTokenIndex <= mentionEndPred && gold.mentionEndTokenIndex >= mentionEndPred ? Result.CORRECT : Result.INCORRECT);
            Result speakerResult = speakerPred == null ? Result.SKIPPED : (speakerPred.equals(gold.speaker) ? Result.CORRECT : Result.INCORRECT);
            boolean verbose = true;
            if (verbose) {
                if (!mentionResult.equals((Object)Result.CORRECT) || !speakerResult.equals((Object)Result.CORRECT)) {
                    System.out.println("====");
                    System.out.println("Id: " + i + " Quote: " + (String)quote.get(CoreAnnotations.TextAnnotation.class));
                    System.out.println("Speaker: " + goldList.get((int)i).speaker + " Predicted: " + (String)quote.get(QuoteAttributionAnnotator.SpeakerAnnotation.class) + " " + speakerResult.name());
                    System.out.println("Speaker Tag: " + (String)quote.get(QuoteAttributionAnnotator.SpeakerSieveAnnotation.class));
                    System.out.println("Gold Mention: " + gold.mention);
                    if (mentionResult.equals((Object)Result.INCORRECT)) {
                        System.out.println("Predicted Mention: " + (String)quote.get(QuoteAttributionAnnotator.MentionAnnotation.class) + " INCORRECT");
                        System.out.println("Mention Tag: " + (String)quote.get(QuoteAttributionAnnotator.MentionSieveAnnotation.class));
                    } else if (mentionResult.equals((Object)Result.SKIPPED)) {
                        System.out.println("Mention SKIPPED");
                    } else {
                        System.out.println("Gold Mention: " + (String)quote.get(QuoteAttributionAnnotator.MentionAnnotation.class) + " CORRECT");
                        System.out.println("Mention tag: " + (String)quote.get(QuoteAttributionAnnotator.MentionSieveAnnotation.class));
                    }
                } else {
                    System.out.println("====");
                    System.out.println("Id: " + i + " Quote: " + (String)quote.get(CoreAnnotations.TextAnnotation.class));
                    System.out.println("Mention Tag: " + (String)quote.get(QuoteAttributionAnnotator.MentionSieveAnnotation.class) + " Speaker Tag: " + (String)quote.get(QuoteAttributionAnnotator.SpeakerSieveAnnotation.class));
                    System.out.println("Speaker: " + (String)quote.get(QuoteAttributionAnnotator.SpeakerAnnotation.class) + " Mention: " + (String)quote.get(QuoteAttributionAnnotator.MentionAnnotation.class));
                    System.out.println("ALL CORRECT");
                }
            }
            mentionResults.incrementCount(mentionResult);
            speakerResults.incrementCount(speakerResult);
            mentionPredTypeResults.putIfAbsent((String)quote.get(QuoteAttributionAnnotator.MentionSieveAnnotation.class), new ClassicCounter());
            ((Counter)mentionPredTypeResults.get(quote.get(QuoteAttributionAnnotator.MentionSieveAnnotation.class))).incrementCount(mentionResult);
            speakerPredTypeResults.putIfAbsent((String)quote.get(QuoteAttributionAnnotator.SpeakerSieveAnnotation.class), new ClassicCounter());
            ((Counter)speakerPredTypeResults.get(quote.get(QuoteAttributionAnnotator.SpeakerSieveAnnotation.class))).incrementCount(speakerResult);
        }
        double mCorrect = mentionResults.getCount((Object)Result.CORRECT);
        double mIncorrect = mentionResults.getCount((Object)Result.INCORRECT);
        double mSkipped = mentionResults.getCount((Object)Result.SKIPPED);
        double mPrecision = mCorrect / (mCorrect + mIncorrect);
        double mRecall = mCorrect / (mCorrect + mSkipped);
        double mF1 = 2.0 * (mPrecision * mRecall) / (mPrecision + mRecall);
        double mAccuracy = mCorrect / (mCorrect + mIncorrect + mSkipped);
        double sCorrect = speakerResults.getCount((Object)Result.CORRECT);
        double sIncorrect = speakerResults.getCount((Object)Result.INCORRECT);
        double sSkipped = speakerResults.getCount((Object)Result.SKIPPED);
        double sPrecision = sCorrect / (sCorrect + sIncorrect);
        double sRecall = sCorrect / (sCorrect + sSkipped);
        double sF1 = 2.0 * (sPrecision * sRecall) / (sPrecision + sRecall);
        double sAccuracy = sCorrect / (sCorrect + sIncorrect + sSkipped);
        System.out.println(QuoteAttributionEvaluation.outputMapResultsDefaultKeys(mentionPredTypeResults, mentionKeyOrder));
        System.out.println(QuoteAttributionEvaluation.outputMapResultsDefaultKeys(speakerPredTypeResults, speakerKeyOrder));
        System.out.printf("Mention C:%d\tI:%d\tS:%d\tP:%.3f\tR:%.3f\tF1:%.3f\tA:%.3f\t\tSpeaker C:%d\tI:%d\tS:%d\tP:%.3f\tR:%.3f\tF1:%.3f\tA:%.3f\n", (int)mCorrect, (int)mIncorrect, (int)mSkipped, mPrecision, mRecall, mF1, mAccuracy, (int)sCorrect, (int)sIncorrect, (int)sSkipped, sPrecision, sRecall, sF1, sAccuracy);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: java QuoteAttributionEvaluation path_to_properties_file");
            System.exit(1);
        }
        String specificFile = args[0];
        System.out.println("Using properties file: " + specificFile);
        Properties props = StringUtils.propFileToProperties(specificFile);
        XMLToAnnotation.Data data = XMLToAnnotation.readXMLFormat(props.getProperty("file"));
        Properties annotatorProps = new Properties();
        annotatorProps.setProperty("charactersPath", props.getProperty("charactersPath"));
        annotatorProps.setProperty("booknlpCoref", props.getProperty("booknlpCoref"));
        annotatorProps.setProperty("familyWordsFile", props.getProperty("familyWordsFile"));
        annotatorProps.setProperty("animacyWordsFile", props.getProperty("animacyWordsFile"));
        annotatorProps.setProperty("genderNamesFile", props.getProperty("genderNamesFile"));
        annotatorProps.setProperty("modelPath", props.getProperty("modelPath"));
        QuoteAttributionAnnotator qaa = new QuoteAttributionAnnotator(annotatorProps);
        qaa.annotate(data.doc);
        QuoteAttributionEvaluation.evaluate(data.doc, data.goldList);
    }

    private static enum Result {
        SKIPPED,
        CORRECT,
        INCORRECT;

    }
}

