/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class SetRoots
extends SsurgeonEdit {
    public static final String LABEL = "setRoots";
    List<String> newRootNames;

    public SetRoots(List<String> newRootNames) {
        this.newRootNames = newRootNames;
    }

    @Override
    public void evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        ArrayList<IndexedWord> newRoots = new ArrayList<IndexedWord>();
        for (String name : this.newRootNames) {
            newRoots.add(this.getNamedNode(name, sm));
        }
        sg.setRoots(newRoots);
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        for (String name : this.newRootNames) {
            buf.write("\t");
            buf.write(name);
        }
        return buf.toString();
    }

    public static void main(String[] args) {
    }
}

