/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.ModCollinsHeadFinder;
import edu.stanford.nlp.trees.Tree;
import junit.framework.TestCase;

public class ModCollinsHeadFinderTest
extends TestCase {
    private HeadFinder hf = new ModCollinsHeadFinder();
    private Tree[] testTrees = new Tree[]{Tree.valueOf("(PRN (: --) (S-ADV (NP-SBJ (DT that)) (VP (VBZ is))) (, ,) (SQ (MD can) (NP-SBJ (NP (DT the) (NN network)) (ADVP (RB alone))) (VP (VB make) (NP (DT a) (NN profit)) (PP-CLR (IN on) (NP (PRP it))))))))))))"), Tree.valueOf("(NP (NP (NML (DT the) (NNP Secretary)) (POS 's)) (NML (`` ``) (JJ discretionary) (NN fund) (, ,) ('' '')))"), Tree.valueOf("(S (NP (NP (NNP Sam)) (, ,) (NP (PRP$ my) (NN brother)) (, ,)) (VP (VBZ eats) (NP (JJ red) (NN meat))) (. .))"), Tree.valueOf("(NP (NP (DT The) (JJ Australian) (NNP Broadcasting) (NNP Corporation)) (PRN (-LRB- -LRB-) (NP (NNP ABC)) (-RRB- -RRB-)) (. .))"), Tree.valueOf("(PRN (-LRB- -LRB-) (NP (NNP ABC)) (-RRB- -RRB-))"), Tree.valueOf("(NP (. .) (. .) (VBZ eats) (. .) (. .))"), Tree.valueOf("(PP (SYM -) (NP (CD 3))))")};
    private String[] hfHeads = new String[]{"SQ", "NML", "VP", "NP", "NP", "VBZ", "SYM"};

    private void runTesting(HeadFinder hf, String[] heads) {
        ModCollinsHeadFinderTest.assertEquals((String)"Test arrays out of balance", (int)this.testTrees.length, (int)heads.length);
        for (int i = 0; i < this.testTrees.length; ++i) {
            Tree h = hf.determineHead(this.testTrees[i]);
            String headCat = h.value();
            ModCollinsHeadFinderTest.assertEquals((String)"Wrong head found", (String)heads[i], (String)headCat);
        }
    }

    public void testModCollinsHeadFinder() {
        this.runTesting(this.hf, this.hfHeads);
    }
}

