/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.DeltaCollectionValuedMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class CollectionValuedMapTest {
    @Test
    public void testBasicOperations() {
        CollectionValuedMap<String, Integer> cvm = new CollectionValuedMap<String, Integer>();
        Assert.assertTrue((boolean)cvm.isEmpty());
        cvm.add("key1", 1);
        cvm.add("key1", 2);
        cvm.add("key1", 3);
        cvm.add("key2", 4);
        cvm.add("key3", 7);
        Assert.assertEquals((long)cvm.get("key1").size(), (long)3L);
        Assert.assertEquals((long)cvm.get("key2").size(), (long)1L);
        Assert.assertEquals((long)cvm.get("keyX").size(), (long)0L);
        Assert.assertEquals((long)cvm.keySet().size(), (long)3L);
        Assert.assertEquals((long)cvm.values().size(), (long)3L);
        Assert.assertEquals((long)cvm.size(), (long)3L);
        Assert.assertEquals((long)cvm.entrySet().size(), (long)3L);
        Collection allValues = cvm.allValues();
        Assert.assertEquals((long)allValues.size(), (long)5L);
        Assert.assertTrue((boolean)cvm.containsKey("key1"));
        Assert.assertTrue((boolean)cvm.containsKey("key2"));
        Assert.assertTrue((boolean)cvm.containsKey("key3"));
        Assert.assertFalse((boolean)cvm.containsKey("keyX"));
        Assert.assertTrue((boolean)allValues.contains(1));
        Assert.assertTrue((boolean)allValues.contains(2));
        Assert.assertTrue((boolean)allValues.contains(3));
        Assert.assertTrue((boolean)allValues.contains(4));
        Assert.assertFalse((boolean)allValues.contains(5));
        Assert.assertFalse((boolean)cvm.isEmpty());
        cvm.remove("key3");
        Assert.assertTrue((boolean)cvm.containsKey("key1"));
        Assert.assertTrue((boolean)cvm.containsKey("key2"));
        Assert.assertFalse((boolean)cvm.containsKey("key3"));
        Assert.assertFalse((boolean)cvm.containsKey("keyX"));
        Assert.assertEquals((long)cvm.size(), (long)2L);
        Assert.assertEquals((long)cvm.entrySet().size(), (long)2L);
        Assert.assertEquals((long)cvm.allValues().size(), (long)4L);
        Assert.assertEquals((long)cvm.keySet().size(), (long)2L);
        Assert.assertEquals((long)cvm.values().size(), (long)2L);
        cvm.remove("keyX");
        Assert.assertTrue((boolean)cvm.containsKey("key1"));
        Assert.assertTrue((boolean)cvm.containsKey("key2"));
        Assert.assertFalse((boolean)cvm.containsKey("key3"));
        Assert.assertFalse((boolean)cvm.containsKey("keyX"));
        Assert.assertEquals((long)cvm.size(), (long)2L);
        Assert.assertEquals((long)cvm.entrySet().size(), (long)2L);
        Assert.assertEquals((long)cvm.allValues().size(), (long)4L);
        Assert.assertEquals((long)cvm.keySet().size(), (long)2L);
        Assert.assertEquals((long)cvm.values().size(), (long)2L);
        cvm.add("key4", 3);
        cvm.removeAll(Arrays.asList("key1", "key4"));
        Assert.assertFalse((boolean)cvm.containsKey("key1"));
        Assert.assertTrue((boolean)cvm.containsKey("key2"));
        Assert.assertFalse((boolean)cvm.containsKey("key3"));
        Assert.assertFalse((boolean)cvm.containsKey("key4"));
        Assert.assertFalse((boolean)cvm.containsKey("keyX"));
        cvm.clear();
        Assert.assertFalse((boolean)cvm.containsKey("key1"));
        Assert.assertFalse((boolean)cvm.containsKey("key2"));
        Assert.assertFalse((boolean)cvm.containsKey("key3"));
        Assert.assertFalse((boolean)cvm.containsKey("keyX"));
        Assert.assertEquals((long)cvm.size(), (long)0L);
        Assert.assertEquals((long)cvm.allValues().size(), (long)0L);
        Assert.assertEquals((long)cvm.entrySet().size(), (long)0L);
        Assert.assertEquals((long)cvm.keySet().size(), (long)0L);
        Assert.assertEquals((long)cvm.values().size(), (long)0L);
    }

    @Test
    public void testMergingOperations() {
        CollectionValuedMap<String, Integer> cvm = new CollectionValuedMap<String, Integer>();
        cvm.add("key1", 1);
        cvm.add("key2", 2);
        cvm.add("key3", 3);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("key1", 1);
        map.put("key2", 2);
        map.put("key3", 3);
        CollectionValuedMap<String, Integer> cvmFromMap = new CollectionValuedMap<String, Integer>();
        cvmFromMap.addAll(map);
        Assert.assertEquals(cvm, cvmFromMap);
        CollectionValuedMap cvmFromCvm = new CollectionValuedMap(cvm);
        Assert.assertEquals(cvm, cvmFromCvm);
        CollectionValuedMap<String, Integer> cvmToMerge = new CollectionValuedMap<String, Integer>();
        cvmToMerge.add("key1", 11);
        cvmToMerge.add("key5", 55);
        Assert.assertFalse((boolean)cvmToMerge.equals(cvm));
        cvm.addAll(cvmToMerge);
        CollectionValuedMap<String, Integer> expectedMerge = new CollectionValuedMap<String, Integer>();
        expectedMerge.add("key1", 1);
        expectedMerge.add("key1", 11);
        expectedMerge.add("key2", 2);
        expectedMerge.add("key3", 3);
        expectedMerge.add("key5", 55);
        Assert.assertEquals(cvm, expectedMerge);
    }

    @Test
    public void testAddRemove() {
        CollectionValuedMap<Integer, Integer> fooMap = new CollectionValuedMap<Integer, Integer>();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                fooMap.add(new Integer(i), new Integer(j));
            }
        }
        fooMap.remove(new Integer(2));
        Assert.assertEquals((Object)"{0=[0, 1, 2, 3], 1=[0, 1, 2, 3], 3=[0, 1, 2, 3]}", (Object)fooMap.toString());
    }

    @Test
    public void testRandomAddRemoveAndDelta() {
        Integer rInt2;
        Integer rInt1;
        int i;
        CollectionValuedMap<Integer, Integer> originalMap = new CollectionValuedMap<Integer, Integer>();
        Random r = new Random();
        for (int i2 = 0; i2 < 800; ++i2) {
            Integer rInt12 = r.nextInt(400);
            Integer rInt22 = r.nextInt(400);
            originalMap.add(rInt12, rInt22);
        }
        CollectionValuedMap originalCopyMap = new CollectionValuedMap(originalMap);
        CollectionValuedMap<Integer, Integer> deltaCopyMap = new CollectionValuedMap<Integer, Integer>(originalMap);
        DeltaCollectionValuedMap<Integer, Integer> deltaMap = new DeltaCollectionValuedMap<Integer, Integer>(originalMap);
        CollectionValuedMap<Integer, Integer> delta2Map = originalMap.deltaCopy();
        for (i = 0; i < 400; ++i) {
            rInt1 = r.nextInt(400);
            rInt2 = r.nextInt(400) + 1000;
            ((CollectionValuedMap)deltaMap).add(rInt1, rInt2);
            delta2Map.add(rInt1, rInt2);
            deltaCopyMap.add(rInt1, rInt2);
        }
        for (i = 0; i < 400; ++i) {
            rInt1 = r.nextInt(1400);
            rInt2 = r.nextInt(1400);
            ((CollectionValuedMap)deltaMap).removeMapping(rInt1, rInt2);
            delta2Map.removeMapping(rInt1, rInt2);
            deltaCopyMap.removeMapping(rInt1, rInt2);
        }
        Assert.assertEquals((String)"Copy map not identical", originalMap, originalCopyMap);
        Assert.assertEquals((String)"Delta map not equal to copy", deltaCopyMap, deltaMap);
        Assert.assertEquals((String)"Delta2Map not equal to copy", deltaCopyMap, delta2Map);
    }
}

