/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Pair;

public class UnorderedPair<T1, T2>
extends Pair<T1, T2> {
    private static final long serialVersionUID = 1L;

    @Override
    public String toString() {
        return "{" + this.first + "," + this.second + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UnorderedPair) {
            UnorderedPair p = (UnorderedPair)o;
            return (this.first == null ? p.first == null : this.first.equals(p.first)) && (this.second != null ? this.second.equals(p.second) : p.second == null) || (this.first == null ? p.second == null : this.first.equals(p.second)) && (this.second == null ? p.first == null : this.second.equals(p.first));
        }
        return false;
    }

    @Override
    public int hashCode() {
        int secondHashCode;
        int firstHashCode = this.first == null ? 0 : this.first.hashCode();
        int n = secondHashCode = this.second == null ? 0 : this.second.hashCode();
        if (firstHashCode != secondHashCode) {
            return (firstHashCode & secondHashCode) << 16 ^ (firstHashCode | secondHashCode);
        }
        return firstHashCode;
    }

    @Override
    public int compareTo(Pair<T1, T2> o) {
        int c1;
        UnorderedPair other = (UnorderedPair)o;
        Object this1 = this.first;
        Object this2 = this.second;
        int thisC = ((Comparable)this.first).compareTo(this.second);
        if (thisC < 0) {
            this1 = this.second;
            this2 = this.first;
        }
        Object other1 = this.first;
        Object other2 = this.second;
        int otherC = ((Comparable)other.first).compareTo(other.second);
        if (otherC < 0) {
            other1 = this.second;
            other2 = this.first;
        }
        if ((c1 = ((Comparable)this1).compareTo(other1)) != 0) {
            return c1;
        }
        int c2 = ((Comparable)this2).compareTo(other2);
        if (c2 != 0) {
            return c1;
        }
        return 0;
    }

    public UnorderedPair() {
        this.first = null;
        this.second = null;
    }

    public UnorderedPair(T1 first, T2 second) {
        this.first = first;
        this.second = second;
    }
}

