/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.lu;

import org.ejml.alg.dense.decomposition.lu.LUDecompositionBase;
import org.ejml.alg.dense.linsol.lu.LinearSolverLuBase;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.SpecializedOps;

public class LinearSolverLuKJI
extends LinearSolverLuBase {
    private double[] dataLU;
    private int[] pivot;

    public LinearSolverLuKJI(LUDecompositionBase lUDecompositionBase) {
        super(lUDecompositionBase);
    }

    @Override
    public boolean setA(DenseMatrix64F denseMatrix64F) {
        boolean bl = super.setA(denseMatrix64F);
        this.pivot = this.decomp.getPivot();
        this.dataLU = this.decomp.getLU().data;
        return bl;
    }

    @Override
    public void solve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        int n;
        int n2;
        int n3;
        if (denseMatrix64F.numCols != denseMatrix64F2.numCols && denseMatrix64F.numRows != this.numCols && denseMatrix64F2.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected matrix size");
        }
        if (denseMatrix64F == denseMatrix64F2) {
            throw new IllegalArgumentException("Current doesn't support using the same matrix instance");
        }
        SpecializedOps.copyChangeRow(this.pivot, denseMatrix64F, denseMatrix64F2);
        int n4 = denseMatrix64F.numCols;
        double[] dArray = denseMatrix64F2.data;
        for (n3 = 0; n3 < this.numCols; ++n3) {
            for (n2 = n3 + 1; n2 < this.numCols; ++n2) {
                for (n = 0; n < n4; ++n) {
                    int n5 = n2 * n4 + n;
                    dArray[n5] = dArray[n5] - dArray[n3 * n4 + n] * this.dataLU[n2 * this.numCols + n3];
                }
            }
        }
        for (n3 = this.numCols - 1; n3 >= 0; --n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                int n6 = n3 * n4 + n2;
                dArray[n6] = dArray[n6] / this.dataLU[n3 * this.numCols + n3];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    int n7 = n2 * n4 + n;
                    dArray[n7] = dArray[n7] - dArray[n3 * n4 + n] * this.dataLU[n2 * this.numCols + n3];
                }
            }
        }
    }
}

