/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class NominalDataReader {
    Map<String, Index<String>> indices = Generics.newHashMap();
    static final Redwood.RedwoodChannels logger = Redwood.channels(NominalDataReader.class);

    static RVFDatum<String, Integer> readDatum(String line, String separator, Map<Integer, Index<String>> indices) {
        StringTokenizer st = new StringTokenizer(line, separator);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            tokens.add(token);
        }
        String[] arr = tokens.toArray(new String[tokens.size()]);
        Set<Integer> skip = Generics.newHashSet();
        skip.add(arr.length - 2);
        return NominalDataReader.readDatum(arr, arr.length - 1, skip, indices);
    }

    static RVFDatum<String, Integer> readDatum(String[] values, int classColumn, Set<Integer> skip, Map<Integer, Index<String>> indices) {
        ClassicCounter<Integer> c = new ClassicCounter<Integer>();
        RVFDatum<String, Integer> d = new RVFDatum<String, Integer>(c);
        int attrNo = 0;
        for (int index = 0; index < values.length; ++index) {
            if (index == classColumn) {
                d.setLabel(values[index]);
                continue;
            }
            if (skip.contains(index)) continue;
            Integer featKey = attrNo;
            Index<String> ind = indices.get(featKey);
            if (ind == null) {
                ind = new HashIndex<String>();
                indices.put(featKey, ind);
            }
            ind.add(values[index]);
            int valInd = ind.indexOf(values[index]);
            if (valInd == -1) {
                valInd = 0;
                logger.info("unknown attribute value " + values[index] + " of attribute " + attrNo);
            }
            c.incrementCount(featKey, valInd);
            ++attrNo;
        }
        return d;
    }

    static ArrayList<RVFDatum<String, Integer>> readData(String filename, Map<Integer, Index<String>> indices) {
        try {
            String sep = ", ";
            ArrayList<RVFDatum<String, Integer>> examples = new ArrayList<RVFDatum<String, Integer>>();
            for (String line : ObjectBank.getLineIterator(new File(filename))) {
                RVFDatum<String, Integer> next = NominalDataReader.readDatum(line, sep, indices);
                examples.add(next);
            }
            return examples;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

