/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.hybrid.rf;

import edu.stanford.nlp.coref.hybrid.rf.DecisionTreeNode;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.Index;
import java.io.Serializable;

public class DecisionTree
implements Serializable {
    private static final long serialVersionUID = -4198470422641238244L;
    public DecisionTreeNode root;
    public Index<String> featureIndex;

    public DecisionTree(Index<String> featureIndex) {
        this.featureIndex = featureIndex;
        this.root = null;
    }

    public double probabilityOfTrue(RVFDatum<Boolean, String> datum) {
        return this.probabilityOfTrue(datum.asFeaturesCounter());
    }

    public double probabilityOfTrue(Counter<String> features) {
        DecisionTreeNode cur = this.root;
        while (!cur.isLeaf()) {
            double value = features.getCount(this.featureIndex.get(cur.idx));
            cur = value < (double)cur.split ? cur.children[0] : cur.children[1];
        }
        return cur.split;
    }
}

