/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.fsm;

import edu.stanford.nlp.fsm.AutomatonMinimizer;
import edu.stanford.nlp.fsm.Block;
import edu.stanford.nlp.fsm.TransducerGraph;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Maps;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Timing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ExactAutomatonMinimizer
implements AutomatonMinimizer {
    private TransducerGraph unminimizedFA = null;
    private Map<TransducerGraph.Arc, ExactBlock<TransducerGraph.Arc>> memberToBlock = null;
    private LinkedList<Pair<ExactBlock<TransducerGraph.Arc>, TransducerGraph.Arc>> activePairs = null;
    private boolean sparseMode = false;
    private static final TransducerGraph.Arc SINK_NODE = new TransducerGraph.Arc(null);

    protected TransducerGraph getUnminimizedFA() {
        return this.unminimizedFA;
    }

    protected Collection<?> getSymbols() {
        return this.getUnminimizedFA().getInputs();
    }

    @Override
    public TransducerGraph minimizeFA(TransducerGraph unminimizedFA) {
        this.unminimizedFA = unminimizedFA;
        this.activePairs = Generics.newLinkedList();
        this.memberToBlock = Generics.newHashMap();
        this.minimize();
        return this.buildMinimizedFA();
    }

    protected TransducerGraph buildMinimizedFA() {
        TransducerGraph minimizedFA = new TransducerGraph();
        TransducerGraph unminimizedFA = this.getUnminimizedFA();
        for (TransducerGraph.Arc arc : unminimizedFA.getArcs()) {
            Set<TransducerGraph.Arc> source = this.projectNode(arc.getSourceNode());
            Set<TransducerGraph.Arc> target = this.projectNode(arc.getTargetNode());
            try {
                if (!minimizedFA.canAddArc(source, target, arc.getInput(), arc.getOutput())) continue;
                minimizedFA.addArc(source, target, arc.getInput(), arc.getOutput());
            }
            catch (Exception exception) {}
        }
        minimizedFA.setStartNode(this.projectNode(unminimizedFA.getStartNode()));
        for (TransducerGraph.Arc o : unminimizedFA.getEndNodes()) {
            minimizedFA.setEndNode(this.projectNode(o));
        }
        return minimizedFA;
    }

    protected Set<TransducerGraph.Arc> projectNode(Object node) {
        return this.getBlock(node).getMembers();
    }

    protected boolean hasActivePair() {
        return this.activePairs.size() > 0;
    }

    protected Pair<ExactBlock<TransducerGraph.Arc>, ?> getActivePair() {
        return this.activePairs.removeFirst();
    }

    protected void addActivePair(Pair<ExactBlock<TransducerGraph.Arc>, TransducerGraph.Arc> pair) {
        this.activePairs.addLast(pair);
    }

    protected <Y> Map<ExactBlock<TransducerGraph.Arc>, Set<Y>> sortIntoBlocks(Collection<Y> nodes) {
        Map<ExactBlock<TransducerGraph.Arc>, Set<Y>> blockToMembers = Generics.newHashMap();
        for (Y o : nodes) {
            ExactBlock<TransducerGraph.Arc> block = this.getBlock(o);
            if (block == null) {
                throw new RuntimeException("got null block");
            }
            Maps.putIntoValueHashSet(blockToMembers, block, o);
        }
        return blockToMembers;
    }

    protected void makeBlock(Collection<TransducerGraph.Arc> members) {
        ExactBlock<TransducerGraph.Arc> block = new ExactBlock<TransducerGraph.Arc>(Generics.newHashSet(members));
        for (TransducerGraph.Arc member : block.getMembers()) {
            if (member == SINK_NODE) continue;
            this.memberToBlock.put(member, block);
        }
        Iterator iterator = this.getSymbols().iterator();
        while (iterator.hasNext()) {
            TransducerGraph.Arc o;
            TransducerGraph.Arc symbol = o = iterator.next();
            this.addActivePair(new Pair<ExactBlock<TransducerGraph.Arc>, TransducerGraph.Arc>(block, symbol));
        }
    }

    protected static void removeAll(Collection<? extends TransducerGraph.Arc> block, Collection members) {
        for (Object member : members) {
            block.remove(member);
        }
    }

    protected static Collection<TransducerGraph.Arc> difference(Collection<TransducerGraph.Arc> block, Collection<TransducerGraph.Arc> members) {
        Set<TransducerGraph.Arc> difference = Generics.newHashSet();
        for (TransducerGraph.Arc member : block) {
            if (members.contains(member)) continue;
            difference.add(member);
        }
        return difference;
    }

    protected ExactBlock<TransducerGraph.Arc> getBlock(Object o) {
        ExactBlock<TransducerGraph.Arc> result = this.memberToBlock.get(o);
        if (result == null) {
            throw new RuntimeException("memberToBlock had null block");
        }
        return result;
    }

    protected Collection<Object> getInverseImages(ExactBlock<TransducerGraph.Arc> block, Object symbol) {
        ArrayList<Object> inverseImages = new ArrayList<Object>();
        for (TransducerGraph.Arc member : block.getMembers()) {
            Collection<TransducerGraph.Arc> arcs = null;
            if (member != SINK_NODE) {
                arcs = this.getUnminimizedFA().getArcsByTargetAndInput(member, symbol);
            } else {
                arcs = this.getUnminimizedFA().getArcsByInput(symbol);
                if (!this.sparseMode) {
                    arcs = ExactAutomatonMinimizer.difference(this.getUnminimizedFA().getArcs(), arcs);
                }
            }
            if (arcs == null) continue;
            for (TransducerGraph.Arc arc : arcs) {
                Object source = arc.getSourceNode();
                inverseImages.add(source);
            }
        }
        return inverseImages;
    }

    protected void makeInitialBlocks() {
        this.makeBlock(Collections.singleton(SINK_NODE));
        Set endNodes = this.getUnminimizedFA().getEndNodes();
        this.makeBlock(endNodes);
        Set<TransducerGraph.Arc> nonFinalNodes = Generics.newHashSet(this.getUnminimizedFA().getNodes());
        nonFinalNodes.removeAll(endNodes);
        this.makeBlock(nonFinalNodes);
    }

    protected void minimize() {
        this.makeInitialBlocks();
        while (this.hasActivePair()) {
            Pair<ExactBlock<TransducerGraph.Arc>, ?> activePair = this.getActivePair();
            ExactBlock<TransducerGraph.Arc> activeBlock = activePair.first();
            Object symbol = activePair.second();
            Collection<Object> inverseImages = this.getInverseImages(activeBlock, symbol);
            Map<ExactBlock<TransducerGraph.Arc>, Set<Object>> inverseImagesByBlock = this.sortIntoBlocks(inverseImages);
            for (ExactBlock<TransducerGraph.Arc> block : inverseImagesByBlock.keySet()) {
                if (block == null) {
                    throw new RuntimeException("block was null");
                }
                Collection<TransducerGraph.Arc> members = (Collection<TransducerGraph.Arc>)inverseImagesByBlock.get(block);
                if (members.size() == 0 || members.size() == block.getMembers().size()) continue;
                if (members.size() > block.getMembers().size() - members.size()) {
                    members = ExactAutomatonMinimizer.difference(block.getMembers(), members);
                }
                ExactAutomatonMinimizer.removeAll(block.getMembers(), members);
                this.makeBlock(members);
            }
        }
    }

    public ExactAutomatonMinimizer(boolean sparseMode) {
        this.sparseMode = sparseMode;
    }

    public ExactAutomatonMinimizer() {
        this(false);
    }

    public static void main(String[] args) {
        TransducerGraph fa = new TransducerGraph();
        fa.addArc(fa.getStartNode(), "1", "a", "");
        fa.addArc(fa.getStartNode(), "2", "b", "");
        fa.addArc(fa.getStartNode(), "3", "c", "");
        fa.addArc("1", "4", "a", "");
        fa.addArc("2", "4", "a", "");
        fa.addArc("3", "5", "c", "");
        fa.addArc("4", "6", "c", "");
        fa.addArc("5", "6", "c", "");
        fa.setEndNode("6");
        System.out.println(fa);
        ExactAutomatonMinimizer minimizer = new ExactAutomatonMinimizer();
        System.out.println(minimizer.minimizeFA(fa));
        System.out.println("Starting...");
        Timing.startTime();
        TransducerGraph randomFA = TransducerGraph.createRandomGraph(100, 10, 1.0, 10, new ArrayList());
        TransducerGraph minimizedRandomFA = minimizer.minimizeFA(randomFA);
        System.out.println(randomFA);
        System.out.println(minimizedRandomFA);
        Timing.tick("done. ( " + randomFA.getArcs().size() + " arcs to " + minimizedRandomFA.getArcs().size() + " arcs)");
    }

    private static class ExactBlock<E>
    implements Block<E> {
        private final Set<E> members;

        @Override
        public Set<E> getMembers() {
            return this.members;
        }

        public ExactBlock(Set<E> members) {
            if (members == null) {
                throw new IllegalArgumentException("tried to create block with null members.");
            }
            this.members = members;
        }

        public String toString() {
            return "Block: " + this.members.toString();
        }
    }
}

