/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.simple.Sentence;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.ConfusionMatrix;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface KBPRelationExtractor {
    public static final String NO_RELATION = "no_relation";

    public Pair<String, Double> classify(KBPInput var1);

    public static List<Pair<KBPInput, String>> readDataset(File conllInputFile) throws IOException {
        BufferedReader reader = IOUtils.readerFromFile(conllInputFile);
        ArrayList<Pair<KBPInput, String>> examples = new ArrayList<Pair<KBPInput, String>>();
        int i = 0;
        String relation = null;
        ArrayList<String> tokens = new ArrayList<String>();
        Span subject = new Span(Integer.MAX_VALUE, Integer.MIN_VALUE);
        NERTag subjectNER = null;
        Span object = new Span(Integer.MAX_VALUE, Integer.MIN_VALUE);
        NERTag objectNER = null;
        String line = reader.readLine();
        if (!line.startsWith("#")) {
            throw new IllegalArgumentException("First line of input file should be header definition");
        }
        while ((line = reader.readLine()) != null) {
            String[] fields = line.split("\t");
            if (relation == null) {
                if (!1.$assertionsDisabled && fields.length != 1) {
                    throw new AssertionError();
                }
                relation = fields[0];
                continue;
            }
            if (fields.length == 9) {
                tokens.add(fields[0]);
                if ("SUBJECT".equals(fields[1])) {
                    subject = new Span(Math.min(subject.start(), i), Math.max(subject.end(), i + 1));
                    subjectNER = NERTag.valueOf(fields[2].toUpperCase());
                } else if ("OBJECT".equals(fields[3])) {
                    object = new Span(Math.min(object.start(), i), Math.max(object.end(), i + 1));
                    objectNER = NERTag.valueOf(fields[4].toUpperCase());
                } else if (!"-".equals(fields[1]) || !"-".equals(fields[3])) {
                    throw new IllegalStateException("Could not parse CoNLL file");
                }
                ++i;
                continue;
            }
            if (StringUtils.isNullOrEmpty(line.trim())) {
                examples.add(Pair.makePair(new KBPInput(subject, object, subjectNER, objectNER, new Sentence(tokens)), relation));
                i = 0;
                relation = null;
                tokens = new ArrayList();
                subject = new Span(Integer.MAX_VALUE, Integer.MIN_VALUE);
                object = new Span(Integer.MAX_VALUE, Integer.MIN_VALUE);
                continue;
            }
            throw new IllegalStateException("Could not parse CoNLL file");
        }
        return examples;
    }

    default public Accuracy computeAccuracy(Stream<Pair<KBPInput, String>> examples, Optional<PrintStream> predictOut) {
        Redwood.Util.forceTrack("Accuracy");
        Accuracy accuracy = new Accuracy();
        AtomicInteger testI = new AtomicInteger(0);
        DecimalFormat confidenceFormat = new DecimalFormat("0.0000");
        Redwood.Util.forceTrack("Featurizing");
        ((Stream)examples.parallel()).map(example -> {
            Pair<String, Double> predicted = this.classify((KBPInput)example.first);
            Accuracy accuracy2 = accuracy;
            synchronized (accuracy2) {
                accuracy.predict(Collections.singleton((String)predicted.first), Collections.singleton((String)example.second));
            }
            if (testI.incrementAndGet() % 1000 == 0) {
                Redwood.log(KBPRelationExtractor.class, "[" + testI.get() + "]  " + accuracy.toOneLineString());
            }
            return (String)predicted.first + "\t" + confidenceFormat.format(predicted.second);
        }).forEachOrdered(line -> {
            if (predictOut.isPresent()) {
                ((PrintStream)predictOut.get()).println((String)line);
            }
        });
        Redwood.Util.endTrack("Featurizing");
        Redwood.log(accuracy.toString());
        Redwood.Util.endTrack("Accuracy");
        return accuracy;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class Accuracy {
        private Counter<String> correctCount = new ClassicCounter<String>();
        private Counter<String> predictedCount = new ClassicCounter<String>();
        private Counter<String> goldCount = new ClassicCounter<String>();
        private Counter<String> totalCount = new ClassicCounter<String>();
        public final ConfusionMatrix<String> confusion = new ConfusionMatrix();

        public void predict(Set<String> predictedRelationsRaw, Set<String> goldRelationsRaw) {
            final HashSet<String> predictedRelations = new HashSet<String>(predictedRelationsRaw);
            predictedRelations.remove(KBPRelationExtractor.NO_RELATION);
            final HashSet<String> goldRelations = new HashSet<String>(goldRelationsRaw);
            goldRelations.remove(KBPRelationExtractor.NO_RELATION);
            for (String pred : predictedRelations) {
                if (goldRelations.contains(pred)) {
                    this.correctCount.incrementCount(pred);
                }
                this.predictedCount.incrementCount(pred);
            }
            goldRelations.forEach(this.goldCount::incrementCount);
            HashSet<String> allRelations = new HashSet<String>(){
                {
                    this.addAll(predictedRelations);
                    this.addAll(goldRelations);
                }
            };
            allRelations.forEach(this.totalCount::incrementCount);
            if (predictedRelations.size() == 1 && goldRelations.size() == 1) {
                this.confusion.add((String)predictedRelations.iterator().next(), (String)goldRelations.iterator().next());
            }
            if (predictedRelations.size() == 1 && goldRelations.isEmpty()) {
                this.confusion.add((String)predictedRelations.iterator().next(), "NR");
            }
            if (predictedRelations.isEmpty() && goldRelations.size() == 1) {
                this.confusion.add("NR", (String)goldRelations.iterator().next());
            }
        }

        public double precision(String relation) {
            if (this.predictedCount.getCount(relation) == 0.0) {
                return 1.0;
            }
            return this.correctCount.getCount(relation) / this.predictedCount.getCount(relation);
        }

        public double precisionMicro() {
            if (this.predictedCount.totalCount() == 0.0) {
                return 1.0;
            }
            return this.correctCount.totalCount() / this.predictedCount.totalCount();
        }

        public double precisionMacro() {
            double sumPrecision = 0.0;
            for (String rel : this.totalCount.keySet()) {
                sumPrecision += this.precision(rel);
            }
            return sumPrecision / (double)this.totalCount.size();
        }

        public double recall(String relation) {
            if (this.goldCount.getCount(relation) == 0.0) {
                return 0.0;
            }
            return this.correctCount.getCount(relation) / this.goldCount.getCount(relation);
        }

        public double recallMicro() {
            if (this.goldCount.totalCount() == 0.0) {
                return 0.0;
            }
            return this.correctCount.totalCount() / this.goldCount.totalCount();
        }

        public double recallMacro() {
            double sumRecall = 0.0;
            for (String rel : this.totalCount.keySet()) {
                sumRecall += this.recall(rel);
            }
            return sumRecall / (double)this.totalCount.size();
        }

        public double f1(String relation) {
            return 2.0 * this.precision(relation) * this.recall(relation) / (this.precision(relation) + this.recall(relation));
        }

        public double f1Micro() {
            return 2.0 * this.precisionMicro() * this.recallMicro() / (this.precisionMicro() + this.recallMicro());
        }

        public double f1Macro() {
            return 2.0 * this.precisionMacro() * this.recallMacro() / (this.precisionMacro() + this.recallMacro());
        }

        public void dumpPerRelationStats(PrintStream out2) {
            List stats = this.goldCount.keySet().stream().map(relation -> new PerRelationStat((String)relation, this.precision((String)relation), this.recall((String)relation), (int)this.predictedCount.getCount(relation), (int)this.goldCount.getCount(relation))).collect(Collectors.toList());
            Collections.sort(stats);
            out2.println("Per-relation Accuracy");
            for (PerRelationStat stat : stats) {
                out2.println(stat);
            }
        }

        public void dumpPerRelationStats() {
            this.dumpPerRelationStats(System.out);
        }

        public void toString(PrintStream out2) {
            out2.println();
            out2.println("PRECISION (micro average): " + new DecimalFormat("0.000%").format(this.precisionMicro()));
            out2.println("RECALL    (micro average): " + new DecimalFormat("0.000%").format(this.recallMicro()));
            out2.println("F1        (micro average): " + new DecimalFormat("0.000%").format(this.f1Micro()));
            out2.println();
            out2.println("PRECISION (macro average): " + new DecimalFormat("0.000%").format(this.precisionMacro()));
            out2.println("RECALL    (macro average): " + new DecimalFormat("0.000%").format(this.recallMacro()));
            out2.println("F1        (macro average): " + new DecimalFormat("0.000%").format(this.f1Macro()));
            out2.println();
        }

        public String toString() {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            PrintStream out2 = new PrintStream(bs);
            this.toString(out2);
            return bs.toString();
        }

        public String toOneLineString() {
            return "P: " + new DecimalFormat("0.000%").format(this.precisionMicro()) + "  R: " + new DecimalFormat("0.000%").format(this.recallMicro()) + "  F1: " + new DecimalFormat("0.000%").format(this.f1Micro());
        }

        private static class PerRelationStat
        implements Comparable<PerRelationStat> {
            public final String name;
            public final double precision;
            public final double recall;
            public final int predictedCount;
            public final int goldCount;

            public PerRelationStat(String name, double precision, double recall, int predictedCount, int goldCount) {
                this.name = name;
                this.precision = precision;
                this.recall = recall;
                this.predictedCount = predictedCount;
                this.goldCount = goldCount;
            }

            public double f1() {
                if (this.precision == 0.0 && this.recall == 0.0) {
                    return 0.0;
                }
                return 2.0 * this.precision * this.recall / (this.precision + this.recall);
            }

            @Override
            public int compareTo(PerRelationStat o) {
                if (this.precision < o.precision) {
                    return -1;
                }
                if (this.precision > o.precision) {
                    return 1;
                }
                return 0;
            }

            public String toString() {
                DecimalFormat df = new DecimalFormat("0.00%");
                return "[" + this.name + "]  pred/gold: " + this.predictedCount + "/" + this.goldCount + "  P: " + df.format(this.precision) + "  R: " + df.format(this.recall) + "  F1: " + df.format(this.f1());
            }
        }
    }

    public static class KBPInput {
        public final Span subjectSpan;
        public final Span objectSpan;
        public final NERTag subjectType;
        public final NERTag objectType;
        public final Sentence sentence;

        public KBPInput(Span subjectSpan, Span objectSpan, NERTag subjectType, NERTag objectType, Sentence sentence) {
            this.subjectSpan = subjectSpan;
            this.objectSpan = objectSpan;
            this.subjectType = subjectType;
            this.objectType = objectType;
            this.sentence = sentence;
        }

        public Sentence getSentence() {
            return this.sentence;
        }

        public Span getSubjectSpan() {
            return this.subjectSpan;
        }

        public String getSubjectText() {
            return StringUtils.join(this.sentence.originalTexts().subList(this.subjectSpan.start(), this.subjectSpan.end()).stream(), " ");
        }

        public Span getObjectSpan() {
            return this.objectSpan;
        }

        public String getObjectText() {
            return StringUtils.join(this.sentence.originalTexts().subList(this.objectSpan.start(), this.objectSpan.end()).stream(), " ");
        }

        public String toString() {
            return "KBPInput{, subjectSpan=" + this.subjectSpan + ", objectSpan=" + this.objectSpan + ", sentence=" + this.sentence + '}';
        }
    }

    public static enum RelationType {
        PER_ALTERNATE_NAMES("per:alternate_names", true, 10, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.PERSON, NERTag.MISC}, new String[]{"NNP"}, 0.03530272703081071),
        PER_CHILDREN("per:children", true, 5, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP"}, 0.005842811028450441),
        PER_CITIES_OF_RESIDENCE("per:cities_of_residence", true, 5, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.CITY}, new String[]{"NNP"}, 0.013610567967511656),
        PER_CITY_OF_BIRTH("per:city_of_birth", true, 3, NERTag.PERSON, Cardinality.SINGLE, new NERTag[]{NERTag.CITY}, new String[]{"NNP"}, 0.03581469611597691),
        PER_CITY_OF_DEATH("per:city_of_death", true, 3, NERTag.PERSON, Cardinality.SINGLE, new NERTag[]{NERTag.CITY}, new String[]{"NNP"}, 0.010200333213777465),
        PER_COUNTRIES_OF_RESIDENCE("per:countries_of_residence", true, 5, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.COUNTRY}, new String[]{"NNP"}, 0.010778829355208202),
        PER_COUNTRY_OF_BIRTH("per:country_of_birth", true, 3, NERTag.PERSON, Cardinality.SINGLE, new NERTag[]{NERTag.COUNTRY}, new String[]{"NNP"}, 0.022344413462762204),
        PER_COUNTRY_OF_DEATH("per:country_of_death", true, 3, NERTag.PERSON, Cardinality.SINGLE, new NERTag[]{NERTag.COUNTRY}, new String[]{"NNP"}, 0.00606263956219412),
        PER_EMPLOYEE_OF("per:employee_of", true, 10, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION, NERTag.COUNTRY, NERTag.STATE_OR_PROVINCE, NERTag.CITY}, new String[]{"NNP"}, 2.033528190116972),
        PER_LOC_OF_BIRTH("per:LOCATION_of_birth", true, 3, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.CITY, NERTag.STATE_OR_PROVINCE, NERTag.COUNTRY}, new String[]{"NNP"}, 0.016582591894112066),
        PER_LOC_OF_DEATH("per:LOCATION_of_death", true, 3, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.CITY, NERTag.STATE_OR_PROVINCE, NERTag.COUNTRY}, new String[]{"NNP"}, 0.016582591894112066),
        PER_LOC_OF_RESIDENCE("per:LOCATION_of_residence", true, 3, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.STATE_OR_PROVINCE}, new String[]{"NNP"}, 0.016582591894112066),
        PER_MEMBER_OF("per:member_of", true, 10, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION}, new String[]{"NNP"}, 0.05217167451493099),
        PER_ORIGIN("per:origin", true, 10, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.NATIONALITY, NERTag.COUNTRY}, new String[]{"NNP"}, 0.006979555946361838),
        PER_OTHER_FAMILY("per:other_family", true, 5, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP"}, 2.747856671795999E-5),
        PER_PARENTS("per:parents", true, 5, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP"}, 0.003222223507769203),
        PER_SCHOOLS_ATTENDED("per:schools_attended", true, 5, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION}, new String[]{"NNP"}, 0.005469681017227615),
        PER_SIBLINGS("per:siblings", true, 5, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP"}, 1.0E-99),
        PER_SPOUSE("per:spouse", true, 3, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP"}, 0.016407596811329268),
        PER_STATE_OR_PROVINCES_OF_BIRTH("per:stateorprovince_of_birth", true, 3, NERTag.PERSON, Cardinality.SINGLE, new NERTag[]{NERTag.STATE_OR_PROVINCE}, new String[]{"NNP"}, 0.016582591894112066),
        PER_STATE_OR_PROVINCES_OF_DEATH("per:stateorprovince_of_death", true, 3, NERTag.PERSON, Cardinality.SINGLE, new NERTag[]{NERTag.STATE_OR_PROVINCE}, new String[]{"NNP"}, 0.005008330344436603),
        PER_STATE_OR_PROVINCES_OF_RESIDENCE("per:stateorprovinces_of_residence", true, 5, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.STATE_OR_PROVINCE}, new String[]{"NNP"}, 0.006678737952817855),
        PER_AGE("per:age", true, 3, NERTag.PERSON, Cardinality.SINGLE, new NERTag[]{NERTag.NUMBER, NERTag.DURATION}, new String[]{"CD", "NN"}, 0.04831599773229513),
        PER_DATE_OF_BIRTH("per:date_of_birth", true, 3, NERTag.PERSON, Cardinality.SINGLE, new NERTag[]{NERTag.DATE}, new String[]{"CD", "NN"}, 0.07435844777915332),
        PER_DATE_OF_DEATH("per:date_of_death", true, 3, NERTag.PERSON, Cardinality.SINGLE, new NERTag[]{NERTag.DATE}, new String[]{"CD", "NN"}, 0.018981904640696046),
        PER_CAUSE_OF_DEATH("per:cause_of_death", true, 3, NERTag.PERSON, Cardinality.SINGLE, new NERTag[]{NERTag.CAUSE_OF_DEATH}, new String[]{"NN"}, 1.0123682475037891E-5),
        PER_CHARGES("per:charges", true, 5, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.CRIMINAL_CHARGE}, new String[]{"NN"}, 3.861461744050167E-4),
        PER_RELIGION("per:religion", true, 3, NERTag.PERSON, Cardinality.SINGLE, new NERTag[]{NERTag.RELIGION}, new String[]{"NN"}, 7.665073873957261E-4),
        PER_TITLE("per:title", true, 15, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.TITLE, NERTag.MODIFIER}, new String[]{"NN"}, 0.03342839953257512),
        ORG_ALTERNATE_NAMES("org:alternate_names", true, 10, NERTag.ORGANIZATION, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION, NERTag.MISC}, new String[]{"NNP"}, 0.0552058867767352),
        ORG_CITY_OF_HEADQUARTERS("org:city_of_headquarters", true, 3, NERTag.ORGANIZATION, Cardinality.SINGLE, new NERTag[]{NERTag.CITY, NERTag.LOCATION}, new String[]{"NNP"}, 0.055594925431847374),
        ORG_COUNTRY_OF_HEADQUARTERS("org:country_of_headquarters", true, 3, NERTag.ORGANIZATION, Cardinality.SINGLE, new NERTag[]{NERTag.COUNTRY, NERTag.NATIONALITY}, new String[]{"NNP"}, 0.05802171674514931),
        ORG_FOUNDED_BY("org:founded_by", true, 3, NERTag.ORGANIZATION, Cardinality.LIST, new NERTag[]{NERTag.PERSON, NERTag.ORGANIZATION}, new String[]{"NNP"}, 0.005080642362115445),
        ORG_LOC_OF_HEADQUARTERS("org:LOCATION_of_headquarters", true, 10, NERTag.ORGANIZATION, Cardinality.LIST, new NERTag[]{NERTag.CITY, NERTag.STATE_OR_PROVINCE, NERTag.COUNTRY}, new String[]{"NNP"}, 0.055594925431847374),
        ORG_MEMBER_OF("org:member_of", true, 20, NERTag.ORGANIZATION, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION, NERTag.STATE_OR_PROVINCE, NERTag.COUNTRY}, new String[]{"NNP"}, 0.039629878168712614),
        ORG_MEMBERS("org:members", true, 20, NERTag.ORGANIZATION, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION, NERTag.COUNTRY}, new String[]{"NNP"}, 0.0012220730987724312),
        ORG_PARENTS("org:parents", true, 10, NERTag.ORGANIZATION, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION}, new String[]{"NNP"}, 0.05500485936758802),
        ORG_POLITICAL_RELIGIOUS_AFFILIATION("org:political/religious_affiliation", true, 5, NERTag.ORGANIZATION, Cardinality.LIST, new NERTag[]{NERTag.IDEOLOGY, NERTag.RELIGION}, new String[]{"NN", "JJ"}, 0.005926692968957897),
        ORG_SHAREHOLDERS("org:shareholders", true, 10, NERTag.ORGANIZATION, Cardinality.LIST, new NERTag[]{NERTag.PERSON, NERTag.ORGANIZATION}, new String[]{"NNP"}, 1.1569922828614734E-5),
        ORG_STATE_OR_PROVINCES_OF_HEADQUARTERS("org:stateorprovince_of_headquarters", true, 3, NERTag.ORGANIZATION, Cardinality.SINGLE, new NERTag[]{NERTag.STATE_OR_PROVINCE}, new String[]{"NNP"}, 0.03126193148291701),
        ORG_SUBSIDIARIES("org:subsidiaries", true, 20, NERTag.ORGANIZATION, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION}, new String[]{"NNP"}, 0.016241279170667932),
        ORG_TOP_MEMBERS_SLASH_EMPLOYEES("org:top_members/employees", true, 10, NERTag.ORGANIZATION, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP"}, 0.09071687241846098),
        ORG_DISSOLVED("org:dissolved", true, 3, NERTag.ORGANIZATION, Cardinality.SINGLE, new NERTag[]{NERTag.DATE}, new String[]{"CD", "NN"}, 0.0023877428237553656),
        ORG_FOUNDED("org:founded", true, 3, NERTag.ORGANIZATION, Cardinality.SINGLE, new NERTag[]{NERTag.DATE}, new String[]{"CD", "NN"}, 0.07963144010829448),
        ORG_NUMBER_OF_EMPLOYEES_SLASH_MEMBERS("org:number_of_employees/members", true, 3, NERTag.ORGANIZATION, Cardinality.SINGLE, new NERTag[]{NERTag.NUMBER}, new String[]{"CD", "NN"}, 0.036627483194687095),
        ORG_WEBSITE("org:website", true, 3, NERTag.ORGANIZATION, Cardinality.SINGLE, new NERTag[]{NERTag.URL}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        ORG_EMPLOYEES("org:employees_or_members", false, 68, NERTag.ORGANIZATION, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        GPE_EMPLOYEES("gpe:employees_or_members", false, 10, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        ORG_STUDENTS("org:students", false, 50, NERTag.ORGANIZATION, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        GPE_BIRTHS_IN_CITY("gpe:births_in_city", false, 50, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        GPE_BIRTHS_IN_STATE_OR_PROVINCE("gpe:births_in_stateorprovince", false, 50, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        GPE_BIRTHS_IN_COUNTRY("gpe:births_in_country", false, 50, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        GPE_RESIDENTS_IN_CITY("gpe:residents_of_city", false, 50, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        GPE_RESIDENTS_IN_STATE_OR_PROVINCE("gpe:residents_of_stateorprovince", false, 50, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        GPE_RESIDENTS_IN_COUNTRY("gpe:residents_of_country", false, 50, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        GPE_DEATHS_IN_CITY("gpe:deaths_in_city", false, 50, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        GPE_DEATHS_IN_STATE_OR_PROVINCE("gpe:deaths_in_stateorprovince", false, 50, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        GPE_DEATHS_IN_COUNTRY("gpe:deaths_in_country", false, 50, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.PERSON}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        PER_HOLDS_SHARES_IN("per:holds_shares_in", false, 10, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        GPE_HOLDS_SHARES_IN("gpe:holds_shares_in", false, 10, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        ORG_HOLDS_SHARES_IN("org:holds_shares_in", false, 10, NERTag.ORGANIZATION, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        PER_ORGANIZATIONS_FOUNDED("per:organizations_founded", false, 3, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        GPE_ORGANIZATIONS_FOUNDED("gpe:organizations_founded", false, 3, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        ORG_ORGANIZATIONS_FOUNDED("org:organizations_founded", false, 3, NERTag.ORGANIZATION, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        PER_TOP_EMPLOYEE_OF("per:top_member_employee_of", false, 5, NERTag.PERSON, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        GPE_MEMBER_OF("gpe:member_of", false, 10, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION}, new String[]{"NNP"}, 0.039629878168712614),
        GPE_SUBSIDIARIES("gpe:subsidiaries", false, 10, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION}, new String[]{"NNP"}, 0.039629878168712614),
        GPE_HEADQUARTERS_IN_CITY("gpe:headquarters_in_city", false, 50, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        GPE_HEADQUARTERS_IN_STATE_OR_PROVINCE("gpe:headquarters_in_stateorprovince", false, 50, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION}, new String[]{"NNP", "NN"}, 0.005154400620147864),
        GPE_HEADQUARTERS_IN_COUNTRY("gpe:headquarters_in_country", false, 50, NERTag.GPE, Cardinality.LIST, new NERTag[]{NERTag.ORGANIZATION}, new String[]{"NNP", "NN"}, 0.005154400620147864);

        public final String canonicalName;
        public final boolean isOriginalRelation;
        public final int queryLimit;
        public final NERTag entityType;
        public final Cardinality cardinality;
        public final Set<NERTag> validNamedEntityLabels;
        public final Set<String> validPOSPrefixes;
        public final double priorProbability;
        private static final Map<String, RelationType> cachedFromString;

        private RelationType(String canonicalName, boolean isOriginalRelation, int queryLimit, NERTag type, Cardinality cardinality, NERTag[] validNamedEntityLabels, String[] validPOSPrefixes, double priorProbability) {
            this.canonicalName = canonicalName;
            this.isOriginalRelation = isOriginalRelation;
            this.queryLimit = queryLimit;
            this.entityType = type;
            this.cardinality = cardinality;
            this.validNamedEntityLabels = new HashSet<NERTag>(Arrays.asList(validNamedEntityLabels));
            this.validPOSPrefixes = new HashSet<String>(Arrays.asList(validPOSPrefixes));
            this.priorProbability = priorProbability;
        }

        public static Optional<RelationType> fromString(String name) {
            if (name == null) {
                return Optional.empty();
            }
            String originalName = name;
            if (cachedFromString.get(name) != null) {
                return Optional.of(cachedFromString.get(name));
            }
            if (cachedFromString.containsKey(name)) {
                return Optional.empty();
            }
            for (RelationType slot : RelationType.values()) {
                if (!slot.canonicalName.equals(name) && !slot.name().equals(name)) continue;
                cachedFromString.put(originalName, slot);
                return Optional.of(slot);
            }
            name = name.toLowerCase().replaceAll("[Ss][Ll][Aa][Ss][Hh]", "/");
            for (RelationType slot : RelationType.values()) {
                if (!slot.canonicalName.equalsIgnoreCase(name)) continue;
                cachedFromString.put(originalName, slot);
                return Optional.of(slot);
            }
            cachedFromString.put(originalName, null);
            return Optional.empty();
        }

        public static boolean plausiblyHasRelation(NERTag entityType, NERTag slotValueType) {
            for (RelationType rel : RelationType.values()) {
                if (rel.entityType != entityType || !rel.validNamedEntityLabels.contains((Object)slotValueType)) continue;
                return true;
            }
            return false;
        }

        static {
            cachedFromString = new HashMap<String, RelationType>();
        }

        public static enum Cardinality {
            SINGLE,
            LIST;

        }
    }

    public static enum NERTag {
        CAUSE_OF_DEATH("CAUSE_OF_DEATH", "COD", true),
        CITY("CITY", "CIT", true),
        COUNTRY("COUNTRY", "CRY", true),
        CRIMINAL_CHARGE("CRIMINAL_CHARGE", "CC", true),
        DATE("DATE", "DT", false),
        IDEOLOGY("IDEOLOGY", "IDY", true),
        LOCATION("LOCATION", "LOC", false),
        MISC("MISC", "MSC", false),
        MODIFIER("MODIFIER", "MOD", false),
        NATIONALITY("NATIONALITY", "NAT", true),
        NUMBER("NUMBER", "NUM", false),
        ORGANIZATION("ORGANIZATION", "ORG", false),
        PERSON("PERSON", "PER", false),
        RELIGION("RELIGION", "REL", true),
        STATE_OR_PROVINCE("STATE_OR_PROVINCE", "ST", true),
        TITLE("TITLE", "TIT", true),
        URL("URL", "URL", true),
        DURATION("DURATION", "DUR", false),
        GPE("GPE", "GPE", false);

        public final String name;
        public final String shortName;
        public final boolean isRegexNERType;

        private NERTag(String name, String shortName, boolean isRegexNERType) {
            this.name = name;
            this.shortName = shortName;
            this.isRegexNERType = isRegexNERType;
        }

        public static Optional<NERTag> fromString(String name) {
            if (StringUtils.isNullOrEmpty(name)) {
                return Optional.empty();
            }
            name = name.toUpperCase();
            for (NERTag slot : NERTag.values()) {
                if (!slot.name.equals(name)) continue;
                return Optional.of(slot);
            }
            for (NERTag slot : NERTag.values()) {
                if (!slot.shortName.equals(name)) continue;
                return Optional.of(slot);
            }
            return Optional.empty();
        }
    }
}

