/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.demo;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;

public class TokensRegexAnnotatorDemo {
    private TokensRegexAnnotatorDemo() {
    }

    public static void main(String[] args) throws IOException {
        String rules = args.length > 0 ? args[0] : "edu/stanford/nlp/ling/tokensregex/demo/rules/colors.rules.txt";
        PrintWriter out2 = args.length > 2 ? new PrintWriter(args[2]) : new PrintWriter(System.out);
        Properties properties = new Properties();
        properties.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner,tokensregexdemo");
        properties.setProperty("customAnnotatorClass.tokensregexdemo", "edu.stanford.nlp.pipeline.TokensRegexAnnotator");
        properties.setProperty("tokensregexdemo.rules", rules);
        StanfordCoreNLP pipeline = new StanfordCoreNLP(properties);
        Annotation annotation = args.length > 1 ? new Annotation(IOUtils.slurpFileNoExceptions(args[1])) : new Annotation("Both blue and light blue are nice colors.");
        pipeline.annotate(annotation);
        out2.println();
        out2.println("The top level annotation");
        out2.println(annotation.toShorterString(new String[0]));
        out2.println();
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap sentence : sentences) {
            for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                String word = (String)token.get(CoreAnnotations.TextAnnotation.class);
                String lemma = (String)token.get(CoreAnnotations.LemmaAnnotation.class);
                String pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                String ne = (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                String normalized = (String)token.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
                out2.println("token: word=" + word + ", lemma=" + lemma + ", pos=" + pos + ", ne=" + ne + ", normalized=" + normalized);
            }
        }
        out2.flush();
    }
}

