/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.loglinear.storage;

import com.pholser.junit.quickcheck.ForAll;
import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import edu.stanford.nlp.loglinear.model.GraphicalModel;
import edu.stanford.nlp.loglinear.model.GraphicalModelTest;
import edu.stanford.nlp.loglinear.storage.ModelBatch;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.junit.Assert;
import org.junit.contrib.theories.Theories;
import org.junit.contrib.theories.Theory;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public class ModelBatchTest {
    @Theory
    public void testProtoBatch(@ForAll(sampleSize=50) @From(value={BatchGenerator.class}) ModelBatch batch) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        batch.writeToStream(byteArrayOutputStream);
        byteArrayOutputStream.close();
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ModelBatch recovered = new ModelBatch(byteArrayInputStream);
        byteArrayInputStream.close();
        Assert.assertEquals((long)batch.size(), (long)recovered.size());
        for (int i = 0; i < batch.size(); ++i) {
            Assert.assertTrue((boolean)((GraphicalModel)batch.get(i)).valueEquals((GraphicalModel)recovered.get(i), 1.0E-5));
        }
    }

    @Theory
    public void testProtoBatchModifier(@ForAll(sampleSize=50) @From(value={BatchGenerator.class}) ModelBatch batch) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        batch.writeToStream(byteArrayOutputStream);
        byteArrayOutputStream.close();
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ModelBatch recovered = new ModelBatch(byteArrayInputStream, model -> model.getModelMetaDataByReference().put("testing", "true"));
        byteArrayInputStream.close();
        Assert.assertEquals((long)batch.size(), (long)recovered.size());
        for (int i = 0; i < batch.size(); ++i) {
            Assert.assertEquals((Object)"true", (Object)((GraphicalModel)recovered.get(i)).getModelMetaDataByReference().get("testing"));
        }
    }

    @Theory
    public void testProtoBatchWithoutFactors(@ForAll(sampleSize=50) @From(value={BatchGenerator.class}) ModelBatch batch) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        batch.writeToStreamWithoutFactors(byteArrayOutputStream);
        byteArrayOutputStream.close();
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ModelBatch recovered = new ModelBatch(byteArrayInputStream);
        byteArrayInputStream.close();
        Assert.assertEquals((long)batch.size(), (long)recovered.size());
        for (int i = 0; i < batch.size(); ++i) {
            Assert.assertEquals((long)0L, (long)((GraphicalModel)recovered.get((int)i)).factors.size());
            Assert.assertTrue((boolean)((GraphicalModel)batch.get(i)).getModelMetaDataByReference().equals(((GraphicalModel)recovered.get(i)).getModelMetaDataByReference()));
            for (int j = 0; j < ((GraphicalModel)batch.get(i)).getVariableSizes().length; ++j) {
                Assert.assertTrue((boolean)((GraphicalModel)batch.get(i)).getVariableMetaDataByReference(j).equals(((GraphicalModel)recovered.get(i)).getVariableMetaDataByReference(j)));
            }
        }
    }

    public static class BatchGenerator
    extends Generator<ModelBatch> {
        GraphicalModelTest.GraphicalModelGenerator modelGenerator = new GraphicalModelTest.GraphicalModelGenerator(GraphicalModel.class);

        public BatchGenerator(Class<ModelBatch> type) {
            super(type);
        }

        public ModelBatch generate(SourceOfRandomness sourceOfRandomness, GenerationStatus generationStatus) {
            int length = sourceOfRandomness.nextInt(0, 50);
            ModelBatch batch = new ModelBatch();
            for (int i = 0; i < length; ++i) {
                batch.add(this.modelGenerator.generate(sourceOfRandomness, generationStatus));
            }
            return batch;
        }
    }
}

