/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.dvparser;

import edu.stanford.nlp.parser.common.ArgUtils;
import edu.stanford.nlp.parser.lexparser.EvaluateTreebank;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;

public class CrossValidateTestOptions {
    private static Redwood.RedwoodChannels log = Redwood.channels(CrossValidateTestOptions.class);
    public static final double[] weights = new double[]{0.0, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.4, 0.5, 1.0};

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        int i;
        Object dvmodelFile = null;
        String lexparserFile = null;
        String testTreebankPath = null;
        FileFilter testTreebankFilter = null;
        ArrayList<String> unusedArgs = new ArrayList<String>();
        int argIndex = 0;
        while (argIndex < args.length) {
            if (args[argIndex].equalsIgnoreCase("-lexparser")) {
                lexparserFile = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-testTreebank")) {
                Pair<String, FileFilter> treebankDescription = ArgUtils.getTreebankDescription(args, argIndex, "-testTreebank");
                argIndex = argIndex + ArgUtils.numSubArgs(args, argIndex) + 1;
                testTreebankPath = treebankDescription.first();
                testTreebankFilter = treebankDescription.second();
                continue;
            }
            unusedArgs.add(args[argIndex++]);
        }
        log.info("Loading lexparser from: " + lexparserFile);
        String[] newArgs = unusedArgs.toArray(new String[unusedArgs.size()]);
        LexicalizedParser lexparser = LexicalizedParser.loadModel(lexparserFile, newArgs);
        log.info("... done");
        MemoryTreebank testTreebank = null;
        if (testTreebankPath != null) {
            log.info("Reading in trees from " + testTreebankPath);
            if (testTreebankFilter != null) {
                log.info("Filtering on " + testTreebankFilter);
            }
            testTreebank = lexparser.getOp().tlpParams.memoryTreebank();
            testTreebank.loadPath(testTreebankPath, testTreebankFilter);
            log.info("Read in " + ((Treebank)testTreebank).size() + " trees for testing");
        }
        double[] labelResults = new double[weights.length];
        double[] tagResults = new double[weights.length];
        for (i = 0; i < weights.length; ++i) {
            lexparser.getOp().baseParserWeight = weights[i];
            EvaluateTreebank evaluator = new EvaluateTreebank(lexparser);
            evaluator.testOnTreebank(testTreebank);
            labelResults[i] = evaluator.getLBScore();
            tagResults[i] = evaluator.getTagScore();
        }
        for (i = 0; i < weights.length; ++i) {
            log.info("LexicalizedParser weight " + weights[i] + ": labeled " + labelResults[i] + " tag " + tagResults[i]);
        }
    }
}

