/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.process.WordSegmenter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class MaxMatchSegmenter
implements WordSegmenter {
    private final Set<String> words = Generics.newHashSet();
    private static final int maxLength = 10;
    private static final long serialVersionUID = 8260792244886911724L;

    @Override
    public void initializeTraining(double numTrees) {
    }

    @Override
    public void train(Collection<Tree> trees) {
        for (Tree tree : trees) {
            this.train(tree);
        }
    }

    @Override
    public void train(Tree tree) {
        this.train((List<TaggedWord>)tree.taggedYield());
    }

    @Override
    public void train(List<TaggedWord> sentence) {
        for (TaggedWord word : sentence) {
            if (word.word().length() > 10) continue;
            this.words.add(word.word());
        }
    }

    @Override
    public void finishTraining() {
    }

    @Override
    public void loadSegmenter(String filename) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<HasWord> segment(String s) {
        ArrayList<Word> segmentedWords = new ArrayList<Word>();
        int start = 0;
        int length = s.length();
        while (start < length) {
            int end;
            for (end = Math.min(length, start + 10); end > start + 1; --end) {
                String nextWord = s.substring(start, end);
                if (!this.words.contains(nextWord)) continue;
                segmentedWords.add(new Word(nextWord));
                break;
            }
            if (end == start + 1) {
                if (s.codePointAt(start) >= 65536) {
                    segmentedWords.add(new Word(new String(s.substring(start, start + 2))));
                    start += 2;
                    continue;
                }
                segmentedWords.add(new Word(new String(s.substring(start, start + 1))));
                ++start;
                continue;
            }
            start = end;
        }
        return new ArrayList<HasWord>(segmentedWords);
    }
}

