/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.NERClassifierCombiner;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.NERCombinerAnnotator;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.sequences.ColumnTabDocumentReaderWriter;
import edu.stanford.nlp.util.CoreMap;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class NERCombinerAnnotatorITest
extends TestCase {
    public static final String NER_3CLASS = "edu/stanford/nlp/models/ner/english.all.3class.distsim.crf.ser.gz";
    public static final String NER_7CLASS = "edu/stanford/nlp/models/ner/english.muc.7class.distsim.crf.ser.gz";
    public static final String NER_MISCCLASS = "edu/stanford/nlp/models/ner/english.conll.4class.distsim.crf.ser.gz";
    private static NERCombinerAnnotator nerAnnotator = null;
    private static AnnotationPipeline unthreadedPipeline = null;
    private static AnnotationPipeline threaded4Pipeline = null;
    public static final String TEXT = "John Bauer used to work at Stanford.  He worked there for 4 years.  John left in August 2014.  ";
    public static final String[][] ANSWERS = new String[][]{{"PERSON", "PERSON", "O", "O", "O", "O", "ORGANIZATION", "O"}, {"O", "O", "O", "O", "O", "O", "O"}, {"PERSON", "O", "O", "O", "O", "O"}};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        Class<NERCombinerAnnotatorITest> clazz = NERCombinerAnnotatorITest.class;
        synchronized (NERCombinerAnnotatorITest.class) {
            if (nerAnnotator == null) {
                nerAnnotator = new NERCombinerAnnotator(false, NER_3CLASS, NER_7CLASS, NER_MISCCLASS);
                Properties props = new Properties();
                props.setProperty("ner.applyNumericClassifiers", "false");
                props.setProperty("ner.useSUTime", "false");
                props.setProperty("ner.model", NER_3CLASS);
                NERClassifierCombiner ner = NERClassifierCombiner.createNERClassifierCombiner("ner", props);
                NERCombinerAnnotator threaded4Annotator = new NERCombinerAnnotator(ner, false, 4, -1L);
                threaded4Pipeline = new AnnotationPipeline();
                threaded4Pipeline.addAnnotator(new TokenizerAnnotator(false, "en"));
                threaded4Pipeline.addAnnotator(new WordsToSentencesAnnotator(false));
                threaded4Pipeline.addAnnotator(threaded4Annotator);
                NERCombinerAnnotator unthreadedAnnotator = new NERCombinerAnnotator(ner, false, 1, -1L);
                unthreadedPipeline = new AnnotationPipeline();
                unthreadedPipeline.addAnnotator(new TokenizerAnnotator(false, "en"));
                unthreadedPipeline.addAnnotator(new WordsToSentencesAnnotator(false));
                unthreadedPipeline.addAnnotator(unthreadedAnnotator);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void testPipelineAnnotator() {
        Annotation document = new Annotation(TEXT);
        unthreadedPipeline.annotate(document);
        NERCombinerAnnotatorITest.verifyAnswers(ANSWERS, document);
    }

    public void testThreadedAnnotator() {
        Annotation document = new Annotation(TEXT);
        threaded4Pipeline.annotate(document);
        NERCombinerAnnotatorITest.verifyAnswers(ANSWERS, document);
        document = new Annotation("John Bauer used to work at Stanford.  He worked there for 4 years.  John left in August 2014.  John Bauer used to work at Stanford.  He worked there for 4 years.  John left in August 2014.  John Bauer used to work at Stanford.  He worked there for 4 years.  John left in August 2014.  ");
        threaded4Pipeline.annotate(document);
        NERCombinerAnnotatorITest.verifyAnswers(ANSWERS, document);
    }

    public static void verifyAnswers(String[][] expected, Annotation document) {
        int sentenceIndex = 0;
        for (CoreMap sentence : (List)document.get(CoreAnnotations.SentencesAnnotation.class)) {
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            NERCombinerAnnotatorITest.assertEquals((int)expected[sentenceIndex % expected.length].length, (int)tokens.size());
            int token = 0;
            for (CoreLabel word : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                NERCombinerAnnotatorITest.assertEquals((String)expected[sentenceIndex % expected.length][token], (String)word.ner());
                ++token;
            }
            ++sentenceIndex;
        }
    }

    private static Iterator<Annotation> getTestData(String inputString, boolean includeAnswer) {
        ColumnTabDocumentReaderWriter colReader = new ColumnTabDocumentReaderWriter();
        if (includeAnswer) {
            colReader.init("word=0,tag=1,answer=2");
        } else {
            colReader.init("word=0,tag=1");
        }
        StringReader strReader = new StringReader(inputString);
        return colReader.getDocIterator(strReader);
    }

    private static void checkAnnotation(String goldInputString) throws Exception {
        Iterator<Annotation> goldDocs = NERCombinerAnnotatorITest.getTestData(goldInputString, true);
        Iterator<Annotation> testDocs = NERCombinerAnnotatorITest.getTestData(goldInputString, false);
        int k = 0;
        while (testDocs.hasNext()) {
            Annotation goldDoc = goldDocs.next();
            Annotation testDoc = testDocs.next();
            nerAnnotator.annotate(testDoc);
            List goldTokens = (List)goldDoc.get(CoreAnnotations.TokensAnnotation.class);
            List testTokens = (List)testDoc.get(CoreAnnotations.TokensAnnotation.class);
            NERCombinerAnnotatorITest.assertEquals((String)"token number", (int)goldTokens.size(), (int)testTokens.size());
            for (int i = 0; i < goldTokens.size(); ++i) {
                CoreLabel goldToken = (CoreLabel)goldTokens.get(i);
                CoreLabel testToken = (CoreLabel)testTokens.get(i);
                String goldNer = (String)goldToken.get(CoreAnnotations.AnswerAnnotation.class);
                String testNer = (String)testToken.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                NERCombinerAnnotatorITest.assertEquals((String)("Ner tag for token " + i + " (\"" + testToken.word() + "\") doc " + k), (String)goldNer, (String)testNer);
            }
            ++k;
        }
    }

    public void testCombinedAnnotation() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("EU\tNNP\tORGANIZATION\n");
        sb.append("rejects\tVBZ\tO\n");
        sb.append("German\tNNP\tNATIONALITY\n");
        sb.append("call\tNN\tO\n");
        sb.append("to\tTO\tO\n");
        sb.append("boycott\tVB\tO\n");
        sb.append("British\tNNP\tNATIONALITY\n");
        sb.append("lamb\tNN\tO\n");
        sb.append(".\t.\tO\n");
        sb.append("Peter\tNNP\tPERSON\n");
        sb.append("Blackburn\tNNP\tPERSON\n");
        sb.append("BRUSSELS\tNNP\tCITY\n");
        sb.append("1996-08-22\tCD\tDATE\n");
        sb.append("It\tPRP\tO\n");
        sb.append("is\tVBZ\tO\n");
        sb.append("bright\tJJ\tO\n");
        sb.append("during\tIN\tO\n");
        sb.append("the\tDT\tDATE\n");
        sb.append("day\tNN\tDATE\n");
        sb.append(".\t.\tO\n");
        sb.append("It\tPRP\tO\n");
        sb.append("was\tVBZ\tO\n");
        sb.append("2\tJJ\tDURATION\n");
        sb.append("days\tIN\tDURATION\n");
        sb.append("before\tDT\tO\n");
        sb.append("the\tNN\tO\n");
        sb.append("meeting\tNN\tO\n");
        sb.append(".\t.\tO\n");
        NERCombinerAnnotatorITest.checkAnnotation(sb.toString());
    }
}

