/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.paragraphs.ParagraphAnnotator;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.QuoteAnnotator;
import edu.stanford.nlp.quoteattribution.ChapterAnnotator;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.quoteattribution.QuoteAttributionUtils;
import edu.stanford.nlp.quoteattribution.Sieves.MSSieves.BaselineTopSpeakerSieve;
import edu.stanford.nlp.quoteattribution.Sieves.MSSieves.DeterministicSpeakerSieve;
import edu.stanford.nlp.quoteattribution.Sieves.MSSieves.LooseConversationalSpeakerSieve;
import edu.stanford.nlp.quoteattribution.Sieves.MSSieves.MSSieve;
import edu.stanford.nlp.quoteattribution.Sieves.MSSieves.MajoritySpeakerSieve;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.ClosestMentionSieve;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.ConversationalSieve;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.DependencyParseSieve;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.LooseConversationalSieve;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.OneNameSentenceSieve;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.ParagraphEndQuoteClosestSieve;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.QMSieve;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.SupervisedSieve;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.TrigramSieve;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.VocativeSieve;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class QuoteAttributionAnnotator
implements Annotator {
    private static Redwood.RedwoodChannels log = Redwood.channels(QuoteAttributionAnnotator.class);
    public static final String DEFAULT_QMSIEVES = "tri,dep,onename,voc,paraend,conv,sup,loose";
    public static final String DEFAULT_MSSIEVES = "det,top";
    public static final String DEFAULT_MODEL_PATH = "edu/stanford/nlp/models/quoteattribution/quoteattribution_model.ser";
    public static String FAMILY_WORD_LIST = "edu/stanford/nlp/models/quoteattribution/family_words.txt";
    public static String ANIMACY_WORD_LIST = "edu/stanford/nlp/models/quoteattribution/animate.unigrams.txt";
    public static String GENDER_WORD_LIST = "edu/stanford/nlp/models/quoteattribution/gender_filtered.txt";
    public static String COREF_PATH = "";
    public static String MODEL_PATH = "edu/stanford/nlp/models/quoteattribution/quoteattribution_model.ser";
    public static String CHARACTERS_FILE = "";
    public boolean buildCharacterMapPerAnnotation = false;
    public boolean useCoref = true;
    public Boolean VERBOSE = false;
    private Set<String> animacyList;
    private Set<String> familyRelations;
    private Map<String, Person.Gender> genderMap;
    private Map<String, List<Person>> characterMap;
    private String qmSieveList;
    private String msSieveList;

    public QuoteAttributionAnnotator(Properties props) {
        this.VERBOSE = PropertiesUtils.getBool(props, "verbose", false);
        Timing timer = null;
        COREF_PATH = props.getProperty("booknlpCoref", null);
        if (COREF_PATH == null && this.VERBOSE.booleanValue()) {
            log.err("Warning: no coreference map!");
        }
        MODEL_PATH = props.getProperty("modelPath", DEFAULT_MODEL_PATH);
        CHARACTERS_FILE = props.getProperty("charactersPath", null);
        if (CHARACTERS_FILE == null && this.VERBOSE.booleanValue()) {
            log.err("Warning: no characters file!");
        }
        this.qmSieveList = props.getProperty("QMSieves", DEFAULT_QMSIEVES);
        this.msSieveList = props.getProperty("MSSieves", DEFAULT_MSSIEVES);
        if (this.VERBOSE.booleanValue()) {
            timer = new Timing();
            log.info("Loading QuoteAttribution coref [" + COREF_PATH + "]...");
            log.info("Loading QuoteAttribution characters [" + CHARACTERS_FILE + "]...");
        }
        FAMILY_WORD_LIST = props.getProperty("familyWordsFile", FAMILY_WORD_LIST);
        ANIMACY_WORD_LIST = props.getProperty("animacyWordsFile", ANIMACY_WORD_LIST);
        GENDER_WORD_LIST = props.getProperty("genderNamesFile", GENDER_WORD_LIST);
        this.familyRelations = QuoteAttributionUtils.readFamilyRelations(FAMILY_WORD_LIST);
        this.genderMap = QuoteAttributionUtils.readGenderedNounList(GENDER_WORD_LIST);
        this.animacyList = QuoteAttributionUtils.readAnimacyList(ANIMACY_WORD_LIST);
        if (this.characterMap != null) {
            this.characterMap = QuoteAttributionUtils.readPersonMap(CHARACTERS_FILE);
        } else {
            this.buildCharacterMapPerAnnotation = true;
        }
        this.useCoref = PropertiesUtils.getBool(props, "useCoref", this.useCoref);
        if (this.VERBOSE.booleanValue()) {
            timer.stop("done.");
        }
    }

    public void entityMentionsToCharacterMap(Annotation annotation) {
        this.characterMap = new HashMap<String, List<Person>>();
        for (CoreMap entityMention : (List)annotation.get(CoreAnnotations.MentionsAnnotation.class)) {
            String entityMentionString = entityMention.toString();
            if (!((String)entityMention.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals("PERSON")) continue;
            Person newPerson = new Person(entityMentionString, "UNK", new ArrayList<String>());
            ArrayList<Person> newPersonList = new ArrayList<Person>();
            newPersonList.add(newPerson);
            this.characterMap.put(entityMentionString, newPersonList);
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        boolean perDocumentCharacterMap = false;
        if (this.buildCharacterMapPerAnnotation && annotation.containsKey(CoreAnnotations.MentionsAnnotation.class)) {
            this.entityMentionsToCharacterMap(annotation);
        }
        Properties propsPara = new Properties();
        propsPara.setProperty("paragraphBreak", "one");
        ParagraphAnnotator pa = new ParagraphAnnotator(propsPara, false);
        pa.annotate(annotation);
        Map<Integer, String> pronounCorefMap = QuoteAttributionUtils.setupCoref(COREF_PATH, this.characterMap, annotation);
        new ChapterAnnotator().annotate(annotation);
        QuoteAttributionUtils.addEnhancedSentences(annotation);
        QuoteAttributionUtils.annotateForDependencyParse(annotation);
        Annotation preprocessed = annotation;
        Map<String, QMSieve> qmSieves = this.getQMMapping(preprocessed, pronounCorefMap);
        for (String sieveName : this.qmSieveList.split(",")) {
            qmSieves.get(sieveName).doQuoteToMention(preprocessed);
        }
        Map<String, MSSieve> msSieves = this.getMSMapping(preprocessed, pronounCorefMap);
        for (String sieveName : this.msSieveList.split(",")) {
            msSieves.get(sieveName).doMentionToSpeaker(preprocessed);
        }
        for (CoreMap quote : QuoteAnnotator.gatherQuotes(annotation)) {
            CoreMap entityMention;
            Integer canonicalEntityMentionIndex;
            CoreLabel firstSpeakerToken;
            Integer entityMentionIndex;
            Integer firstSpeakerTokenIndex = (Integer)quote.get(MentionBeginAnnotation.class);
            if (firstSpeakerTokenIndex == null || (entityMentionIndex = (Integer)(firstSpeakerToken = (CoreLabel)((List)annotation.get(CoreAnnotations.TokensAnnotation.class)).get(firstSpeakerTokenIndex)).get(CoreAnnotations.EntityMentionIndexAnnotation.class)) == null || (canonicalEntityMentionIndex = (Integer)(entityMention = (CoreMap)((List)annotation.get(CoreAnnotations.MentionsAnnotation.class)).get(entityMentionIndex)).get(CoreAnnotations.CanonicalEntityMentionIndexAnnotation.class)) == null) continue;
            CoreMap canonicalEntityMention = (CoreMap)((List)annotation.get(CoreAnnotations.MentionsAnnotation.class)).get(canonicalEntityMentionIndex);
            quote.set(CanonicalMentionAnnotation.class, (String)canonicalEntityMention.get(CoreAnnotations.TextAnnotation.class));
            List canonicalEntityMentionTokens = (List)canonicalEntityMention.get(CoreAnnotations.TokensAnnotation.class);
            CoreLabel canonicalEntityMentionFirstToken = (CoreLabel)canonicalEntityMentionTokens.get(0);
            CoreLabel canonicalEntityMentionLastToken = (CoreLabel)canonicalEntityMentionTokens.get(canonicalEntityMentionTokens.size() - 1);
            quote.set(CanonicalMentionBeginAnnotation.class, (Integer)canonicalEntityMentionFirstToken.get(CoreAnnotations.TokenBeginAnnotation.class));
            quote.set(CanonicalMentionEndAnnotation.class, (Integer)canonicalEntityMentionLastToken.get(CoreAnnotations.TokenBeginAnnotation.class));
        }
    }

    private Map<String, QMSieve> getQMMapping(Annotation doc, Map<Integer, String> pronounCorefMap) {
        HashMap<String, QMSieve> map = new HashMap<String, QMSieve>();
        map.put("tri", new TrigramSieve(doc, this.characterMap, pronounCorefMap, this.animacyList));
        map.put("dep", new DependencyParseSieve(doc, this.characterMap, pronounCorefMap, this.animacyList));
        map.put("onename", new OneNameSentenceSieve(doc, this.characterMap, pronounCorefMap, this.animacyList));
        map.put("voc", new VocativeSieve(doc, this.characterMap, pronounCorefMap, this.animacyList));
        map.put("paraend", new ParagraphEndQuoteClosestSieve(doc, this.characterMap, pronounCorefMap, this.animacyList));
        SupervisedSieve ss = new SupervisedSieve(doc, this.characterMap, pronounCorefMap, this.animacyList);
        ss.loadModel(MODEL_PATH);
        map.put("sup", ss);
        map.put("conv", new ConversationalSieve(doc, this.characterMap, pronounCorefMap, this.animacyList));
        map.put("loose", new LooseConversationalSieve(doc, this.characterMap, pronounCorefMap, this.animacyList));
        map.put("closest", new ClosestMentionSieve(doc, this.characterMap, pronounCorefMap, this.animacyList));
        return map;
    }

    private Map<String, MSSieve> getMSMapping(Annotation doc, Map<Integer, String> pronounCorefMap) {
        HashMap<String, MSSieve> map = new HashMap<String, MSSieve>();
        map.put("det", new DeterministicSpeakerSieve(doc, this.characterMap, pronounCorefMap, this.animacyList));
        map.put("loose", new LooseConversationalSpeakerSieve(doc, this.characterMap, pronounCorefMap, this.animacyList));
        map.put("top", new BaselineTopSpeakerSieve(doc, this.characterMap, pronounCorefMap, this.animacyList, this.genderMap, this.familyRelations));
        map.put("maj", new MajoritySpeakerSieve(doc, this.characterMap, pronounCorefMap, this.animacyList));
        return map;
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return new HashSet<Class<? extends CoreAnnotation>>(Arrays.asList(MentionAnnotation.class, MentionBeginAnnotation.class, MentionEndAnnotation.class, CanonicalMentionAnnotation.class, CanonicalMentionBeginAnnotation.class, CanonicalMentionEndAnnotation.class, MentionTypeAnnotation.class, MentionSieveAnnotation.class, SpeakerAnnotation.class, SpeakerSieveAnnotation.class, CoreAnnotations.ParagraphIndexAnnotation.class));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        HashSet<Class<? extends CoreAnnotation>> quoteAttributionRequirements = new HashSet<Class<? extends CoreAnnotation>>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.LemmaAnnotation.class, CoreAnnotations.NamedEntityTagAnnotation.class, CoreAnnotations.MentionsAnnotation.class, CoreAnnotations.BeforeAnnotation.class, CoreAnnotations.AfterAnnotation.class, CoreAnnotations.TokenBeginAnnotation.class, CoreAnnotations.TokenEndAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class));
        if (this.useCoref) {
            quoteAttributionRequirements.add(CorefCoreAnnotations.CorefChainAnnotation.class);
        }
        return quoteAttributionRequirements;
    }

    public static class CanonicalMentionEndAnnotation
    implements CoreAnnotation<Integer> {
        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }
    }

    public static class CanonicalMentionBeginAnnotation
    implements CoreAnnotation<Integer> {
        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }
    }

    public static class CanonicalMentionAnnotation
    implements CoreAnnotation<String> {
        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    public static class SpeakerSieveAnnotation
    implements CoreAnnotation<String> {
        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    public static class SpeakerAnnotation
    implements CoreAnnotation<String> {
        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    public static class MentionSieveAnnotation
    implements CoreAnnotation<String> {
        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    public static class MentionTypeAnnotation
    implements CoreAnnotation<String> {
        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    public static class MentionEndAnnotation
    implements CoreAnnotation<Integer> {
        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }
    }

    public static class MentionBeginAnnotation
    implements CoreAnnotation<Integer> {
        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }
    }

    public static class MentionAnnotation
    implements CoreAnnotation<String> {
        @Override
        public Class<String> getType() {
            return String.class;
        }
    }
}

