/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.TestClassifier;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

class TestThreadedTagger {
    static final int DEFAULT_NUM_THREADS = 2;
    static final String THREAD_FLAG = "numThreads";

    private TestThreadedTagger() {
    }

    public static void compareResults(String results, String baseline) {
        if (!results.equals(baseline)) {
            throw new RuntimeException("Results different from expected baseline");
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, IOException, InterruptedException {
        Properties props = StringUtils.argsToProperties(args);
        TestThreadedTagger.runThreadedTest(props);
    }

    public static void runThreadedTest(Properties props) throws ClassNotFoundException, IOException, InterruptedException {
        ArrayList<Properties> configs = new ArrayList<Properties>();
        ArrayList<MaxentTagger> taggers = new ArrayList<MaxentTagger>();
        int numThreads = 2;
        if (props.getProperty(THREAD_FLAG) != null) {
            numThreads = Integer.valueOf(props.getProperty(THREAD_FLAG));
        }
        System.out.println();
        System.out.println("Loading taggers...");
        System.out.println();
        if (props.getProperty("model") != null) {
            configs.add(props);
            taggers.add(new MaxentTagger(((Properties)configs.get(0)).getProperty("model"), (Properties)configs.get(0)));
        } else {
            int taggerNum = 1;
            String taggerName = "model" + taggerNum;
            while (props.getProperty(taggerName) != null) {
                Properties newProps = new Properties();
                newProps.putAll((Map<?, ?>)props);
                newProps.setProperty("model", props.getProperty(taggerName));
                configs.add(newProps);
                taggers.add(new MaxentTagger(((Properties)configs.get(taggerNum - 1)).getProperty("model"), (Properties)configs.get(taggerNum - 1)));
                taggerName = "model" + ++taggerNum;
            }
        }
        if (taggers.isEmpty()) {
            throw new IllegalArgumentException("Please specify at least one of -model or -model1");
        }
        System.out.println();
        System.out.println("Running the baseline results for tagger 1");
        System.out.println();
        TaggerThread baselineThread = new TaggerThread((MaxentTagger)taggers.get(0), "BaseResults-1");
        baselineThread.start();
        baselineThread.join();
        ArrayList<String> baselineResults = new ArrayList<String>();
        baselineResults.add(baselineThread.getResultsString());
        System.out.println();
        System.out.println("Running " + numThreads + " threads of tagger 1");
        System.out.println();
        ArrayList<TaggerThread> threads = new ArrayList<TaggerThread>();
        for (int i = 0; i < numThreads; ++i) {
            threads.add(new TaggerThread((MaxentTagger)taggers.get(0), "Simultaneous-" + (i + 1)));
        }
        for (TaggerThread thread : threads) {
            thread.start();
        }
        for (TaggerThread thread : threads) {
            thread.join();
            TestThreadedTagger.compareResults(thread.getResultsString(), (String)baselineResults.get(0));
        }
        if (taggers.size() > 1) {
            int i;
            for (i = 1; i < taggers.size(); ++i) {
                System.out.println();
                System.out.println("Running the baseline results for tagger " + (i + 1));
                System.out.println();
                baselineThread = new TaggerThread((MaxentTagger)taggers.get(i), "BaseResults-" + (i + 1));
                baselineThread.start();
                baselineThread.join();
                baselineResults.add(baselineThread.getResultsString());
            }
            System.out.println();
            System.out.println("Running " + taggers.size() + " threads of different taggers");
            System.out.println();
            threads.clear();
            for (i = 0; i < taggers.size(); ++i) {
                threads.add(new TaggerThread((MaxentTagger)taggers.get(i), "DifferentTaggers-" + (i + 1)));
            }
            for (TaggerThread thread : threads) {
                thread.start();
            }
            for (int i2 = 0; i2 < taggers.size(); ++i2) {
                TaggerThread thread;
                thread = (TaggerThread)threads.get(i2);
                thread.join();
                TestThreadedTagger.compareResults(thread.getResultsString(), (String)baselineResults.get(i2));
            }
        }
        System.out.println("Done!");
    }

    private static class TaggerThread
    extends Thread {
        private final MaxentTagger tagger;
        private final String threadName;
        private String resultsString = "";

        public String getResultsString() {
            return this.resultsString;
        }

        TaggerThread(MaxentTagger tagger, String name) {
            this.tagger = tagger;
            this.threadName = name;
        }

        @Override
        public void run() {
            try {
                Timing t = new Timing();
                TestClassifier testClassifier = new TestClassifier(this.tagger);
                long millis = t.stop();
                this.resultsString = testClassifier.resultsString(this.tagger);
                System.out.println("Thread " + this.threadName + " took " + millis + " milliseconds to tag " + testClassifier.getNumWords() + " words.\n" + this.resultsString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

