/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.trees.international.pennchinese.CEDict;
import edu.stanford.nlp.util.Generics;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class TraditionalSimplifiedCharacterMap
implements Function<String, String> {
    Map<String, String> map = Generics.newHashMap();
    String[][] HARDCODED = new String[][]{{"\u9e7c", "\u78b1"}, {"\u65bc", "\u4e8e"}, {"\u7947", "\u53ea"}, {"\u5f77", "\u4eff"}, {"\u751a", "\u4ec0"}, {"\u9ebd", "\u4e48"}};

    public TraditionalSimplifiedCharacterMap() {
        this(CEDict.path());
    }

    public TraditionalSimplifiedCharacterMap(String path) {
        try {
            FileInputStream fis = new FileInputStream(path);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "utf-8");
            BufferedReader br = new BufferedReader(isr);
            this.init(br);
            br.close();
            isr.close();
            fis.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    void init(BufferedReader reader) {
        try {
            String line;
            Set<String> hardcodedSet = Generics.newHashSet();
            for (String[] transform : this.HARDCODED) {
                hardcodedSet.add(transform[0]);
                String traditional = transform[0];
                String simplified = transform[1];
                this.map.put(traditional, simplified);
            }
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.length() < 3 || line.charAt(1) != ' ' || line.charAt(3) != ' ') continue;
                String traditional = line.substring(0, 1);
                String simplified = line.substring(2, 3);
                if (this.map.containsKey(traditional) && !hardcodedSet.contains(traditional) && !simplified.equals(this.map.get(traditional))) {
                    throw new RuntimeException("Character " + traditional + " mapped to " + simplified + " already mapped to " + this.map.get(traditional));
                }
                this.map.put(traditional, simplified);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public String apply(String input) {
        StringBuilder translated = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            String c = input.substring(i, i + 1);
            if (this.map.containsKey(c)) {
                translated.append(this.map.get(c));
                continue;
            }
            translated.append(c);
        }
        return translated.toString();
    }

    public void translateLines(BufferedReader br, BufferedWriter bw) {
        try {
            String line;
            while ((line = br.readLine()) != null) {
                bw.write(this.apply(line));
                bw.newLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void translateFile(String input, String output) {
        try {
            FileInputStream fis = new FileInputStream(input);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "utf-8");
            BufferedReader br = new BufferedReader(isr);
            FileOutputStream fos = new FileOutputStream(output);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "utf-8");
            BufferedWriter bw = new BufferedWriter(osw);
            this.translateLines(br, bw);
            bw.close();
            osw.close();
            fos.close();
            br.close();
            isr.close();
            fis.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static void main(String[] args) {
        TraditionalSimplifiedCharacterMap mapper = new TraditionalSimplifiedCharacterMap();
        mapper.translateFile(args[0], args[1]);
    }
}

