/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.DeltaMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;

public class DeltaMapTest
extends TestCase {
    private Map<Integer, Integer> originalMap;
    private Map<Integer, Integer> originalCopyMap;
    private Map<Integer, Integer> deltaCopyMap;
    private Map<Integer, Integer> deltaMap;
    private static final int BOUND3 = 100;
    private static final int BOUND2 = 90;
    private static final int BOUND4 = 110;
    private static final int BOUND1 = 10;

    protected void setUp() {
        Integer rInt;
        int i;
        this.originalMap = new HashMap<Integer, Integer>();
        Random r = new Random();
        for (i = 0; i < 100; ++i) {
            this.originalMap.put(i, r.nextInt(100));
        }
        this.originalCopyMap = new HashMap<Integer, Integer>(this.originalMap);
        this.deltaCopyMap = new HashMap<Integer, Integer>(this.originalMap);
        this.deltaMap = new DeltaMap<Integer, Integer>(this.originalMap);
        for (i = 90; i < 110; ++i) {
            rInt = r.nextInt(100);
            this.deltaMap.put(i, rInt);
            this.deltaCopyMap.put(i, rInt);
        }
        for (i = 0; i < 10; ++i) {
            rInt = r.nextInt(110);
            this.deltaMap.remove(rInt);
            this.deltaCopyMap.remove(rInt);
        }
        for (i = 0; i < 10; ++i) {
            rInt = r.nextInt(110);
            this.deltaMap.put(rInt, null);
            this.deltaCopyMap.put(rInt, null);
        }
    }

    public void testOriginalPreserved() {
        DeltaMapTest.assertEquals(this.originalCopyMap, this.originalMap);
    }

    public void testDeltaAccurate() {
        DeltaMapTest.assertEquals(this.deltaCopyMap, this.deltaMap);
    }
}

