/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.fsm.DFSA;
import edu.stanford.nlp.fsm.DFSAState;
import edu.stanford.nlp.fsm.DFSATransition;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Arrays;

public class ViterbiSearchGraphBuilder {
    private static Redwood.RedwoodChannels log = Redwood.channels(ViterbiSearchGraphBuilder.class);

    public static DFSA<String, Integer> getGraph(SequenceModel ts, Index<String> classIndex) {
        int product;
        int pos;
        DFSA<String, Integer> viterbiSearchGraph = new DFSA<String, Integer>(null);
        int length = ts.length();
        int leftWindow = ts.leftWindow();
        int rightWindow = ts.rightWindow();
        assert (rightWindow == 0);
        int padLength = length + leftWindow + rightWindow;
        int[][] tags = new int[padLength][];
        int[] tagNum = new int[padLength];
        for (int pos2 = 0; pos2 < padLength; ++pos2) {
            tags[pos2] = ts.getPossibleValues(pos2);
            tagNum[pos2] = tags[pos2].length;
        }
        DFSAState[][] graphStates = null;
        DFSAState<String, Integer> startState = null;
        DFSAState endState = null;
        if (viterbiSearchGraph != null) {
            int stateId = -1;
            startState = new DFSAState<String, Integer>(++stateId, viterbiSearchGraph, 0.0);
            viterbiSearchGraph.setInitialState(startState);
            graphStates = new DFSAState[length][];
            for (int pos3 = 0; pos3 < length; ++pos3) {
                graphStates[pos3] = new DFSAState[tags[pos3].length];
                for (int product2 = 0; product2 < tags[pos3].length; ++product2) {
                    graphStates[pos3][product2] = new DFSAState<String, Integer>(++stateId, viterbiSearchGraph);
                }
            }
            endState = new DFSAState(++stateId, viterbiSearchGraph, 0.0);
            endState.setAccepting(true);
        }
        int[] tempTags = new int[padLength];
        int[] productSizes = new int[padLength];
        int curProduct = 1;
        for (int i = 0; i < leftWindow; ++i) {
            curProduct *= tagNum[i];
        }
        for (int pos4 = leftWindow; pos4 < padLength; ++pos4) {
            if (pos4 > leftWindow + rightWindow) {
                curProduct /= tagNum[pos4 - leftWindow - rightWindow - 1];
            }
            productSizes[pos4 - rightWindow] = curProduct *= tagNum[pos4];
        }
        double[][] windowScore = new double[padLength][];
        for (pos = leftWindow; pos < leftWindow + length; ++pos) {
            windowScore[pos] = new double[productSizes[pos]];
            Arrays.fill(tempTags, tags[0][0]);
            for (product = 0; product < productSizes[pos]; ++product) {
                int p = product;
                int shift = 1;
                for (int curPos = pos; curPos >= pos - leftWindow; --curPos) {
                    tempTags[curPos] = tags[curPos][p % tagNum[curPos]];
                    p /= tagNum[curPos];
                    if (curPos <= pos) continue;
                    shift *= tagNum[curPos];
                }
                if (tempTags[pos] != tags[pos][0]) continue;
                double[] scores = ts.scoresOf(tempTags, pos);
                for (int t = 0; t < tagNum[pos]; ++t) {
                    windowScore[pos][product + t * shift] = scores[t];
                }
            }
        }
        for (pos = leftWindow; pos < length + leftWindow; ++pos) {
            for (product = 0; product < productSizes[pos]; ++product) {
                if (pos == leftWindow) {
                    int curTag = tags[pos][product % tagNum[pos]];
                    DFSATransition<String, Integer> tr = new DFSATransition<String, Integer>("", startState, graphStates[pos][product], classIndex.get(curTag), "", -windowScore[pos][product]);
                    startState.addTransition(tr);
                    continue;
                }
                int sharedProduct = product / tagNum[pos + rightWindow];
                int factor = productSizes[pos] / tagNum[pos + rightWindow];
                for (int newTagNum = 0; newTagNum < tagNum[pos - leftWindow - 1]; ++newTagNum) {
                    int predProduct = newTagNum * factor + sharedProduct;
                    int predTag = tags[pos - 1][predProduct % tagNum[pos - 1]];
                    int curTag = tags[pos][product % tagNum[pos]];
                    DFSAState sourceState = graphStates[pos - leftWindow][predTag];
                    DFSAState destState = pos - leftWindow + 1 == graphStates.length ? endState : graphStates[pos - leftWindow + 1][curTag];
                    DFSATransition tr = new DFSATransition("", sourceState, destState, classIndex.get(curTag), "", -windowScore[pos][product]);
                    graphStates[pos - leftWindow][predTag].addTransition(tr);
                }
            }
        }
        return viterbiSearchGraph;
    }
}

