/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.Evaluator;
import edu.stanford.nlp.optimization.HasEvaluators;
import edu.stanford.nlp.optimization.Minimizer;

public class HybridMinimizer
implements Minimizer<DiffFunction>,
HasEvaluators {
    private final Minimizer<DiffFunction> firstMinimizer;
    private final Minimizer<DiffFunction> secondMinimizer;
    private final int iterationCutoff;

    public HybridMinimizer(Minimizer<DiffFunction> minimizerOne, Minimizer<DiffFunction> minimizerTwo, int iterationCutoff) {
        this.firstMinimizer = minimizerOne;
        this.secondMinimizer = minimizerTwo;
        this.iterationCutoff = iterationCutoff;
    }

    @Override
    public void setEvaluators(int iters, Evaluator[] evaluators) {
        if (this.firstMinimizer instanceof HasEvaluators) {
            ((HasEvaluators)((Object)this.firstMinimizer)).setEvaluators(iters, evaluators);
        }
        if (this.secondMinimizer instanceof HasEvaluators) {
            ((HasEvaluators)((Object)this.secondMinimizer)).setEvaluators(iters, evaluators);
        }
    }

    @Override
    public double[] minimize(DiffFunction function, double functionTolerance, double[] initial) {
        return this.minimize(function, functionTolerance, initial, -1);
    }

    @Override
    public double[] minimize(DiffFunction function, double functionTolerance, double[] initial, int maxIterations) {
        double[] x = this.firstMinimizer.minimize(function, functionTolerance, initial, this.iterationCutoff);
        return this.secondMinimizer.minimize(function, functionTolerance, x, maxIterations);
    }
}

