/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.parser.common.ParserQuery;
import edu.stanford.nlp.parser.metrics.ParserQueryEval;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceParserQuery;
import edu.stanford.nlp.trees.Tree;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class TreeRecorder
implements ParserQueryEval {
    private final Mode mode;
    private final BufferedWriter out;

    public TreeRecorder(Mode mode, String filename) {
        this.mode = mode;
        try {
            this.out = new BufferedWriter(new FileWriter(filename));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void evaluate(ParserQuery query, Tree gold, PrintWriter pw) {
        if (!(query instanceof ShiftReduceParserQuery)) {
            throw new IllegalArgumentException("This evaluator only works for the ShiftReduceParser");
        }
        ShiftReduceParserQuery srquery = (ShiftReduceParserQuery)query;
        try {
            switch (this.mode) {
                case BINARIZED: {
                    this.out.write(srquery.getBestBinarizedParse().toString());
                    break;
                }
                case DEBINARIZED: {
                    this.out.write(srquery.debinarized.toString());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown mode " + (Object)((Object)this.mode));
                }
            }
            this.out.newLine();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void display(boolean verbose, PrintWriter pw) {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static enum Mode {
        BINARIZED,
        DEBINARIZED;

    }
}

