/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.util.ArrayUtils;
import java.io.Serializable;

public class Weight
implements Serializable {
    private long[] packed;
    private static final long serialVersionUID = 1L;

    public Weight() {
        this.packed = null;
    }

    public Weight(Weight other) {
        if (other.size() == 0) {
            this.packed = null;
            return;
        }
        this.packed = ArrayUtils.copy(other.packed);
        this.condense();
    }

    public int size() {
        if (this.packed == null) {
            return 0;
        }
        return this.packed.length;
    }

    private int unpackIndex(int i) {
        long pack = this.packed[i];
        return (int)(pack >>> 32);
    }

    private float unpackScore(int i) {
        long pack = this.packed[i];
        return Float.intBitsToFloat((int)(pack & 0xFFFFFFFFFFFFFFFFL));
    }

    private static long pack(int index, float score) {
        long pack = (long)Float.floatToIntBits(score) & 0xFFFFFFFFL;
        return pack |= (long)index << 32;
    }

    public void score(float[] scores) {
        for (int i = 0; i < this.size(); ++i) {
            long pack = this.packed[i];
            int index = (int)(pack >>> 32);
            float score = Float.intBitsToFloat((int)(pack & 0xFFFFFFFFFFFFFFFFL));
            int n = index;
            scores[n] = scores[n] + score;
        }
    }

    public void addScaled(Weight other, float scale) {
        for (int i = 0; i < other.size(); ++i) {
            int index = other.unpackIndex(i);
            float score = other.unpackScore(i);
            this.updateWeight(index, score * scale);
        }
    }

    public void condense() {
        if (this.packed == null) {
            return;
        }
        int nonzero = 0;
        for (int i = 0; i < this.packed.length; ++i) {
            if (this.unpackScore(i) == 0.0f) continue;
            ++nonzero;
        }
        if (nonzero == 0) {
            this.packed = null;
            return;
        }
        if (nonzero == this.packed.length) {
            return;
        }
        long[] newPacked = new long[nonzero];
        int j = 0;
        for (int i = 0; i < this.packed.length; ++i) {
            if (this.unpackScore(i) == 0.0f) continue;
            int index = this.unpackIndex(i);
            float score = this.unpackScore(i);
            newPacked[j] = Weight.pack(index, score);
            ++j;
        }
        this.packed = newPacked;
    }

    public void updateWeight(int index, float increment) {
        if (index < 0) {
            return;
        }
        if (this.packed == null) {
            this.packed = new long[1];
            this.packed[0] = Weight.pack(index, increment);
            return;
        }
        for (int i = 0; i < this.packed.length; ++i) {
            if (this.unpackIndex(i) != index) continue;
            float score = this.unpackScore(i);
            this.packed[i] = Weight.pack(index, score + increment);
            return;
        }
        long[] newPacked = new long[this.packed.length + 1];
        for (int i = 0; i < this.packed.length; ++i) {
            newPacked[i] = this.packed[i];
        }
        newPacked[this.packed.length] = Weight.pack(index, increment);
        this.packed = newPacked;
    }
}

