/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.io.NullOutputStream;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.parser.common.NoSuchParseException;
import edu.stanford.nlp.parser.common.ParserGrammar;
import edu.stanford.nlp.parser.common.ParserQuery;
import edu.stanford.nlp.parser.common.ParserUtils;
import edu.stanford.nlp.parser.common.ParsingThreadsafeProcessor;
import edu.stanford.nlp.parser.lexparser.BoundaryRemover;
import edu.stanford.nlp.parser.lexparser.Debinarizer;
import edu.stanford.nlp.parser.lexparser.EvalbFormatWriter;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TreeAnnotatorAndBinarizer;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.parser.metrics.AbstractEval;
import edu.stanford.nlp.parser.metrics.BestOfTopKEval;
import edu.stanford.nlp.parser.metrics.Eval;
import edu.stanford.nlp.parser.metrics.Evalb;
import edu.stanford.nlp.parser.metrics.EvalbByCat;
import edu.stanford.nlp.parser.metrics.FilteredEval;
import edu.stanford.nlp.parser.metrics.LeafAncestorEval;
import edu.stanford.nlp.parser.metrics.ParserQueryEval;
import edu.stanford.nlp.parser.metrics.TaggingEval;
import edu.stanford.nlp.parser.metrics.TopMatchEval;
import edu.stanford.nlp.parser.metrics.UnlabeledAttachmentEval;
import edu.stanford.nlp.trees.LeftHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.ScoredObject;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;

public class EvaluateTreebank {
    private static Redwood.RedwoodChannels log = Redwood.channels(EvaluateTreebank.class);
    private final Options op;
    private final TreeTransformer debinarizer;
    private final TreeTransformer subcategoryStripper;
    private final TreeTransformer collinizer;
    private final TreeTransformer boundaryRemover;
    private final ParserGrammar pqFactory;
    List<Eval> evals = null;
    List<ParserQueryEval> parserQueryEvals = null;
    private final boolean summary;
    private final boolean tsv;
    private final TreeAnnotatorAndBinarizer binarizerOnly;
    AbstractEval pcfgLB = null;
    AbstractEval pcfgChildSpecific = null;
    LeafAncestorEval pcfgLA = null;
    AbstractEval pcfgCB = null;
    AbstractEval pcfgDA = null;
    AbstractEval pcfgTA = null;
    AbstractEval depDA = null;
    AbstractEval depTA = null;
    AbstractEval factLB = null;
    AbstractEval factChildSpecific = null;
    LeafAncestorEval factLA = null;
    AbstractEval factCB = null;
    AbstractEval factDA = null;
    AbstractEval factTA = null;
    AbstractEval pcfgRUO = null;
    AbstractEval pcfgCUO = null;
    AbstractEval pcfgCatE = null;
    AbstractEval.ScoreEval pcfgLL = null;
    AbstractEval.ScoreEval depLL = null;
    AbstractEval.ScoreEval factLL = null;
    AbstractEval kGoodLB = null;
    private final List<BestOfTopKEval> topKEvals = new ArrayList<BestOfTopKEval>();
    private int kbestPCFG = 0;
    private int numSkippedEvals = 0;
    private boolean saidMemMessage = false;
    protected final Function<List<? extends HasWord>, List<TaggedWord>> tagger;
    private static final double LN_TO_LOG2 = 1.0 / Math.log(2.0);

    public EvaluateTreebank(LexicalizedParser parser) {
        this(parser.getOp(), parser.lex, parser);
    }

    public EvaluateTreebank(Options op, Lexicon lex, ParserGrammar pqFactory) {
        this(op, lex, pqFactory, pqFactory.loadTagger());
    }

    public EvaluateTreebank(Options op, Lexicon lex, ParserGrammar pqFactory, Function<List<? extends HasWord>, List<TaggedWord>> tagger) {
        String filter;
        this.op = op;
        this.debinarizer = new Debinarizer(op.forceCNF);
        this.subcategoryStripper = op.tlpParams.subcategoryStripper();
        this.evals = Generics.newArrayList();
        this.evals.addAll(pqFactory.getExtraEvals());
        this.parserQueryEvals = pqFactory.getParserQueryEvals();
        this.pqFactory = pqFactory;
        this.tagger = tagger;
        this.collinizer = op.tlpParams.collinizer();
        this.boundaryRemover = new BoundaryRemover();
        boolean runningAverages = Boolean.parseBoolean(op.testOptions.evals.getProperty("runningAverages"));
        this.summary = Boolean.parseBoolean(op.testOptions.evals.getProperty("summary"));
        this.tsv = Boolean.parseBoolean(op.testOptions.evals.getProperty("tsv"));
        this.binarizerOnly = !op.trainOptions.leftToRight ? new TreeAnnotatorAndBinarizer(op.tlpParams, op.forceCNF, false, false, op) : new TreeAnnotatorAndBinarizer(op.tlpParams.headFinder(), new LeftHeadFinder(), op.tlpParams, op.forceCNF, false, false, op);
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("pcfgLB"))) {
            this.pcfgLB = new Evalb("pcfg LP/LR", runningAverages);
        }
        if (op.testOptions.evals.getProperty("pcfgChildSpecific") != null) {
            filter = op.testOptions.evals.getProperty("pcfgChildSpecific");
            this.pcfgChildSpecific = FilteredEval.childFilteredEval("pcfg children matching " + filter + " LP/LR", runningAverages, op.langpack(), filter);
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("pcfgLA"))) {
            this.pcfgLA = new LeafAncestorEval("pcfg LeafAncestor");
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("pcfgCB"))) {
            this.pcfgCB = new Evalb.CBEval("pcfg CB", runningAverages);
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("pcfgDA"))) {
            this.pcfgDA = new UnlabeledAttachmentEval("pcfg DA", runningAverages, op.langpack().headFinder());
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("pcfgTA"))) {
            this.pcfgTA = new TaggingEval("pcfg Tag", runningAverages, lex);
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("depDA"))) {
            this.depDA = new UnlabeledAttachmentEval("dep DA", runningAverages, null, op.langpack().punctuationWordRejectFilter());
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("depTA"))) {
            this.depTA = new TaggingEval("dep Tag", runningAverages, lex);
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("factLB"))) {
            this.factLB = new Evalb("factor LP/LR", runningAverages);
        }
        if (op.testOptions.evals.getProperty("factChildSpecific") != null) {
            filter = op.testOptions.evals.getProperty("factChildSpecific");
            this.factChildSpecific = FilteredEval.childFilteredEval("fact children matching " + filter + " LP/LR", runningAverages, op.langpack(), filter);
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("factLA"))) {
            this.factLA = new LeafAncestorEval("factor LeafAncestor");
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("factCB"))) {
            this.factCB = new Evalb.CBEval("fact CB", runningAverages);
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("factDA"))) {
            this.factDA = new UnlabeledAttachmentEval("factor DA", runningAverages, null);
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("factTA"))) {
            this.factTA = new TaggingEval("factor Tag", runningAverages, lex);
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("pcfgRUO"))) {
            this.pcfgRUO = new AbstractEval.RuleErrorEval("pcfg Rule under/over");
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("pcfgCUO"))) {
            this.pcfgCUO = new AbstractEval.CatErrorEval("pcfg Category under/over");
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("pcfgCatE"))) {
            this.pcfgCatE = new EvalbByCat("pcfg Category Eval", runningAverages);
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("pcfgLL"))) {
            this.pcfgLL = new AbstractEval.ScoreEval("pcfgLL", runningAverages);
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("depLL"))) {
            this.depLL = new AbstractEval.ScoreEval("depLL", runningAverages);
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("factLL"))) {
            this.factLL = new AbstractEval.ScoreEval("factLL", runningAverages);
        }
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("topMatch"))) {
            this.evals.add(new TopMatchEval("topMatch", runningAverages));
        }
        this.kGoodLB = new Evalb("kGood LP/LR", false);
        if (Boolean.parseBoolean(op.testOptions.evals.getProperty("pcfgTopK"))) {
            this.topKEvals.add(new BestOfTopKEval(new Evalb("pcfg top k comparisons", false), new Evalb("pcfg top k LP/LR", runningAverages)));
        }
        if (this.topKEvals.size() > 0) {
            this.kbestPCFG = op.testOptions.evalPCFGkBest;
        }
        if (op.testOptions.printPCFGkBest > 0) {
            this.kbestPCFG = Math.max(this.kbestPCFG, op.testOptions.printPCFGkBest);
        }
    }

    public double getLBScore() {
        if (this.factLB != null) {
            return this.factLB.getEvalbF1Percent();
        }
        if (this.pcfgLB != null) {
            return this.pcfgLB.getEvalbF1Percent();
        }
        return 0.0;
    }

    public double getTagScore() {
        if (this.factTA != null) {
            return this.factTA.getEvalbF1Percent();
        }
        if (this.pcfgTA != null) {
            return this.pcfgTA.getEvalbF1Percent();
        }
        return 0.0;
    }

    private static void nanScores(Tree tree) {
        Tree[] kids;
        tree.setScore(Double.NaN);
        for (Tree kid : kids = tree.children()) {
            EvaluateTreebank.nanScores(kid);
        }
    }

    private List<CoreLabel> getInputSentence(Tree t) {
        if (this.op.testOptions.forceTags) {
            if (this.op.testOptions.preTag) {
                List<TaggedWord> s = this.tagger.apply(t.yieldWords());
                if (this.op.testOptions.verbose) {
                    log.info("Guess tags: " + Arrays.toString(s.toArray()));
                    log.info("Gold tags: " + t.labeledYield().toString());
                }
                return SentenceUtils.toCoreLabelList(s);
            }
            if (this.op.testOptions.noFunctionalForcing) {
                ArrayList<TaggedWord> s = t.taggedYield();
                for (HasWord hasWord : s) {
                    String tag = ((HasTag)((Object)hasWord)).tag();
                    tag = tag.split("-")[0];
                    ((HasTag)((Object)hasWord)).setTag(tag);
                }
                return SentenceUtils.toCoreLabelList(s);
            }
            return SentenceUtils.toCoreLabelList(t.taggedYield());
        }
        return SentenceUtils.toCoreLabelList(t.yieldWords());
    }

    public void processResults(ParserQuery pq, Tree goldTree, PrintWriter pwErr, PrintWriter pwOut, PrintWriter pwFileOut, PrintWriter pwStats, TreePrint treePrint) {
        Tree tree;
        if (pq.saidMemMessage()) {
            this.saidMemMessage = true;
        }
        List<? extends HasWord> sentence = pq.originalSentence();
        try {
            tree = pq.getBestParse();
        }
        catch (NoSuchParseException e) {
            tree = null;
        }
        List<ScoredObject<Tree>> kbestPCFGTrees = null;
        if (tree != null && this.kbestPCFG > 0) {
            kbestPCFGTrees = pq.getKBestPCFGParses(this.kbestPCFG);
        }
        if (this.op.testOptions.verbose) {
            pwOut.println("ComboParser best");
            Tree ot = tree;
            if (ot != null && !this.op.tlpParams.treebankLanguagePack().isStartSymbol(ot.value())) {
                ot = ot.treeFactory().newTreeNode(this.op.tlpParams.treebankLanguagePack().startSymbol(), Collections.singletonList(ot));
            }
            treePrint.printTree(ot, pwOut);
        } else {
            treePrint.printTree(tree, pwOut);
        }
        if (tree != null) {
            Tree tbtr;
            List<ScoredObject<Tree>> trees;
            if (this.op.testOptions.printAllBestParses) {
                List<ScoredObject<Tree>> parses = pq.getBestPCFGParses();
                int sz = parses.size();
                if (sz > 1) {
                    pwOut.println("There were " + sz + " best PCFG parses with score " + parses.get(0).score() + '.');
                    Tree transGoldTree = this.collinizer.transformTree(goldTree);
                    int iii = 0;
                    for (ScoredObject<Tree> scoredObject : parses) {
                        Tree tb = scoredObject.object();
                        Object tbd2 = this.debinarizer.transformTree(tb);
                        tbd2 = this.subcategoryStripper.transformTree((Tree)tbd2);
                        pq.restoreOriginalWords((Tree)tbd2);
                        pwOut.println("PCFG Parse #" + ++iii + " with score " + ((Tree)tbd2).score());
                        ((Tree)tbd2).pennPrint(pwOut);
                        Tree tbtr2 = this.collinizer.transformTree((Tree)tbd2);
                        this.kGoodLB.evaluate(tbtr2, transGoldTree, pwErr);
                    }
                }
            } else if (this.op.testOptions.printPCFGkBest > 0 && this.op.testOptions.outputkBestEquivocation == null) {
                trees = kbestPCFGTrees.subList(0, this.op.testOptions.printPCFGkBest);
                Tree transGoldTree = this.collinizer.transformTree(goldTree);
                int i = 0;
                for (ScoredObject<Tree> scoredObject : trees) {
                    pwOut.println("PCFG Parse #" + ++i + " with score " + scoredObject.score());
                    Tree tree2 = scoredObject.object();
                    tree2.pennPrint(pwOut);
                    tbtr = this.collinizer.transformTree(tree2);
                    this.kGoodLB.evaluate(tbtr, transGoldTree, pwErr);
                }
            } else if (this.op.testOptions.printFactoredKGood > 0 && pq.hasFactoredParse()) {
                trees = pq.getKGoodFactoredParses(this.op.testOptions.printFactoredKGood);
                Tree transGoldTree = this.collinizer.transformTree(goldTree);
                int ii = 0;
                for (ScoredObject<Tree> scoredObject : trees) {
                    pwOut.println("Factored Parse #" + ++ii + " with score " + scoredObject.score());
                    Tree tree3 = scoredObject.object();
                    tree3.pennPrint(pwOut);
                    tbtr = this.collinizer.transformTree(tree3);
                    this.kGoodLB.evaluate(tbtr, transGoldTree, pwOut);
                }
            } else if (pwFileOut != null) {
                pwFileOut.println(tree.toString());
            }
            if (this.op.testOptions.outputkBestEquivocation != null && this.op.testOptions.printPCFGkBest > 0) {
                trees = kbestPCFGTrees.subList(0, this.op.testOptions.printPCFGkBest);
                double[] logScores = new double[trees.size()];
                int treeId = 0;
                for (ScoredObject<Tree> scoredObject : trees) {
                    logScores[treeId++] = scoredObject.score();
                }
                double entropy = 0.0;
                double d = ArrayMath.logSum(logScores);
                for (double logScore : logScores) {
                    double logPr = logScore - d;
                    entropy += Math.exp(logPr) * logPr * LN_TO_LOG2;
                }
                pwStats.printf("%f\t%d\t%d\n", entropy *= -1.0, trees.size(), sentence.size());
            }
        }
        if (tree != null) {
            Tree treeDep;
            Tree treePCFG;
            Tree transGoldTree;
            tree = this.subcategoryStripper.transformTree(tree);
            Tree treeFact = this.collinizer.transformTree(tree);
            if (this.op.testOptions.verbose) {
                pwOut.println("Correct parse");
                treePrint.printTree(goldTree, pwOut);
            }
            if ((transGoldTree = this.collinizer.transformTree(goldTree)) != null) {
                transGoldTree = this.subcategoryStripper.transformTree(transGoldTree);
            }
            if (transGoldTree == null) {
                pwErr.println("Couldn't transform gold tree for evaluation, skipping eval. Gold tree was:");
                goldTree.pennPrint(pwErr);
                ++this.numSkippedEvals;
                return;
            }
            if (treeFact == null) {
                pwErr.println("Couldn't transform hypothesis tree for evaluation, skipping eval. Tree was:");
                tree.pennPrint(pwErr);
                ++this.numSkippedEvals;
                return;
            }
            if (treeFact.yield().size() != transGoldTree.yield().size()) {
                ArrayList<Label> fYield = treeFact.yield();
                ArrayList<Label> gYield = transGoldTree.yield();
                pwErr.println("WARNING: Evaluation could not be performed due to gold/parsed yield mismatch.");
                pwErr.printf("  sizes: gold: %d (transf) %d (orig); parsed: %d (transf) %d (orig).%n", gYield.size(), goldTree.yield().size(), fYield.size(), tree.yield().size());
                pwErr.println("  gold: " + SentenceUtils.listToString(gYield, true));
                pwErr.println("  pars: " + SentenceUtils.listToString(fYield, true));
                ++this.numSkippedEvals;
                return;
            }
            if (this.topKEvals.size() > 0) {
                ArrayList<Tree> transGuesses = new ArrayList<Tree>();
                int kbest = Math.min(this.op.testOptions.evalPCFGkBest, kbestPCFGTrees.size());
                for (ScoredObject<Tree> scoredObject : kbestPCFGTrees.subList(0, kbest)) {
                    transGuesses.add(this.collinizer.transformTree(scoredObject.object()));
                }
                for (BestOfTopKEval bestOfTopKEval : this.topKEvals) {
                    bestOfTopKEval.evaluate(transGuesses, transGoldTree, pwErr);
                }
            }
            if ((treePCFG = pq.getBestPCFGParse()) != null) {
                Tree treePCFGeval = this.collinizer.transformTree(treePCFG);
                if (this.pcfgLB != null) {
                    this.pcfgLB.evaluate(treePCFGeval, transGoldTree, pwErr);
                }
                if (this.pcfgChildSpecific != null) {
                    this.pcfgChildSpecific.evaluate(treePCFGeval, transGoldTree, pwErr);
                }
                if (this.pcfgLA != null) {
                    this.pcfgLA.evaluate(treePCFGeval, transGoldTree, pwErr);
                }
                if (this.pcfgCB != null) {
                    this.pcfgCB.evaluate(treePCFGeval, transGoldTree, pwErr);
                }
                if (this.pcfgDA != null) {
                    treePCFGeval.indexLeaves(true);
                    transGoldTree.indexLeaves(true);
                    this.pcfgDA.evaluate(treePCFGeval, transGoldTree, pwErr);
                }
                if (this.pcfgTA != null) {
                    this.pcfgTA.evaluate(treePCFGeval, transGoldTree, pwErr);
                }
                if (this.pcfgLL != null && pq.getPCFGParser() != null) {
                    this.pcfgLL.recordScore(pq.getPCFGParser(), pwErr);
                }
                if (this.pcfgRUO != null) {
                    this.pcfgRUO.evaluate(treePCFGeval, transGoldTree, pwErr);
                }
                if (this.pcfgCUO != null) {
                    this.pcfgCUO.evaluate(treePCFGeval, transGoldTree, pwErr);
                }
                if (this.pcfgCatE != null) {
                    this.pcfgCatE.evaluate(treePCFGeval, transGoldTree, pwErr);
                }
            }
            if ((treeDep = pq.getBestDependencyParse(false)) != null) {
                Tree tree4 = this.binarizerOnly.transformTree(goldTree);
                Tree tree5 = goldTree.deepCopy();
                tree5.indexLeaves(true);
                tree5.percolateHeads(this.op.langpack().headFinder());
                Tree depDAEval = pq.getBestDependencyParse(true);
                depDAEval.indexLeaves(true);
                depDAEval.percolateHeadIndices();
                if (this.depDA != null) {
                    this.depDA.evaluate(depDAEval, tree5, pwErr);
                }
                if (this.depTA != null) {
                    Tree undoneTree = this.debinarizer.transformTree(treeDep);
                    undoneTree = this.subcategoryStripper.transformTree(undoneTree);
                    pq.restoreOriginalWords(undoneTree);
                    this.depTA.evaluate(undoneTree, goldTree, pwErr);
                }
                if (this.depLL != null && pq.getDependencyParser() != null) {
                    this.depLL.recordScore(pq.getDependencyParser(), pwErr);
                }
                Tree factTreeB = pq.hasFactoredParse() ? pq.getBestFactoredParse() : treeDep;
                if (this.factDA != null) {
                    this.factDA.evaluate(factTreeB, tree4, pwErr);
                }
            }
            if (this.factLB != null) {
                this.factLB.evaluate(treeFact, transGoldTree, pwErr);
            }
            if (this.factChildSpecific != null) {
                this.factChildSpecific.evaluate(treeFact, transGoldTree, pwErr);
            }
            if (this.factLA != null) {
                this.factLA.evaluate(treeFact, transGoldTree, pwErr);
            }
            if (this.factTA != null) {
                this.factTA.evaluate(tree, this.boundaryRemover.transformTree(goldTree), pwErr);
            }
            if (this.factLL != null && pq.getFactoredParser() != null) {
                this.factLL.recordScore(pq.getFactoredParser(), pwErr);
            }
            if (this.factCB != null) {
                this.factCB.evaluate(treeFact, transGoldTree, pwErr);
            }
            for (Eval eval : this.evals) {
                eval.evaluate(treeFact, transGoldTree, pwErr);
            }
            if (this.parserQueryEvals != null) {
                for (ParserQueryEval parserQueryEval : this.parserQueryEvals) {
                    parserQueryEval.evaluate(pq, transGoldTree, pwErr);
                }
            }
            if (this.op.testOptions.evalb) {
                EvaluateTreebank.nanScores(tree);
                EvalbFormatWriter.writeEVALBline(treeFact, transGoldTree);
            }
        }
        pwErr.println();
    }

    public double testOnTreebank(Treebank testTreebank) {
        ParserQuery pq;
        PrintWriter pwErr;
        PrintWriter pwOut;
        log.info("Testing on treebank");
        Timing treebankTotalTimer = new Timing();
        TreePrint treePrint = this.op.testOptions.treePrint(this.op.tlpParams);
        TreebankLangParserParams tlpParams = this.op.tlpParams;
        TreebankLanguagePack tlp = this.op.langpack();
        if (this.op.testOptions.quietEvaluation) {
            NullOutputStream quiet = new NullOutputStream();
            pwOut = tlpParams.pw(quiet);
            pwErr = tlpParams.pw(quiet);
        } else {
            pwOut = tlpParams.pw();
            pwErr = tlpParams.pw(System.err);
        }
        if (this.op.testOptions.verbose) {
            pwErr.print("Testing ");
            pwErr.println(testTreebank.textualSummary(tlp));
        }
        if (this.op.testOptions.evalb) {
            EvalbFormatWriter.initEVALBfiles(tlpParams);
        }
        PrintWriter pwFileOut = null;
        if (this.op.testOptions.writeOutputFiles) {
            String fname = this.op.testOptions.outputFilesPrefix + "." + this.op.testOptions.outputFilesExtension;
            try {
                pwFileOut = this.op.tlpParams.pw(new FileOutputStream(fname));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        PrintWriter pwStats = null;
        if (this.op.testOptions.outputkBestEquivocation != null) {
            try {
                pwStats = this.op.tlpParams.pw(new FileOutputStream(this.op.testOptions.outputkBestEquivocation));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (this.op.testOptions.testingThreads != 1) {
            MulticoreWrapper<List<? extends HasWord>, ParserQuery> wrapper = new MulticoreWrapper<List<? extends HasWord>, ParserQuery>(this.op.testOptions.testingThreads, new ParsingThreadsafeProcessor(this.pqFactory, pwErr));
            Iterator<Object> goldTrees = new LinkedList();
            for (Tree goldTree : testTreebank) {
                List<CoreLabel> sentence = this.getInputSentence(goldTree);
                ((LinkedList)((Object)goldTrees)).add(goldTree);
                pwErr.println("Parsing [len. " + sentence.size() + "]: " + SentenceUtils.listToString(sentence));
                wrapper.put(sentence);
                while (wrapper.peek()) {
                    ParserQuery pq2 = wrapper.poll();
                    goldTree = (Tree)((LinkedList)((Object)goldTrees)).poll();
                    this.processResults(pq2, goldTree, pwErr, pwOut, pwFileOut, pwStats, treePrint);
                }
            }
            wrapper.join();
            while (wrapper.peek()) {
                Tree goldTree;
                ParserQuery parserQuery = wrapper.poll();
                goldTree = (Tree)((LinkedList)((Object)goldTrees)).poll();
                this.processResults(parserQuery, goldTree, pwErr, pwOut, pwFileOut, pwStats, treePrint);
            }
        } else {
            pq = this.pqFactory.parserQuery();
            for (Tree tree : testTreebank) {
                List<CoreLabel> sentence = this.getInputSentence(tree);
                pwErr.println("Parsing [len. " + sentence.size() + "]: " + SentenceUtils.listToString(sentence));
                pq.parseAndReport(sentence, pwErr);
                this.processResults(pq, tree, pwErr, pwOut, pwFileOut, pwStats, treePrint);
            }
        }
        treebankTotalTimer.done("Testing on treebank");
        if (this.op.testOptions.quietEvaluation) {
            pwErr = tlpParams.pw(System.err);
        }
        if (this.saidMemMessage) {
            ParserUtils.printOutOfMemory(pwErr);
        }
        if (this.op.testOptions.evalb) {
            EvalbFormatWriter.closeEVALBfiles();
        }
        if (this.numSkippedEvals != 0) {
            pwErr.printf("Unable to evaluate %d parser hypotheses due to yield mismatch\n", this.numSkippedEvals);
        }
        pq = this.pqFactory.parserQuery();
        if (this.summary) {
            if (this.pcfgLB != null) {
                this.pcfgLB.display(false, pwErr);
            }
            if (this.pcfgChildSpecific != null) {
                this.pcfgChildSpecific.display(false, pwErr);
            }
            if (this.pcfgLA != null) {
                this.pcfgLA.display(false, pwErr);
            }
            if (this.pcfgCB != null) {
                this.pcfgCB.display(false, pwErr);
            }
            if (this.pcfgDA != null) {
                this.pcfgDA.display(false, pwErr);
            }
            if (this.pcfgTA != null) {
                this.pcfgTA.display(false, pwErr);
            }
            if (this.pcfgLL != null && pq.getPCFGParser() != null) {
                this.pcfgLL.display(false, pwErr);
            }
            if (this.depDA != null) {
                this.depDA.display(false, pwErr);
            }
            if (this.depTA != null) {
                this.depTA.display(false, pwErr);
            }
            if (this.depLL != null && pq.getDependencyParser() != null) {
                this.depLL.display(false, pwErr);
            }
            if (this.factLB != null) {
                this.factLB.display(false, pwErr);
            }
            if (this.factChildSpecific != null) {
                this.factChildSpecific.display(false, pwErr);
            }
            if (this.factLA != null) {
                this.factLA.display(false, pwErr);
            }
            if (this.factCB != null) {
                this.factCB.display(false, pwErr);
            }
            if (this.factDA != null) {
                this.factDA.display(false, pwErr);
            }
            if (this.factTA != null) {
                this.factTA.display(false, pwErr);
            }
            if (this.factLL != null && pq.getFactoredParser() != null) {
                this.factLL.display(false, pwErr);
            }
            if (this.pcfgCatE != null) {
                this.pcfgCatE.display(false, pwErr);
            }
            for (Eval eval : this.evals) {
                eval.display(false, pwErr);
            }
            for (BestOfTopKEval bestOfTopKEval : this.topKEvals) {
                bestOfTopKEval.display(false, pwErr);
            }
        }
        if (this.pcfgRUO != null) {
            this.pcfgRUO.display(true, pwErr);
        }
        if (this.pcfgCUO != null) {
            this.pcfgCUO.display(true, pwErr);
        }
        if (this.tsv) {
            DecimalFormat nf = new DecimalFormat("0.00");
            pwErr.println("factF1\tfactDA\tfactEx\tpcfgF1\tdepDA\tfactTA\tnum");
            if (this.factLB != null) {
                pwErr.print(nf.format(this.factLB.getEvalbF1Percent()));
            }
            pwErr.print("\t");
            if (pq.getDependencyParser() != null && this.factDA != null) {
                pwErr.print(nf.format(this.factDA.getEvalbF1Percent()));
            }
            pwErr.print("\t");
            if (this.factLB != null) {
                pwErr.print(nf.format(this.factLB.getExactPercent()));
            }
            pwErr.print("\t");
            if (this.pcfgLB != null) {
                pwErr.print(nf.format(this.pcfgLB.getEvalbF1Percent()));
            }
            pwErr.print("\t");
            if (pq.getDependencyParser() != null && this.depDA != null) {
                pwErr.print(nf.format(this.depDA.getEvalbF1Percent()));
            }
            pwErr.print("\t");
            if (pq.getPCFGParser() != null && this.factTA != null) {
                pwErr.print(nf.format(this.factTA.getEvalbF1Percent()));
            }
            pwErr.print("\t");
            if (this.factLB != null) {
                pwErr.print(this.factLB.getNum());
            }
            pwErr.println();
        }
        double f1 = 0.0;
        if (this.factLB != null) {
            f1 = this.factLB.getEvalbF1();
        }
        if (pwFileOut != null) {
            pwFileOut.close();
        }
        if (pwStats != null) {
            pwStats.close();
        }
        if (this.parserQueryEvals != null) {
            for (ParserQueryEval parserQueryEval : this.parserQueryEvals) {
                parserQueryEval.display(false, pwErr);
            }
        }
        return f1;
    }
}

