/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.trees.HasParent;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.VariableStrings;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class TregexMatcher {
    final Tree root;
    Tree tree;
    IdentityHashMap<Tree, Tree> nodesToParents;
    final Map<String, Tree> namesToNodes;
    final VariableStrings variableStrings;
    private Iterator<Tree> findIterator;
    private Tree findCurrent;
    final HeadFinder headFinder;

    TregexMatcher(Tree root, Tree tree, IdentityHashMap<Tree, Tree> nodesToParents, Map<String, Tree> namesToNodes, VariableStrings variableStrings, HeadFinder headFinder) {
        this.root = root;
        this.tree = tree;
        this.nodesToParents = nodesToParents;
        this.namesToNodes = namesToNodes;
        this.variableStrings = variableStrings;
        this.headFinder = headFinder;
    }

    public HeadFinder getHeadFinder() {
        return this.headFinder;
    }

    public void reset() {
        this.findIterator = null;
        this.findCurrent = null;
        this.namesToNodes.clear();
        this.variableStrings.reset();
    }

    void resetChildIter(Tree tree) {
        this.tree = tree;
        this.resetChildIter();
    }

    void resetChildIter() {
    }

    public abstract boolean matches();

    public boolean matchesAt(Tree node) {
        this.resetChildIter(node);
        return this.matches();
    }

    public abstract Tree getMatch();

    public boolean find() {
        if (this.findIterator == null) {
            if (this.root == null) {
                return false;
            }
            this.findIterator = this.root.iterator();
        }
        if (this.findCurrent != null && this.matches()) {
            return true;
        }
        while (this.findIterator.hasNext()) {
            this.findCurrent = this.findIterator.next();
            this.resetChildIter(this.findCurrent);
            if (!this.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean findAt(Tree node) {
        if (this.findCurrent != null && this.findCurrent != node) {
            throw new AssertionError((Object)"Error: must call reset() before changing nodes for a call to findAt");
        }
        if (this.findCurrent != null) {
            return this.matches();
        }
        this.findCurrent = node;
        this.resetChildIter(this.findCurrent);
        return this.matches();
    }

    public boolean findNextMatchingNode() {
        Tree lastMatchingNode = this.getMatch();
        while (this.find()) {
            if (this.getMatch() == lastMatchingNode) continue;
            return true;
        }
        return false;
    }

    public Tree getNode(String name) {
        return this.namesToNodes.get(name);
    }

    public Set<String> getNodeNames() {
        return this.namesToNodes.keySet();
    }

    Tree getParent(Tree node) {
        if (node instanceof HasParent) {
            return node.parent();
        }
        if (this.nodesToParents == null) {
            this.nodesToParents = new IdentityHashMap();
        }
        if (this.nodesToParents.isEmpty()) {
            this.fillNodesToParents(this.root, null);
        }
        return this.nodesToParents.get(node);
    }

    private void fillNodesToParents(Tree node, Tree parent) {
        this.nodesToParents.put(node, parent);
        for (Tree child : node.children()) {
            this.fillNodesToParents(child, node);
        }
    }

    Tree getRoot() {
        return this.root;
    }

    public String getVariableString(String var) {
        return this.variableStrings.getString(var);
    }
}

