/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Predicate;

public class ArrayStringFilter
implements Predicate<String>,
Serializable {
    private final String[] words;
    private final int length;
    private final Mode mode;
    private static final long serialVersionUID = 1L;

    public ArrayStringFilter(Mode mode, String ... words) {
        if (mode == null) {
            throw new NullPointerException("Cannot handle null mode");
        }
        this.mode = mode;
        this.words = new String[words.length];
        System.arraycopy(words, 0, this.words, 0, words.length);
        this.length = words.length;
    }

    @Override
    public boolean test(String input) {
        switch (this.mode) {
            case EXACT: {
                for (int i = 0; i < this.length; ++i) {
                    if (!this.words[i].equals(input)) continue;
                    return true;
                }
                return false;
            }
            case PREFIX: {
                if (input == null) {
                    return false;
                }
                for (int i = 0; i < this.length; ++i) {
                    if (!input.startsWith(this.words[i])) continue;
                    return true;
                }
                return false;
            }
            case CASE_INSENSITIVE: {
                for (int i = 0; i < this.length; ++i) {
                    if (!this.words[i].equalsIgnoreCase(input)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown mode " + (Object)((Object)this.mode));
    }

    public String toString() {
        return this.mode.toString() + ':' + StringUtils.join(this.words, ",");
    }

    public int hashCode() {
        int result = 1;
        for (String word : this.words) {
            result += word.hashCode();
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ArrayStringFilter)) {
            return false;
        }
        ArrayStringFilter filter = (ArrayStringFilter)other;
        if (filter.mode != this.mode || filter.length != this.length) {
            return false;
        }
        HashSet<String> myWords = new HashSet<String>(Arrays.asList(this.words));
        HashSet<String> otherWords = new HashSet<String>(Arrays.asList(filter.words));
        return myWords.equals(otherWords);
    }

    public static enum Mode {
        EXACT,
        PREFIX,
        CASE_INSENSITIVE;

    }
}

