/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.parser.shiftreduce.BinaryTransition;
import edu.stanford.nlp.parser.shiftreduce.CompoundUnaryTransition;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceOptions;
import edu.stanford.nlp.parser.shiftreduce.ShiftTransition;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import edu.stanford.nlp.parser.shiftreduce.UnaryTransition;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class ReorderingOracle {
    final ShiftReduceOptions op;
    final Set<String> rootOnlyStates;

    public ReorderingOracle(ShiftReduceOptions op, Set<String> rootOnlyStates) {
        this.op = op;
        this.rootOnlyStates = rootOnlyStates;
    }

    boolean reorder(State state, Transition chosenTransition, List<Transition> transitions) {
        if (transitions.size() == 0) {
            throw new AssertionError();
        }
        Transition goldTransition = transitions.get(0);
        if (chosenTransition.equals(goldTransition)) {
            transitions.remove(0);
            return true;
        }
        if (goldTransition instanceof UnaryTransition || goldTransition instanceof CompoundUnaryTransition) {
            transitions.remove(0);
            return this.reorder(state, chosenTransition, transitions);
        }
        if (chosenTransition instanceof UnaryTransition || chosenTransition instanceof CompoundUnaryTransition) {
            Transition previous;
            if (state.transitions.size() > 0 && ((previous = state.transitions.peek()) instanceof UnaryTransition || previous instanceof CompoundUnaryTransition)) {
                return false;
            }
            return state.stack.size() != 0;
        }
        if (chosenTransition instanceof BinaryTransition) {
            if (state.stack.size() < 2) {
                return false;
            }
            if (goldTransition instanceof ShiftTransition) {
                return this.op.trainOptions().oracleBinaryToShift && this.reorderIncorrectBinaryTransition(transitions);
            }
            if (!(goldTransition instanceof BinaryTransition)) {
                return false;
            }
            BinaryTransition chosenBinary = (BinaryTransition)chosenTransition;
            BinaryTransition goldBinary = (BinaryTransition)goldTransition;
            if (chosenBinary.isBinarized()) {
                if (goldBinary.isBinarized() && chosenBinary.label.equals(goldBinary.label)) {
                    transitions.remove(0);
                    return true;
                }
                return false;
            }
            transitions.remove(0);
            return true;
        }
        if (chosenTransition instanceof ShiftTransition && goldTransition instanceof BinaryTransition) {
            if (state.endOfQueue()) {
                return false;
            }
            BinaryTransition goldBinary = (BinaryTransition)goldTransition;
            if (!goldBinary.isBinarized()) {
                return this.op.trainOptions().oracleShiftToBinary && this.reorderIncorrectShiftTransition(transitions);
            }
        }
        return false;
    }

    boolean reorderIncorrectBinaryTransition(List<Transition> transitions) {
        Transition next;
        int shiftCount = 0;
        ListIterator<Transition> cursor = transitions.listIterator();
        do {
            if (!cursor.hasNext()) {
                return false;
            }
            next = cursor.next();
            if (next instanceof ShiftTransition) {
                ++shiftCount;
                continue;
            }
            if (!(next instanceof BinaryTransition) || --shiftCount > 0) continue;
            cursor.remove();
        } while (shiftCount > 0);
        if (!cursor.hasNext()) {
            return false;
        }
        next = cursor.next();
        while (next instanceof UnaryTransition || next instanceof CompoundUnaryTransition) {
            cursor.remove();
            if (!cursor.hasNext()) {
                return false;
            }
            next = cursor.next();
        }
        return true;
    }

    boolean reorderIncorrectShiftTransition(List<Transition> transitions) {
        Transition head;
        ArrayList<BinaryTransition> leftoverBinary = Generics.newArrayList();
        while (transitions.size() > 0 && !((head = transitions.remove(0)) instanceof ShiftTransition)) {
            if (!(head instanceof BinaryTransition)) continue;
            leftoverBinary.add((BinaryTransition)head);
        }
        if (transitions.size() == 0 || leftoverBinary.size() == 0) {
            return false;
        }
        int shiftCount = 0;
        ListIterator<Transition> cursor = transitions.listIterator();
        BinaryTransition lastBinary = null;
        while (cursor.hasNext() && shiftCount >= 0) {
            Transition next = cursor.next();
            if (next instanceof ShiftTransition) {
                ++shiftCount;
                continue;
            }
            if (!(next instanceof BinaryTransition) || --shiftCount >= 0) continue;
            lastBinary = (BinaryTransition)next;
            cursor.remove();
        }
        if (!cursor.hasNext() || lastBinary == null) {
            return false;
        }
        String label = lastBinary.label;
        if (lastBinary.isBinarized()) {
            label = label.substring(1);
        }
        if (lastBinary.side == BinaryTransition.Side.RIGHT) {
            for (int i = 0; i < leftoverBinary.size(); ++i) {
                cursor.add(new BinaryTransition("@" + label, BinaryTransition.Side.RIGHT, this.rootOnlyStates.contains(label)));
            }
            cursor.add(new BinaryTransition(lastBinary.label, BinaryTransition.Side.RIGHT, this.rootOnlyStates.contains(label)));
        } else {
            cursor.add(new BinaryTransition("@" + label, BinaryTransition.Side.LEFT, this.rootOnlyStates.contains(label)));
            for (int i = 0; i < leftoverBinary.size() - 1; ++i) {
                cursor.add(new BinaryTransition("@" + label, ((BinaryTransition)leftoverBinary.get((int)i)).side, this.rootOnlyStates.contains(label)));
            }
            cursor.add(new BinaryTransition(lastBinary.label, ((BinaryTransition)leftoverBinary.get((int)(leftoverBinary.size() - 1))).side, this.rootOnlyStates.contains(lastBinary.label)));
        }
        return true;
    }
}

