/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.File;
import java.io.IOException;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.InfoCallback;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNTests;
import org.tigris.subversion.javahl.SubversionException;

public class SVNAdminTests
extends SVNTests {
    public static final String testName = "admin_test";

    public SVNAdminTests() {
        this.init();
    }

    public SVNAdminTests(String string) {
        super(string);
        this.init();
    }

    private void init() {
        if (!testName.equals(this.testBaseName)) {
            testCounter = 0;
            this.testBaseName = testName;
        }
    }

    public void testCreate() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(this, false);
        SVNAdminTests.assertTrue((String)"repository exists", (boolean)oneTest.getRepository().exists());
    }

    public void testSetRevProp() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(this, false);
        this.admin.setRevProp(oneTest.getRepositoryPath(), Revision.getInstance(0L), "svn:log", "Initial repository creation", false, false);
        PropertyData[] propertyDataArray = this.client.revProperties(this.makeReposUrl(oneTest.getRepository()), Revision.getInstance(0L));
        SVNAdminTests.assertNotNull((Object)"expect non null rev props");
        String string = null;
        for (int i = 0; i < propertyDataArray.length; ++i) {
            if (!"svn:log".equals(propertyDataArray[i].getName())) continue;
            string = propertyDataArray[i].getValue();
            break;
        }
        SVNAdminTests.assertEquals((String)"expect rev prop change to take effect", (String)"Initial repository creation", string);
    }

    public void testLoadRepo() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest((SVNTests)this, false, false);
        String string = this.makeReposUrl(oneTest.getRepository());
        final Info2[] info2Array = new Info2[1];
        InfoCallback infoCallback = new InfoCallback(){

            @Override
            public void singleInfo(Info2 info2) {
                info2Array[0] = info2;
            }
        };
        this.client.info2(string, Revision.HEAD, Revision.HEAD, 2, null, infoCallback);
        SVNAdminTests.assertNotNull((String)"expect info callback", (Object)info2Array[0]);
        SVNAdminTests.assertEquals((String)"expect zero revisions in new repository", (long)0L, (long)info2Array[0].getLastChangedRev());
        String string2 = System.getProperty("test.srcdir", "subversion/bindings/javahl");
        File file = new File(string2, "tests/data/issue2979.dump");
        SVNTests.FileInputer fileInputer = new SVNTests.FileInputer(this, file);
        SVNTests.IgnoreOutputer ignoreOutputer = new SVNTests.IgnoreOutputer(this);
        this.admin.load(oneTest.getRepositoryPath(), fileInputer, ignoreOutputer, true, true, null);
        info2Array[0] = null;
        this.client.info2(string, Revision.HEAD, Revision.HEAD, 2, null, infoCallback);
        SVNAdminTests.assertEquals((String)"expect two revisions after load()", (long)2L, (long)info2Array[0].getLastChangedRev());
        SVNAdminTests.assertEquals((String)"expect 'svn4ant' as author of r2", (String)"svn4ant", (String)info2Array[0].getLastChangedAuthor());
    }
}

