/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.CommitInfo;
import org.apache.subversion.javahl.CommitItem;
import org.apache.subversion.javahl.ISVNConfig;
import org.apache.subversion.javahl.ISVNEditor;
import org.apache.subversion.javahl.ISVNRemote;
import org.apache.subversion.javahl.ISVNReporter;
import org.apache.subversion.javahl.SVNTests;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.CommitCallback;
import org.apache.subversion.javahl.callback.CommitMessageCallback;
import org.apache.subversion.javahl.callback.ConfigEvent;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.callback.RemoteStatus;
import org.apache.subversion.javahl.remote.RemoteFactory;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.Checksum;
import org.apache.subversion.javahl.types.CopySource;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.Mergeinfo;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;

public class SVNRemoteTests
extends SVNTests {
    public static final String testName = "remote_test";
    protected SVNTests.OneTest thisTest;

    public SVNRemoteTests() {
        this.init();
    }

    public SVNRemoteTests(String string) {
        super(string);
        this.init();
    }

    private void init() {
        if (!testName.equals(this.testBaseName)) {
            testCounter = 0;
            this.testBaseName = testName;
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.thisTest = new SVNTests.OneTest(this);
    }

    public static ISVNRemote getSession(String string, String string2) {
        try {
            RemoteFactory remoteFactory = new RemoteFactory();
            remoteFactory.setConfigDirectory(string2);
            remoteFactory.setUsername("jrandom");
            if (SVNTests.DefaultAuthn.useDeprecated()) {
                remoteFactory.setPrompt(SVNTests.DefaultAuthn.getDeprecated());
            } else {
                remoteFactory.setPrompt(SVNTests.DefaultAuthn.getDefault());
            }
            ISVNRemote iSVNRemote = remoteFactory.openRemoteSession(string);
            SVNRemoteTests.assertNotNull((String)"Null session was returned by factory", (Object)iSVNRemote);
            return iSVNRemote;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private ISVNRemote getSession() {
        return SVNRemoteTests.getSession(this.getTestRepoUrl(), this.conf.getAbsolutePath());
    }

    public void testCreate() throws SubversionException, IOException {
        SVNRemoteTests.assertTrue((String)"repository exists", (boolean)this.thisTest.getRepository().exists());
    }

    public void testGetSession_ConfigConstructor() throws Exception {
        ISVNRemote iSVNRemote;
        try {
            iSVNRemote = SVNTests.DefaultAuthn.useDeprecated() ? new RemoteFactory(this.conf.getAbsolutePath(), "jrandom", null, SVNTests.DefaultAuthn.getDeprecated(), null, null, null).openRemoteSession(this.getTestRepoUrl()) : new RemoteFactory(this.conf.getAbsolutePath(), "jrandom", null, SVNTests.DefaultAuthn.getDefault(), null, null, null).openRemoteSession(this.getTestRepoUrl());
        }
        catch (ClientException clientException) {
            throw new RuntimeException(clientException);
        }
        SVNRemoteTests.assertNotNull((String)"Null session was returned by factory", (Object)iSVNRemote);
        SVNRemoteTests.assertEquals((String)this.getTestRepoUrl(), (String)iSVNRemote.getSessionUrl());
    }

    public void testDispose() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        iSVNRemote.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSessionGC() throws Exception {
        int n = 0;
        try {
            try {
                String string = this.getTestRepoUrl().substring(0, 1 + this.getTestRepoUrl().lastIndexOf("/"));
                if (SVNTests.DefaultAuthn.useDeprecated()) {
                    new RemoteFactory(this.conf.getAbsolutePath(), "jrandom", null, SVNTests.DefaultAuthn.getDeprecated(), null, null, null).openRemoteSession(string + "repositorydoesnotexisthere");
                }
                new RemoteFactory(this.conf.getAbsolutePath(), "jrandom", null, SVNTests.DefaultAuthn.getDefault(), null, null, null).openRemoteSession(string + "repositorydoesnotexisthere");
            }
            finally {
                for (int i = 0; i < 100; ++i) {
                    Runtime.getRuntime().gc();
                    byte[] byArray = new byte[0x100000];
                    Arrays.fill(byArray, (byte)i);
                    ISVNRemote iSVNRemote = this.getSession();
                    iSVNRemote.getLatestRevision();
                    iSVNRemote.dispose();
                }
            }
        }
        catch (ClientException clientException) {
            List<ClientException.ErrorMessage> list = clientException.getAllMessages();
            n = list.get(list.size() - 1).getCode();
        }
        SVNRemoteTests.assertTrue((n == 180001 || n == 210005 || n == 2 ? 1 : 0) != 0);
    }

    public void testDatedRev() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        long l = iSVNRemote.getRevisionByDate(new Date());
        SVNRemoteTests.assertEquals((long)l, (long)1L);
    }

    public void testGetLocks() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        HashSet<String> hashSet = new HashSet<String>(1);
        String string = this.thisTest.getWCPath() + "/iota";
        hashSet.add(string);
        this.client.lock(hashSet, "foo", false);
        Map<String, Lock> map = iSVNRemote.getLocks("iota", Depth.infinity);
        SVNRemoteTests.assertEquals((int)map.size(), (int)1);
        Lock lock = map.get("/iota");
        SVNRemoteTests.assertNotNull((Object)lock);
        SVNRemoteTests.assertEquals((String)lock.getOwner(), (String)"jrandom");
    }

    public void testCheckPath() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        NodeKind nodeKind = iSVNRemote.checkPath("iota", 1L);
        SVNRemoteTests.assertEquals((Object)((Object)NodeKind.file), (Object)((Object)nodeKind));
        nodeKind = iSVNRemote.checkPath("iota", 0L);
        SVNRemoteTests.assertEquals((Object)((Object)NodeKind.none), (Object)((Object)nodeKind));
        nodeKind = iSVNRemote.checkPath("A", 1L);
        SVNRemoteTests.assertEquals((Object)((Object)NodeKind.dir), (Object)((Object)nodeKind));
    }

    public void testStat() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        DirEntry dirEntry = iSVNRemote.stat("iota", 1L);
        SVNRemoteTests.assertEquals((Object)((Object)NodeKind.file), (Object)((Object)dirEntry.getNodeKind()));
        dirEntry = iSVNRemote.stat("iota", 0L);
        SVNRemoteTests.assertNull((Object)dirEntry);
        dirEntry = iSVNRemote.stat("A", 1L);
        SVNRemoteTests.assertEquals((Object)((Object)NodeKind.dir), (Object)((Object)dirEntry.getNodeKind()));
    }

    private String getTestRepoUrl() {
        return this.thisTest.getUrl().toASCIIString();
    }

    public void testGetLatestRevision() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        long l = iSVNRemote.getLatestRevision();
        SVNRemoteTests.assertEquals((long)l, (long)1L);
    }

    public void testGetUUID() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        SVNRemoteTests.assertNotNull((Object)iSVNRemote.getReposUUID());
    }

    public void testGetUrl() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        SVNRemoteTests.assertEquals((String)this.getTestRepoUrl(), (String)iSVNRemote.getSessionUrl());
    }

    public void testGetRootUrl() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        iSVNRemote.reparent(iSVNRemote.getSessionUrl() + "/A/B/E");
        SVNRemoteTests.assertEquals((String)this.getTestRepoUrl(), (String)iSVNRemote.getReposRootUrl());
    }

    public void testGetUrl_viaSVNClient() throws Exception {
        ISVNRemote iSVNRemote = this.client.openRemoteSession(this.getTestRepoUrl());
        SVNRemoteTests.assertEquals((String)this.getTestRepoUrl(), (String)iSVNRemote.getSessionUrl());
    }

    public void testGetUrl_viaSVNClientWorkingCopy() throws Exception {
        ISVNRemote iSVNRemote = this.client.openRemoteSession(this.thisTest.getWCPath());
        SVNRemoteTests.assertEquals((String)this.getTestRepoUrl(), (String)iSVNRemote.getSessionUrl());
    }

    public void testReparent() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        String string = iSVNRemote.getSessionUrl() + "/A/B/E";
        iSVNRemote.reparent(string);
        SVNRemoteTests.assertEquals((String)string, (String)iSVNRemote.getSessionUrl());
    }

    public void testGetRelativePath() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        String string = iSVNRemote.getSessionUrl() + "/A/B/E";
        iSVNRemote.reparent(string);
        String string2 = iSVNRemote.getSessionRelativePath(string + "/alpha");
        SVNRemoteTests.assertEquals((String)"alpha", (String)string2);
        string2 = iSVNRemote.getReposRelativePath(string + "/beta");
        SVNRemoteTests.assertEquals((String)"A/B/E/beta", (String)string2);
    }

    public void testGetCommitEditor() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        iSVNRemote.getCommitEditor(null, null, null, false);
    }

    public void testDisposeCommitEditor() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        iSVNRemote.getCommitEditor(null, null, null, false);
        iSVNRemote.dispose();
    }

    public void testHasCapability() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        assert (iSVNRemote.hasCapability(ISVNRemote.Capability.depth));
    }

    public void testChangeRevpropNoAtomic() throws Exception {
        Charset charset = Charset.forName("UTF-8");
        ISVNRemote iSVNRemote = this.getSession();
        boolean bl = iSVNRemote.hasCapability(ISVNRemote.Capability.atomic_revprops);
        if (bl) {
            return;
        }
        boolean bl2 = false;
        try {
            byte[] byArray = "bumble".getBytes(charset);
            byte[] byArray2 = "bee".getBytes(charset);
            iSVNRemote.changeRevisionProperty(1L, "svn:author", byArray, byArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl2 = true;
        }
        assert (bl2);
    }

    public void testChangeRevpropAtomic() throws Exception {
        Charset charset = Charset.forName("UTF-8");
        ISVNRemote iSVNRemote = this.getSession();
        boolean bl = iSVNRemote.hasCapability(ISVNRemote.Capability.atomic_revprops);
        if (!bl) {
            return;
        }
        byte[] byArray = this.client.revProperty(this.getTestRepoUrl(), "svn:author", Revision.getInstance(1L));
        byte[] byArray2 = "rayjandom".getBytes(charset);
        try {
            iSVNRemote.changeRevisionProperty(1L, "svn:author", byArray, byArray2);
        }
        catch (ClientException clientException) {
            ClientException.ErrorMessage errorMessage = null;
            for (ClientException.ErrorMessage errorMessage2 : clientException.getAllMessages()) {
                if (errorMessage2.isGeneric()) continue;
                errorMessage = errorMessage2;
                break;
            }
            if (errorMessage == null) {
                SVNRemoteTests.fail((String)"Failed with no error message");
            }
            if (errorMessage.getCode() != 175002 && errorMessage.getCode() != 165006) {
                SVNRemoteTests.fail((String)errorMessage.getMessage());
            }
            return;
        }
        byte[] byArray3 = this.client.revProperty(this.getTestRepoUrl(), "svn:author", Revision.getInstance(1L));
        SVNRemoteTests.assertTrue((boolean)Arrays.equals(byArray3, byArray2));
    }

    public void testGetRevpropList() throws Exception {
        Charset charset = Charset.forName("UTF-8");
        ISVNRemote iSVNRemote = this.getSession();
        Map<String, byte[]> map = iSVNRemote.getRevisionProperties(1L);
        SVNRemoteTests.assertTrue((boolean)Arrays.equals(map.get("svn:author"), "jrandom".getBytes(charset)));
    }

    public void testGetRevprop() throws Exception {
        Charset charset = Charset.forName("UTF-8");
        ISVNRemote iSVNRemote = this.getSession();
        byte[] byArray = iSVNRemote.getRevisionProperty(1L, "svn:author");
        SVNRemoteTests.assertTrue((boolean)Arrays.equals(byArray, "jrandom".getBytes(charset)));
    }

    public void testGetFile() throws Exception {
        Charset charset = Charset.forName("UTF-8");
        ISVNRemote iSVNRemote = this.getSession();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        hashMap.put("fakename", "fakecontents".getBytes(charset));
        long l = iSVNRemote.getFile(-1L, "A/B/lambda", byteArrayOutputStream, hashMap);
        SVNRemoteTests.assertEquals((long)l, (long)1L);
        SVNRemoteTests.assertEquals((String)byteArrayOutputStream.toString("UTF-8"), (String)"This is the file 'lambda'.");
        for (Map.Entry<String, byte[]> entry : hashMap.entrySet()) {
            String string = entry.getKey();
            SVNRemoteTests.assertTrue((string.startsWith("svn:entry:") || string.startsWith("svn:wc:") ? 1 : 0) != 0);
        }
    }

    public void testGetDirectory() throws Exception {
        Charset charset = Charset.forName("UTF-8");
        ISVNRemote iSVNRemote = this.getSession();
        HashMap<String, DirEntry> hashMap = new HashMap<String, DirEntry>();
        hashMap.put("E", null);
        hashMap.put("F", null);
        hashMap.put("lambda", null);
        HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
        hashMap2.put("fakename", "fakecontents".getBytes(charset));
        long l = iSVNRemote.getDirectory(-1L, "A/B", -1, hashMap, hashMap2);
        SVNRemoteTests.assertEquals((long)l, (long)1L);
        SVNRemoteTests.assertEquals((String)hashMap.get("E").getPath(), (String)"E");
        SVNRemoteTests.assertEquals((String)hashMap.get("F").getPath(), (String)"F");
        SVNRemoteTests.assertEquals((String)hashMap.get("lambda").getPath(), (String)"lambda");
        for (Map.Entry<String, byte[]> entry : hashMap2.entrySet()) {
            String string = entry.getKey();
            SVNRemoteTests.assertTrue((string.startsWith("svn:entry:") || string.startsWith("svn:wc:") ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEditorCopy(EditorCallbacks editorCallbacks) throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        CommitContext commitContext = editorCallbacks != null ? new CommitContext(iSVNRemote, "Copy A/B/lambda -> A/B/omega", editorCallbacks.getBase, editorCallbacks.getProps, editorCallbacks.getKind) : new CommitContext(iSVNRemote, "Copy A/B/lambda -> A/B/omega");
        try {
            commitContext.editor.copy("A/B/lambda", 1L, "A/B/omega", -1L);
            commitContext.editor.complete();
        }
        finally {
            commitContext.editor.dispose();
        }
        SVNRemoteTests.assertEquals((long)2L, (long)commitContext.getRevision());
        SVNRemoteTests.assertEquals((long)2L, (long)iSVNRemote.getLatestRevision());
        SVNRemoteTests.assertEquals((Object)((Object)NodeKind.file), (Object)((Object)iSVNRemote.checkPath("A/B/lambda", -1L)));
        SVNRemoteTests.assertEquals((Object)((Object)NodeKind.file), (Object)((Object)iSVNRemote.checkPath("A/B/omega", -1L)));
    }

    public void testEditorCopy() throws Exception {
        this.testEditorCopy(null);
    }

    public void testEditorCopy_WithCallbacks() throws Exception {
        this.testEditorCopy(new EditorCallbacks(this.thisTest.getWCPath(), 1L, new HashMap<String, byte[]>(), NodeKind.file));
    }

    public void testEditorMove() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        CommitContext commitContext = new CommitContext(iSVNRemote, "Move A/B/lambda -> A/B/omega");
        try {
            commitContext.editor.move("A/B/lambda", 1L, "A/B/omega", -1L);
            commitContext.editor.complete();
        }
        finally {
            commitContext.editor.dispose();
        }
        SVNRemoteTests.assertEquals((long)2L, (long)commitContext.getRevision());
        SVNRemoteTests.assertEquals((long)2L, (long)iSVNRemote.getLatestRevision());
        SVNRemoteTests.assertEquals((Object)((Object)NodeKind.none), (Object)((Object)iSVNRemote.checkPath("A/B/lambda", -1L)));
        SVNRemoteTests.assertEquals((Object)((Object)NodeKind.file), (Object)((Object)iSVNRemote.checkPath("A/B/omega", -1L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditorDelete() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        CommitContext commitContext = new CommitContext(iSVNRemote, "Delete all greek files");
        String[] stringArray = new String[]{"iota", "A/mu", "A/B/lambda", "A/B/E/alpha", "A/B/E/beta", "A/D/gamma", "A/D/G/pi", "A/D/G/rho", "A/D/G/tau", "A/D/H/chi", "A/D/H/omega", "A/D/H/psi"};
        try {
            for (String string : stringArray) {
                commitContext.editor.delete(string, 1L);
            }
            commitContext.editor.complete();
        }
        finally {
            commitContext.editor.dispose();
        }
        SVNRemoteTests.assertEquals((long)2L, (long)commitContext.getRevision());
        SVNRemoteTests.assertEquals((long)2L, (long)iSVNRemote.getLatestRevision());
        for (String string : stringArray) {
            SVNRemoteTests.assertEquals((Object)((Object)NodeKind.none), (Object)((Object)iSVNRemote.checkPath(string, -1L)));
        }
    }

    public void testEditorMkdir() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        CommitContext commitContext = new CommitContext(iSVNRemote, "Make hebrew dir");
        try {
            commitContext.editor.addDirectory("ALEPH", new ArrayList<String>(), new HashMap<String, byte[]>(), -1L);
            commitContext.editor.complete();
        }
        finally {
            commitContext.editor.dispose();
        }
        SVNRemoteTests.assertEquals((long)2L, (long)commitContext.getRevision());
        SVNRemoteTests.assertEquals((long)2L, (long)iSVNRemote.getLatestRevision());
        SVNRemoteTests.assertEquals((Object)((Object)NodeKind.dir), (Object)((Object)iSVNRemote.checkPath("ALEPH", -1L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEditorSetDirProps(EditorCallbacks editorCallbacks) throws Exception {
        Charset charset = Charset.forName("UTF-8");
        ISVNRemote iSVNRemote = this.getSession();
        byte[] byArray = "*.pyc\n.gitignore\n".getBytes(charset);
        byte[] byArray2 = new byte[]{0, 13, -1, 8, 127, -128, -127};
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        hashMap.put("svn:ignore", byArray);
        hashMap.put("binaryprop", byArray2);
        CommitContext commitContext = editorCallbacks != null ? new CommitContext(iSVNRemote, "Add svn:ignore and binaryprop", editorCallbacks.getBase, editorCallbacks.getProps, editorCallbacks.getKind) : new CommitContext(iSVNRemote, "Add svn:ignore and binaryprop");
        try {
            commitContext.editor.alterDirectory("", 1L, null, hashMap);
            commitContext.editor.complete();
        }
        finally {
            commitContext.editor.dispose();
        }
        SVNRemoteTests.assertEquals((long)2L, (long)commitContext.getRevision());
        SVNRemoteTests.assertEquals((long)2L, (long)iSVNRemote.getLatestRevision());
        SVNRemoteTests.assertTrue((boolean)Arrays.equals(byArray, this.client.propertyGet(iSVNRemote.getSessionUrl(), "svn:ignore", Revision.HEAD, Revision.HEAD)));
        SVNRemoteTests.assertTrue((boolean)Arrays.equals(byArray2, this.client.propertyGet(iSVNRemote.getSessionUrl(), "binaryprop", Revision.HEAD, Revision.HEAD)));
    }

    public void testEditorSetDirProps() throws Exception {
        this.testEditorSetDirProps(null);
    }

    public void testEditorSetDirProps_WithCallbacks() throws Exception {
        this.testEditorSetDirProps(new EditorCallbacks(this.thisTest.getWCPath(), 1L, new HashMap<String, byte[]>(), NodeKind.dir));
    }

    private static byte[] SHA1(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        return messageDigest.digest(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditorAddFile() throws Exception {
        Charset charset = Charset.forName("UTF-8");
        ISVNRemote iSVNRemote = this.getSession();
        byte[] byArray = "native".getBytes(charset);
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        hashMap.put("svn:eol-style", byArray);
        byte[] byArray2 = "This is file 'xi'.".getBytes(charset);
        Checksum checksum = new Checksum(SVNRemoteTests.SHA1(byArray2), Checksum.Kind.SHA1);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        CommitContext commitContext = new CommitContext(iSVNRemote, "Add A/xi");
        try {
            commitContext.editor.addFile("A/xi", checksum, byteArrayInputStream, hashMap, -1L);
            commitContext.editor.complete();
        }
        finally {
            commitContext.editor.dispose();
        }
        SVNRemoteTests.assertEquals((long)2L, (long)commitContext.getRevision());
        SVNRemoteTests.assertEquals((long)2L, (long)iSVNRemote.getLatestRevision());
        SVNRemoteTests.assertEquals((Object)((Object)NodeKind.file), (Object)((Object)iSVNRemote.checkPath("A/xi", -1L)));
        byte[] byArray3 = this.client.propertyGet(iSVNRemote.getSessionUrl() + "/A/xi", "svn:eol-style", Revision.HEAD, Revision.HEAD);
        SVNRemoteTests.assertTrue((boolean)Arrays.equals(byArray, byArray3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditorDeleteFileProps() throws Exception {
        Charset charset = Charset.forName("UTF-8");
        this.client.propertySetRemote(this.thisTest.getUrl() + "/iota", 1L, "name", "value".getBytes(charset), new CommitMessageCallback(){

            @Override
            public String getLogMessage(Set<CommitItem> set) {
                return "Set property 'name' to 'value'";
            }
        }, false, null, null);
        ISVNRemote iSVNRemote = this.getSession();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        SVNRemoteTests.assertEquals((long)2L, (long)iSVNRemote.getFile(-1L, "iota", null, hashMap));
        int n = 0;
        for (Map.Entry<String, byte[]> entry : hashMap.entrySet()) {
            String object = entry.getKey();
            if (object.startsWith("svn:entry:") || object.startsWith("svn:wc:")) continue;
            ++n;
        }
        SVNRemoteTests.assertEquals((int)1, (int)n);
        CommitContext commitContext = new CommitContext(iSVNRemote, "Remove all props");
        try {
            hashMap.clear();
            commitContext.editor.alterFile("iota", 2L, null, null, hashMap);
            commitContext.editor.complete();
        }
        finally {
            commitContext.editor.dispose();
        }
        SVNRemoteTests.assertEquals((long)3L, (long)iSVNRemote.getFile(-1L, "iota", null, hashMap));
        n = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            if (string.startsWith("svn:entry:") || string.startsWith("svn:wc:")) continue;
            ++n;
        }
        SVNRemoteTests.assertEquals((int)0, (int)n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEditorSetFileContents(EditorCallbacks editorCallbacks) throws Exception {
        Charset charset = Charset.forName("UTF-8");
        ISVNRemote iSVNRemote = this.getSession();
        byte[] byArray = "This is modified file 'alpha'.".getBytes(charset);
        Checksum checksum = new Checksum(SVNRemoteTests.SHA1(byArray), Checksum.Kind.SHA1);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CommitContext commitContext = editorCallbacks != null ? new CommitContext(iSVNRemote, "Change contents of A/B/E/alpha", editorCallbacks.getBase, editorCallbacks.getProps, editorCallbacks.getKind) : new CommitContext(iSVNRemote, "Change contents of A/B/E/alpha");
        try {
            commitContext.editor.alterFile("A/B/E/alpha", 1L, checksum, byteArrayInputStream, null);
            commitContext.editor.complete();
        }
        finally {
            commitContext.editor.dispose();
        }
        SVNRemoteTests.assertEquals((long)2L, (long)commitContext.getRevision());
        SVNRemoteTests.assertEquals((long)2L, (long)iSVNRemote.getLatestRevision());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.client.streamFileContent(iSVNRemote.getSessionUrl() + "/A/B/E/alpha", Revision.HEAD, Revision.HEAD, byteArrayOutputStream);
        SVNRemoteTests.assertTrue((boolean)Arrays.equals(byArray, byteArrayOutputStream.toByteArray()));
    }

    public void testEditorSetFileContents() throws Exception {
        this.testEditorSetFileContents(null);
    }

    public void testEditorSetFileContents_WithCallbacks() throws Exception {
        this.testEditorSetFileContents(new EditorCallbacks(this.thisTest.getWCPath(), 1L, new HashMap<String, byte[]>(), NodeKind.file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditorNotImplemented() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        CommitContext commitContext = new CommitContext(iSVNRemote, "not implemented");
        try {
            String string;
            try {
                string = "";
                commitContext.editor.addSymlink("", "", hashMap, 1L);
            }
            catch (RuntimeException runtimeException) {
                string = runtimeException.getMessage();
            }
            SVNRemoteTests.assertEquals((String)"Not implemented: CommitEditor.addSymlink", (String)string);
            try {
                string = "";
                commitContext.editor.alterSymlink("", 1L, "", null);
            }
            catch (RuntimeException runtimeException) {
                string = runtimeException.getMessage();
            }
            SVNRemoteTests.assertEquals((String)"Not implemented: CommitEditor.alterSymlink", (String)string);
        }
        finally {
            commitContext.editor.dispose();
        }
    }

    public void testGetLog() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        LogReceiver logReceiver = new LogReceiver();
        iSVNRemote.getLog(null, -1L, -1L, 0, false, false, false, null, logReceiver);
        SVNRemoteTests.assertEquals((int)1, (int)logReceiver.logs.size());
        SVNRemoteTests.assertTrue((logReceiver.logs.get((int)0).revprops.size() > 0 ? 1 : 0) != 0);
        logReceiver.logs.clear();
        iSVNRemote.reparent(this.getTestRepoUrl() + "/A");
        iSVNRemote.getLog(null, -1L, 0L, 0, false, false, false, null, logReceiver);
        SVNRemoteTests.assertEquals((int)2, (int)logReceiver.logs.size());
        SVNRemoteTests.assertTrue((logReceiver.logs.get((int)0).revprops.size() > 0 ? 1 : 0) != 0);
    }

    public void testGetLogMissing() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        LogReceiver logReceiver = new LogReceiver();
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("X");
        boolean bl = false;
        try {
            iSVNRemote.getLog(arrayList, -1L, -1L, 0, false, false, false, null, logReceiver);
        }
        catch (ClientException clientException) {
            SVNRemoteTests.assertEquals((String)"Filesystem has no item", (String)clientException.getAllMessages().get(0).getMessage());
            bl = true;
        }
        SVNRemoteTests.assertEquals((int)0, (int)logReceiver.logs.size());
        SVNRemoteTests.assertTrue((boolean)bl);
    }

    public void testConfigHandler() throws Exception {
        ISVNRemote iSVNRemote;
        ConfigEvent configEvent = new ConfigEvent(){

            @Override
            public void onLoad(ISVNConfig iSVNConfig) {
                this.onecat(iSVNConfig.config());
                this.onecat(iSVNConfig.servers());
            }

            private void onecat(ISVNConfig.Category category) {
                for (String string : category.sections()) {
                    ISVNConfig.Enumerator enumerator = new ISVNConfig.Enumerator(){

                        @Override
                        public void option(String string, String string2) {
                        }
                    };
                    category.enumerate(string, enumerator);
                }
            }
        };
        try {
            iSVNRemote = SVNTests.DefaultAuthn.useDeprecated() ? new RemoteFactory(this.conf.getAbsolutePath(), "jrandom", null, SVNTests.DefaultAuthn.getDeprecated(), null, configEvent, null).openRemoteSession(this.getTestRepoUrl()) : new RemoteFactory(this.conf.getAbsolutePath(), "jrandom", null, SVNTests.DefaultAuthn.getDefault(), null, configEvent, null).openRemoteSession(this.getTestRepoUrl());
        }
        catch (ClientException clientException) {
            throw new RuntimeException(clientException);
        }
        iSVNRemote.getLatestRevision();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleStatus() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        RemoteStatusReceiver remoteStatusReceiver = new RemoteStatusReceiver();
        ISVNReporter iSVNReporter = iSVNRemote.status(null, -1L, Depth.infinity, remoteStatusReceiver);
        try {
            iSVNReporter.setPath("", 0L, Depth.infinity, true, null);
            SVNRemoteTests.assertEquals((long)1L, (long)iSVNReporter.finishReport());
        }
        finally {
            iSVNReporter.dispose();
        }
        SVNRemoteTests.assertEquals((int)21, (int)remoteStatusReceiver.status.size());
        iSVNRemote.checkPath("", -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTextchangeStatus() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        CommitMessageCallback commitMessageCallback = new CommitMessageCallback(){

            @Override
            public String getLogMessage(Set<CommitItem> set) {
                return "Content change on A/B/E/alpha";
            }
        };
        File file = new File(this.thisTest.getWorkingCopy(), "A/B/E/alpha");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write("changed alpha text".getBytes());
        fileOutputStream.close();
        this.client.commit(this.thisTest.getWCPathSet(), Depth.infinity, false, false, null, null, commitMessageCallback, null);
        RemoteStatusReceiver remoteStatusReceiver = new RemoteStatusReceiver();
        ISVNReporter iSVNReporter = iSVNRemote.status(null, -1L, Depth.infinity, remoteStatusReceiver);
        try {
            iSVNReporter.setPath("", 1L, Depth.infinity, false, null);
            SVNRemoteTests.assertEquals((long)2L, (long)iSVNReporter.finishReport());
        }
        finally {
            iSVNReporter.dispose();
        }
        SVNRemoteTests.assertEquals((int)5, (int)remoteStatusReceiver.status.size());
        Collections.sort(remoteStatusReceiver.status);
        RemoteStatusReceiver.StatInfo statInfo = remoteStatusReceiver.status.get(4);
        SVNRemoteTests.assertEquals((String)"A/B/E/alpha", (String)statInfo.relpath);
        SVNRemoteTests.assertEquals((char)'F', (char)statInfo.kind);
        SVNRemoteTests.assertEquals((String)"Text Changed", (boolean)true, (boolean)statInfo.textChanged);
        SVNRemoteTests.assertEquals((String)"Props Changed", (boolean)false, (boolean)statInfo.propsChanged);
        SVNRemoteTests.assertEquals((String)"Node Deleted", (boolean)false, (boolean)statInfo.deleted);
        SVNRemoteTests.assertEquals((long)2L, (long)statInfo.info.getCommittedRevision());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPropchangeStatus() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        CommitMessageCallback commitMessageCallback = new CommitMessageCallback(){

            @Override
            public String getLogMessage(Set<CommitItem> set) {
                return "Property change on A/D/gamma";
            }
        };
        this.client.propertySetRemote(this.getTestRepoUrl() + "/A/D/gamma", 1L, "foo", "bar".getBytes(), commitMessageCallback, false, null, null);
        RemoteStatusReceiver remoteStatusReceiver = new RemoteStatusReceiver();
        ISVNReporter iSVNReporter = iSVNRemote.status(null, -1L, Depth.infinity, remoteStatusReceiver);
        try {
            iSVNReporter.setPath("", 1L, Depth.infinity, false, null);
            SVNRemoteTests.assertEquals((long)2L, (long)iSVNReporter.finishReport());
        }
        finally {
            iSVNReporter.dispose();
        }
        SVNRemoteTests.assertEquals((int)4, (int)remoteStatusReceiver.status.size());
        Collections.sort(remoteStatusReceiver.status);
        RemoteStatusReceiver.StatInfo statInfo = remoteStatusReceiver.status.get(3);
        SVNRemoteTests.assertEquals((String)"A/D/gamma", (String)statInfo.relpath);
        SVNRemoteTests.assertEquals((char)'F', (char)statInfo.kind);
        SVNRemoteTests.assertEquals((String)"TextChanged", (boolean)false, (boolean)statInfo.textChanged);
        SVNRemoteTests.assertEquals((String)"Props Changed", (boolean)true, (boolean)statInfo.propsChanged);
        SVNRemoteTests.assertEquals((String)"Node Deleted", (boolean)false, (boolean)statInfo.deleted);
        SVNRemoteTests.assertEquals((long)2L, (long)statInfo.info.getCommittedRevision());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeletedStatus() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        CommitMessageCallback commitMessageCallback = new CommitMessageCallback(){

            @Override
            public String getLogMessage(Set<CommitItem> set) {
                return "Delete A/mu";
            }
        };
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(this.getTestRepoUrl() + "/A/mu");
        this.client.remove(hashSet, false, false, null, commitMessageCallback, null);
        RemoteStatusReceiver remoteStatusReceiver = new RemoteStatusReceiver();
        ISVNReporter iSVNReporter = iSVNRemote.status(null, -1L, Depth.infinity, remoteStatusReceiver);
        try {
            iSVNReporter.setPath("", 1L, Depth.infinity, false, null);
            SVNRemoteTests.assertEquals((long)2L, (long)iSVNReporter.finishReport());
        }
        finally {
            iSVNReporter.dispose();
        }
        SVNRemoteTests.assertEquals((int)3, (int)remoteStatusReceiver.status.size());
        Collections.sort(remoteStatusReceiver.status);
        RemoteStatusReceiver.StatInfo statInfo = remoteStatusReceiver.status.get(2);
        SVNRemoteTests.assertEquals((String)"A/mu", (String)statInfo.relpath);
        SVNRemoteTests.assertEquals((char)' ', (char)statInfo.kind);
        SVNRemoteTests.assertEquals((boolean)false, (boolean)statInfo.textChanged);
        SVNRemoteTests.assertEquals((boolean)false, (boolean)statInfo.propsChanged);
        SVNRemoteTests.assertEquals((boolean)true, (boolean)statInfo.deleted);
    }

    public void testTrivialMergeinfo() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("");
        Map<String, Mergeinfo> map = iSVNRemote.getMergeinfo(arrayList, 1L, Mergeinfo.Inheritance.explicit, false);
        SVNRemoteTests.assertEquals(null, map);
    }

    public void testBranchMergeinfo() throws Exception {
        CommitMessageCallback commitMessageCallback = new CommitMessageCallback(){

            @Override
            public String getLogMessage(Set<CommitItem> set) {
                return "testBranchMergeinfo";
            }
        };
        ISVNRemote iSVNRemote = this.getSession();
        ArrayList<CopySource> arrayList = new ArrayList<CopySource>(1);
        arrayList.add(new CopySource(this.getTestRepoUrl() + "/A", Revision.HEAD, Revision.HEAD));
        this.client.copy(arrayList, this.getTestRepoUrl() + "/Abranch", false, false, true, null, commitMessageCallback, null);
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        arrayList2.add("Abranch");
        Map<String, Mergeinfo> map = iSVNRemote.getMergeinfo(arrayList2, 2L, Mergeinfo.Inheritance.explicit, false);
        SVNRemoteTests.assertEquals(null, map);
        this.client.propertySetRemote(this.getTestRepoUrl() + "/A/D/gamma", 2L, "foo", "bar".getBytes(), commitMessageCallback, false, null, null);
        this.client.update(this.thisTest.getWCPathSet(), Revision.HEAD, Depth.infinity, false, false, true, false);
        this.client.merge(this.getTestRepoUrl() + "/A", Revision.HEAD, null, this.thisTest.getWCPath() + "/Abranch", false, Depth.infinity, false, false, false, false);
        this.client.commit(this.thisTest.getWCPathSet(), Depth.infinity, false, false, null, null, commitMessageCallback, null);
        arrayList2.set(0, "Abranch/mu");
        map = iSVNRemote.getMergeinfo(arrayList2, 4L, Mergeinfo.Inheritance.nearest_ancestor, false);
        SVNRemoteTests.assertEquals((int)1, (int)map.size());
        List<RevisionRange> list = map.get("Abranch/mu").getRevisions("/A/mu");
        SVNRemoteTests.assertEquals((int)1, (int)list.size());
        SVNRemoteTests.assertEquals((String)"1-3", (String)list.get(0).toString());
    }

    public void testGetLocations() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        Long l = 1L;
        ArrayList<Long> arrayList = new ArrayList<Long>(3);
        arrayList.add(0L);
        arrayList.add(l);
        Map<Long, String> map = iSVNRemote.getLocations("A", 1L, arrayList);
        SVNRemoteTests.assertEquals((int)1, (int)map.size());
        SVNRemoteTests.assertTrue((boolean)map.containsKey(l));
        SVNRemoteTests.assertEquals((String)"/A", (String)map.get(l));
    }

    public void testGetLocationSegments() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        List<ISVNRemote.LocationSegment> list = iSVNRemote.getLocationSegments("A", 1L, -1L, -1L);
        SVNRemoteTests.assertEquals((int)1, (int)list.size());
        ISVNRemote.LocationSegment locationSegment = list.get(0);
        SVNRemoteTests.assertEquals((String)"A", (String)locationSegment.getPath());
        SVNRemoteTests.assertEquals((long)1L, (long)locationSegment.getStartRevision());
        SVNRemoteTests.assertEquals((long)1L, (long)locationSegment.getEndRevision());
    }

    public void testGetFileRevisions() throws Exception {
        ISVNRemote iSVNRemote = this.getSession();
        List<ISVNRemote.FileRevision> list = iSVNRemote.getFileRevisions("iota", 0L, 1L, true);
        SVNRemoteTests.assertEquals((int)1, (int)list.size());
        ISVNRemote.FileRevision fileRevision = list.get(0);
        SVNRemoteTests.assertEquals((String)"/iota", (String)fileRevision.getPath());
        SVNRemoteTests.assertFalse((boolean)fileRevision.isResultOfMerge());
        SVNRemoteTests.assertTrue((boolean)fileRevision.hasTextDelta());
    }

    public void testParallelOpen() throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ISVNRemote iSVNRemote = null;
                try {
                    iSVNRemote = SVNRemoteTests.this.getSession();
                    TestCase.assertEquals((long)1L, (long)iSVNRemote.getLatestRevision());
                }
                catch (ClientException clientException) {
                    throw new RuntimeException(clientException);
                }
                finally {
                    if (iSVNRemote != null) {
                        iSVNRemote.dispose();
                    }
                }
            }
        };
        Thread thread = new Thread(runnable);
        Thread thread2 = new Thread(runnable);
        thread.start();
        thread2.start();
        thread.join();
        thread2.join();
    }

    private static class RemoteStatusReceiver
    implements RemoteStatus {
        private boolean debug;
        public ArrayList<StatInfo> status = new ArrayList();

        public RemoteStatusReceiver() {
            this.debug = false;
        }

        public RemoteStatusReceiver(boolean bl) {
            this.debug = bl;
        }

        @Override
        public void addedDirectory(String string) {
            if (this.debug) {
                System.err.println("RemoteStatus:  A   (dir)  " + string);
            }
            this.status.add(new StatInfo(string, 'D', true));
        }

        @Override
        public void addedFile(String string) {
            if (this.debug) {
                System.err.println("RemoteStatus:  A   (file) " + string);
            }
            this.status.add(new StatInfo(string, 'F', true));
        }

        @Override
        public void addedSymlink(String string) {
            if (this.debug) {
                System.err.println("RemoteStatus:  A   (link) " + string);
            }
            this.status.add(new StatInfo(string, 'L', true));
        }

        @Override
        public void modifiedDirectory(String string, boolean bl, boolean bl2, RemoteStatus.Entry entry) {
            if (this.debug) {
                System.err.println("RemoteStatus:  " + (bl ? (char)'M' : '_') + (bl2 ? (char)'M' : '_') + "  (dir)  " + string);
            }
            this.status.add(new StatInfo(string, 'D', bl, bl2, entry));
        }

        @Override
        public void modifiedFile(String string, boolean bl, boolean bl2, RemoteStatus.Entry entry) {
            if (this.debug) {
                System.err.println("RemoteStatus:  " + (bl ? (char)'M' : '_') + (bl2 ? (char)'M' : '_') + "  (file) " + string);
            }
            this.status.add(new StatInfo(string, 'F', bl, bl2, entry));
        }

        @Override
        public void modifiedSymlink(String string, boolean bl, boolean bl2, RemoteStatus.Entry entry) {
            if (this.debug) {
                System.err.println("RemoteStatus:  " + (bl ? (char)'M' : '_') + (bl2 ? (char)'M' : '_') + "  (link) " + string);
            }
            this.status.add(new StatInfo(string, 'L', bl, bl2, entry));
        }

        @Override
        public void deleted(String string) {
            if (this.debug) {
                System.err.println("RemoteStatus:  D          " + string);
            }
            this.status.add(new StatInfo(string, ' ', false));
        }

        static class StatInfo
        implements Comparable<StatInfo> {
            public String relpath = null;
            public char kind = (char)32;
            public boolean textChanged = false;
            public boolean propsChanged = false;
            public boolean deleted = false;
            public RemoteStatus.Entry info = null;

            StatInfo(String string, char c, boolean bl) {
                this.relpath = string;
                this.kind = c;
                this.deleted = !bl;
            }

            StatInfo(String string, char c, boolean bl, boolean bl2, RemoteStatus.Entry entry) {
                this.relpath = string;
                this.kind = c;
                this.textChanged = bl;
                this.propsChanged = bl2;
                this.info = entry;
            }

            public boolean equals(Object object) {
                StatInfo statInfo = (StatInfo)object;
                return this.relpath.equals(statInfo.relpath);
            }

            public int hashCode() {
                return this.relpath.hashCode();
            }

            @Override
            public int compareTo(StatInfo statInfo) {
                return this.relpath.compareTo(statInfo.relpath);
            }
        }
    }

    private static final class LogReceiver
    implements LogMessageCallback {
        public final ArrayList<LogMsg> logs = new ArrayList();

        private LogReceiver() {
        }

        @Override
        public void singleMessage(Set<ChangePath> set, long l, Map<String, byte[]> map, boolean bl) {
            LogMsg logMsg = new LogMsg();
            logMsg.changedPaths = set;
            logMsg.revision = l;
            logMsg.revprops = map;
            logMsg.hasChildren = bl;
            this.logs.add(logMsg);
        }
    }

    private static final class LogMsg {
        public Set<ChangePath> changedPaths;
        public long revision;
        public Map<String, byte[]> revprops;
        public boolean hasChildren;

        private LogMsg() {
        }
    }

    private static final class EditorCallbacks {
        private final String wcpath;
        private final long revision;
        private final Map<String, byte[]> props;
        private final NodeKind kind;
        public final ISVNEditor.ProvideBaseCallback getBase = new ISVNEditor.ProvideBaseCallback(){

            @Override
            public ISVNEditor.ProvideBaseCallback.ReturnValue getContents(String string) {
                try {
                    return new ISVNEditor.ProvideBaseCallback.ReturnValue(new FileInputStream(wcpath + string), revision);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new RuntimeException(fileNotFoundException);
                }
            }
        };
        public final ISVNEditor.ProvidePropsCallback getProps = new ISVNEditor.ProvidePropsCallback(){

            @Override
            public ISVNEditor.ProvidePropsCallback.ReturnValue getProperties(String string) {
                return new ISVNEditor.ProvidePropsCallback.ReturnValue(props, revision);
            }
        };
        public final ISVNEditor.GetNodeKindCallback getKind = new ISVNEditor.GetNodeKindCallback(){

            @Override
            public NodeKind getKind(String string, long l) {
                return kind;
            }
        };

        public EditorCallbacks(String string, long l, Map<String, byte[]> map, NodeKind nodeKind) {
            this.wcpath = string;
            this.revision = l;
            this.props = map;
            this.kind = nodeKind;
        }
    }

    private static final class CommitContext
    implements CommitCallback {
        public final ISVNEditor editor;
        private CommitInfo info;

        public CommitContext(ISVNRemote iSVNRemote, String string, ISVNEditor.ProvideBaseCallback provideBaseCallback, ISVNEditor.ProvidePropsCallback providePropsCallback, ISVNEditor.GetNodeKindCallback getNodeKindCallback) throws ClientException {
            Charset charset = Charset.forName("UTF-8");
            byte[] byArray = string == null ? new byte[]{} : string.getBytes(charset);
            HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
            hashMap.put("svn:log", byArray);
            this.editor = provideBaseCallback == null && providePropsCallback == null && getNodeKindCallback == null ? iSVNRemote.getCommitEditor(hashMap, this, null, false) : iSVNRemote.getCommitEditor(hashMap, this, null, false, provideBaseCallback, providePropsCallback, getNodeKindCallback);
        }

        public CommitContext(ISVNRemote iSVNRemote, String string) throws ClientException {
            this(iSVNRemote, string, null, null, null);
        }

        @Override
        public void commitInfo(CommitInfo commitInfo) {
            this.info = commitInfo;
        }

        public long getRevision() {
            return this.info.getRevision();
        }
    }
}

