/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.SVNTests;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.callback.ReposFreezeAction;
import org.apache.subversion.javahl.callback.ReposVerifyCallback;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.Revision;

public class SVNReposTests
extends SVNTests {
    public static final String testName = "repos_test";

    public SVNReposTests() {
        this.init();
    }

    public SVNReposTests(String string) {
        super(string);
        this.init();
    }

    private void init() {
        if (!testName.equals(this.testBaseName)) {
            testCounter = 0;
            this.testBaseName = testName;
        }
    }

    public void testCreate() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(this, false);
        SVNReposTests.assertTrue((String)"repository exists", (boolean)oneTest.getRepository().exists());
    }

    public void testSetRevProp() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(this, false);
        this.admin.setRevProp(oneTest.getRepository(), Revision.getInstance(0L), "svn:log", "Initial repository creation", false, false);
        Map<String, byte[]> map = this.client.revProperties(this.makeReposUrl(oneTest.getRepository()).toString(), Revision.getInstance(0L));
        SVNReposTests.assertNotNull((Object)"expect non null rev props");
        String string = new String(map.get("svn:log"));
        SVNReposTests.assertEquals((String)"expect rev prop change to take effect", (String)"Initial repository creation", (String)string);
    }

    public void testVerify() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest((SVNTests)this, false, true);
        this.admin.verify(oneTest.getRepository(), Revision.getInstance(0L), Revision.HEAD, null);
    }

    private boolean tryToBreakRepo(SVNTests.OneTest oneTest) throws IOException {
        File file = oneTest.getRepository();
        File file2 = new File(file, "db/revs/0/1");
        if (!file2.exists() || !file2.setWritable(true)) {
            file2 = new File(file, "db/revs/1");
        }
        if (!file2.exists() || !file2.setWritable(true)) {
            return false;
        }
        FileWriter fileWriter = new FileWriter(file2);
        fileWriter.write("inserting junk to corrupt the rev");
        fileWriter.close();
        return true;
    }

    public void testVerifyBrokenRepo() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest((SVNTests)this, false, true);
        if (!this.tryToBreakRepo(oneTest)) {
            System.err.print("Cannot break repository for verify test.");
            return;
        }
        VerifyCallback verifyCallback = new VerifyCallback();
        verifyCallback.keepGoing = false;
        try {
            this.admin.verify(oneTest.getRepository(), Revision.getInstance(0L), Revision.HEAD, false, false, null, verifyCallback);
        }
        catch (ClientException clientException) {
            SVNReposTests.assertEquals((int)verifyCallback.mderr, (int)1);
            SVNReposTests.assertEquals((int)verifyCallback.reverr, (int)0);
            return;
        }
        assert (false);
    }

    public void testVerifyBrokenRepo_KeepGoing() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest((SVNTests)this, false, true);
        if (!this.tryToBreakRepo(oneTest)) {
            System.err.print("Cannot break repository for verify test.");
            return;
        }
        VerifyCallback verifyCallback = new VerifyCallback();
        verifyCallback.keepGoing = true;
        this.admin.verify(oneTest.getRepository(), Revision.getInstance(0L), Revision.HEAD, false, false, null, verifyCallback);
        SVNReposTests.assertEquals((int)verifyCallback.mderr, (int)1);
        SVNReposTests.assertEquals((int)verifyCallback.reverr, (int)1);
    }

    public void testUpgrade() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(this, false);
        this.admin.upgrade(oneTest.getRepository(), null);
    }

    public void testPack() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(this, false);
        this.admin.pack(oneTest.getRepository(), null);
    }

    public void testFreeze() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(this, false);
        FreezeAction freezeAction = new FreezeAction();
        this.admin.freeze(freezeAction, oneTest.getRepository());
        SVNReposTests.assertEquals((String)"expect freeze callback to be invoked once", (int)1, (int)freezeAction.invoked);
    }

    public void testLoadRepo() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest((SVNTests)this, false, false);
        URI uRI = this.makeReposUrl(oneTest.getRepository());
        final Info[] infoArray = new Info[1];
        InfoCallback infoCallback = new InfoCallback(){

            @Override
            public void singleInfo(Info info) {
                infoArray[0] = info;
            }
        };
        this.client.info2(uRI.toString(), Revision.HEAD, Revision.HEAD, Depth.immediates, null, infoCallback);
        SVNReposTests.assertNotNull((String)"expect info callback", (Object)infoArray[0]);
        SVNReposTests.assertEquals((String)"expect zero revisions in new repository", (long)0L, (long)infoArray[0].getLastChangedRev());
        String string = System.getProperty("test.srcdir", "subversion/bindings/javahl");
        File file = new File(string, "tests/data/issue2979.dump");
        FileInputStream fileInputStream = new FileInputStream(file);
        this.admin.load(oneTest.getRepository(), fileInputStream, true, true, false, false, null, null);
        infoArray[0] = null;
        this.client.info2(uRI.toString(), Revision.HEAD, Revision.HEAD, Depth.immediates, null, infoCallback);
        SVNReposTests.assertEquals((String)"expect two revisions after load()", (long)2L, (long)infoArray[0].getLastChangedRev());
        SVNReposTests.assertEquals((String)"expect 'svn4ant' as author of r2", (String)"svn4ant", (String)infoArray[0].getLastChangedAuthor());
    }

    private class FreezeAction
    implements ReposFreezeAction {
        int invoked = 0;

        private FreezeAction() {
        }

        @Override
        public void invoke() {
            ++this.invoked;
        }
    }

    private class VerifyCallback
    implements ReposVerifyCallback {
        public int mderr = 0;
        public int reverr = 0;
        public boolean keepGoing = false;

        private VerifyCallback() {
        }

        @Override
        public void onVerifyError(long l, ClientException clientException) throws ClientException {
            if (l == -1L) {
                ++this.mderr;
            } else {
                ++this.reverr;
            }
            if (this.keepGoing) {
                return;
            }
            throw clientException;
        }
    }
}

