// -*- C++ -*-
TAO_BEGIN_VERSIONED_NAMESPACE_DECL

ACE_INLINE CORBA::Boolean
TAO_CEC_ProxyPushConsumer::is_connected_i () const
{
  return this->connected_;
}

ACE_INLINE CORBA::Boolean
TAO_CEC_ProxyPushConsumer::is_connected () const
{
  ACE_GUARD_RETURN (ACE_Lock, ace_mon, *this->lock_, false);

  return this->is_connected_i ();
}

ACE_INLINE CosEventComm::PushSupplier_ptr
TAO_CEC_ProxyPushConsumer::supplier () const
{
  ACE_GUARD_RETURN (ACE_Lock, ace_mon, *this->lock_, 0);
  return CosEventComm::PushSupplier::_duplicate (this->supplier_.in ());
}

ACE_INLINE void
TAO_CEC_ProxyPushConsumer::supplier_i (CosEventComm::PushSupplier_ptr supplier)
{
  this->supplier_ = supplier;
}

ACE_INLINE void
TAO_CEC_ProxyPushConsumer::supplier (CosEventComm::PushSupplier_ptr supplier)
{
  ACE_GUARD (ACE_Lock, ace_mon, *this->lock_);

  this->supplier_i (supplier);
}

// ****************************************************************

ACE_INLINE bool
TAO_CEC_ProxyPushConsumer_Guard::locked () const
{
  return this->locked_;
}

TAO_END_VERSIONED_NAMESPACE_DECL
