<?php
// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: include_sefurl.php 66696 2018-06-16 20:57:43Z lindonb $

if (basename($_SERVER['SCRIPT_NAME']) === basename(__FILE__)) {
	die('This script may only be included.');
}
require_once('tiki-setup.php');

if (isset($_POST['feature_sefurl_paths']) && $access->checkCsrf()) {
	//TODO Don't change $_POST values directly
	$_POST['feature_sefurl_paths'] = preg_split('/ *[,\/] */', $_POST['feature_sefurl_paths']);
	simple_set_value('feature_sefurl_paths');
}

if (TikiInit::isIIS()) {
	$httpd = 'IIS';
	if (TikiInit::hasIIS_UrlRewriteModule()) {
		$smarty->assign('IIS_UrlRewriteModule', true);
		$enabledFileName = 'web.config';
		$referenceFileName = 'web_config';
	} else {
		$smarty->assign('IIS_UrlRewriteModule', false);
	}
} else {
	$enabledFileName = '.htaccess';
	$referenceFileName = '_htaccess';
	$httpd = 'Apache';
}
$smarty->assign('httpd', $httpd);

// Check if the URL rewriting configuration file is present and current
$configurationFile = "missing";
if (isset($enabledFileName)) {
	$enabledFile = @fopen($enabledFileName, "r");
	if ($enabledFile) {
		$referenceFile = fopen($referenceFileName, "r");
		if ($referenceFile) {
			if ($httpd == 'IIS') {
				// On IIS, the Id line is the second line, rather than the first as in Apache.
				fgets($referenceFile);
				fgets($enabledFile);
			}
			$referenceIdLine = fgets($referenceFile);
			$enabledIdLine = fgets($enabledFile);
			if (! strstr($enabledIdLine, 'This line is used to check that this configuration file is up to date.')) {
				$configurationFile = 'unexpected';
			} elseif ($referenceIdLine == $enabledIdLine) { // Do not warn if the Id line of each file is identical. Id lines contain configuration file revision.
				$configurationFile = 'current';
			} else {
				$configurationFile = 'outdated';
			}
			if ($httpd === 'Apache') {
				// work out if RewriteBase is set up properly
				global $url_path;
				$rewritebase = '/';
				while ($nextLine = fgets($enabledFile)) {
					if (preg_match('/^\s*?RewriteBase\s*[\'"]?(.*?)[\'"]?$/', $nextLine, $m)) {
						$rewritebase = substr($m[1], -1) !== '/' ? $m[1] . '/' : $m[1];
						break;
					}
				}
				if ($url_path != $rewritebase) {
					$smarty->assign('rewritebaseSetting', $rewritebase);
				}
			}
			fclose($referenceFile);
		} else {
			$configurationFile = 'no reference';
		}
		fclose($enabledFile);
	}
	$smarty->assign('referenceFileName', $referenceFileName);
	$smarty->assign('enabledFileName', $enabledFileName);
	$smarty->assign('configurationFile', $configurationFile);
}
