<?php
// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: mod-func-register.php 66866 2018-07-01 19:41:58Z rjsmelo $

//this script may only be included - so its better to die if called directly.
if (strpos($_SERVER["SCRIPT_NAME"], basename(__FILE__)) !== false) {
	header("location: index.php");
	exit;
}

/**
 * @return array
 */
function module_register_info()
{
	return [
		'name' => tra('New User Registration'),
		'description' => tra('Permit anonymous visitors to create an account on the site.'),
		'prefs' => ['allowRegister'],
		'params' => [],
	];
}

/**
 * @param $mod_reference
 * @param $module_params
 * @return array|mixed|RegistrationError|string
 */
function module_register($mod_reference, $module_params)
{
	$smarty = TikiLib::lib('smarty');
	include_once('lib/smarty_tiki/function.user_registration.php');
	return smarty_function_user_registration($module_params, $smarty->getEmptyInternalTemplate());
}
