<?php
// ===================================================================================================
//                           _  __     _ _
//                          | |/ /__ _| | |_ _  _ _ _ __ _
//                          | ' </ _` | |  _| || | '_/ _` |
//                          |_|\_\__,_|_|\__|\_,_|_| \__,_|
//
// This file is part of the Kaltura Collaborative Media Suite which allows users
// to do with audio, video, and animation what Wiki platfroms allow them to do with
// text.
//
// Copyright (C) 2006-2017  Kaltura Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// @ignore
// ===================================================================================================

/**
 * @namespace
 */
namespace Kaltura\Client\Type;

/**
 * @package Kaltura
 * @subpackage Client
 */
abstract class BulkUploadBaseFilter extends \Kaltura\Client\Type\Filter
{
	public function getKalturaObjectType()
	{
		return 'KalturaBulkUploadBaseFilter';
	}
	
	public function __construct(\SimpleXMLElement $xml = null)
	{
		parent::__construct($xml);
		
		if(is_null($xml))
			return;
		
		if(count($xml->uploadedOnGreaterThanOrEqual))
			$this->uploadedOnGreaterThanOrEqual = (int)$xml->uploadedOnGreaterThanOrEqual;
		if(count($xml->uploadedOnLessThanOrEqual))
			$this->uploadedOnLessThanOrEqual = (int)$xml->uploadedOnLessThanOrEqual;
		if(count($xml->uploadedOnEqual))
			$this->uploadedOnEqual = (int)$xml->uploadedOnEqual;
		if(count($xml->statusIn))
			$this->statusIn = (string)$xml->statusIn;
		if(count($xml->statusEqual))
			$this->statusEqual = (int)$xml->statusEqual;
		if(count($xml->bulkUploadObjectTypeEqual))
			$this->bulkUploadObjectTypeEqual = (string)$xml->bulkUploadObjectTypeEqual;
		if(count($xml->bulkUploadObjectTypeIn))
			$this->bulkUploadObjectTypeIn = (string)$xml->bulkUploadObjectTypeIn;
	}
	/**
	 * 
	 * @var int
	 */
	public $uploadedOnGreaterThanOrEqual = null;

	/**
	 * 
	 * @var int
	 */
	public $uploadedOnLessThanOrEqual = null;

	/**
	 * 
	 * @var int
	 */
	public $uploadedOnEqual = null;

	/**
	 * 
	 * @var string
	 */
	public $statusIn = null;

	/**
	 * 
	 * @var \Kaltura\Client\Enum\BatchJobStatus
	 */
	public $statusEqual = null;

	/**
	 * 
	 * @var \Kaltura\Client\Enum\BulkUploadObjectType
	 */
	public $bulkUploadObjectTypeEqual = null;

	/**
	 * 
	 * @var string
	 */
	public $bulkUploadObjectTypeIn = null;

}
