<?php
// ===================================================================================================
//                           _  __     _ _
//                          | |/ /__ _| | |_ _  _ _ _ __ _
//                          | ' </ _` | |  _| || | '_/ _` |
//                          |_|\_\__,_|_|\__|\_,_|_| \__,_|
//
// This file is part of the Kaltura Collaborative Media Suite which allows users
// to do with audio, video, and animation what Wiki platfroms allow them to do with
// text.
//
// Copyright (C) 2006-2017  Kaltura Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// @ignore
// ===================================================================================================

/**
 * @namespace
 */
namespace Kaltura\Client;

/**
 * @package Kaltura
 * @subpackage Client
 */
class TypeMap
{
	private static $map = array(
		'KalturaListResponse' => 'Kaltura\Client\Type\ListResponse',
		'KalturaBaseRestriction' => 'Kaltura\Client\Type\BaseRestriction',
		'KalturaAccessControl' => 'Kaltura\Client\Type\AccessControl',
		'KalturaAccessControlAction' => 'Kaltura\Client\Type\AccessControlAction',
		'KalturaContextTypeHolder' => 'Kaltura\Client\Type\ContextTypeHolder',
		'KalturaAccessControlContextTypeHolder' => 'Kaltura\Client\Type\AccessControlContextTypeHolder',
		'KalturaAccessControlMessage' => 'Kaltura\Client\Type\AccessControlMessage',
		'KalturaRuleAction' => 'Kaltura\Client\Type\RuleAction',
		'KalturaCondition' => 'Kaltura\Client\Type\Condition',
		'KalturaRule' => 'Kaltura\Client\Type\Rule',
		'KalturaAccessControlProfile' => 'Kaltura\Client\Type\AccessControlProfile',
		'KalturaKeyValue' => 'Kaltura\Client\Type\KeyValue',
		'KalturaAccessControlScope' => 'Kaltura\Client\Type\AccessControlScope',
		'KalturaReportFilter' => 'Kaltura\Client\Type\ReportFilter',
		'KalturaAnalyticsFilter' => 'Kaltura\Client\Type\AnalyticsFilter',
		'KalturaCuePoint' => 'Kaltura\Client\Plugin\CuePoint\Type\CuePoint',
		'KalturaAnnotation' => 'Kaltura\Client\Plugin\Annotation\Type\Annotation',
		'KalturaApiExceptionArg' => 'Kaltura\Client\Type\ApiExceptionArg',
		'KalturaAppToken' => 'Kaltura\Client\Type\AppToken',
		'KalturaAsset' => 'Kaltura\Client\Type\Asset',
		'KalturaAssetDistributionCondition' => 'Kaltura\Client\Plugin\ContentDistribution\Type\AssetDistributionCondition',
		'KalturaAssetDistributionRule' => 'Kaltura\Client\Plugin\ContentDistribution\Type\AssetDistributionRule',
		'KalturaString' => 'Kaltura\Client\Type\String',
		'KalturaAssetParams' => 'Kaltura\Client\Type\AssetParams',
		'KalturaResource' => 'Kaltura\Client\Type\Resource',
		'KalturaContentResource' => 'Kaltura\Client\Type\ContentResource',
		'KalturaAssetParamsResourceContainer' => 'Kaltura\Client\Type\AssetParamsResourceContainer',
		'KalturaAssetServeOptions' => 'Kaltura\Client\Type\AssetServeOptions',
		'KalturaAttachmentAsset' => 'Kaltura\Client\Plugin\Attachment\Type\AttachmentAsset',
		'KalturaOperationAttributes' => 'Kaltura\Client\Type\OperationAttributes',
		'KalturaBaseEntry' => 'Kaltura\Client\Type\BaseEntry',
		'KalturaBaseEntryCloneOptionItem' => 'Kaltura\Client\Type\BaseEntryCloneOptionItem',
		'KalturaBaseResponseProfile' => 'Kaltura\Client\Type\BaseResponseProfile',
		'KalturaBaseSyndicationFeed' => 'Kaltura\Client\Type\BaseSyndicationFeed',
		'KalturaJobData' => 'Kaltura\Client\Type\JobData',
		'KalturaBatchHistoryData' => 'Kaltura\Client\Type\BatchHistoryData',
		'KalturaBatchJob' => 'Kaltura\Client\Type\BatchJob',
		'KalturaPlayerDeliveryType' => 'Kaltura\Client\Type\PlayerDeliveryType',
		'KalturaPlayerEmbedCodeType' => 'Kaltura\Client\Type\PlayerEmbedCodeType',
		'KalturaPartner' => 'Kaltura\Client\Type\Partner',
		'KalturaBatchGetExclusiveNotificationJobsResponse' => 'Kaltura\Client\Type\BatchGetExclusiveNotificationJobsResponse',
		'KalturaBatchJobResponse' => 'Kaltura\Client\Type\BatchJobResponse',
		'KalturaBatchQueuesStatus' => 'Kaltura\Client\Type\BatchQueuesStatus',
		'KalturaValue' => 'Kaltura\Client\Type\Value',
		'KalturaBooleanValue' => 'Kaltura\Client\Type\BooleanValue',
		'KalturaBulkServiceData' => 'Kaltura\Client\Plugin\BulkUpload\Type\BulkServiceData',
		'KalturaBulkUploadPluginData' => 'Kaltura\Client\Type\BulkUploadPluginData',
		'KalturaBulkUploadResult' => 'Kaltura\Client\Type\BulkUploadResult',
		'KalturaBulkUpload' => 'Kaltura\Client\Type\BulkUpload',
		'KalturaBulkUploadObjectData' => 'Kaltura\Client\Type\BulkUploadObjectData',
		'KalturaCEError' => 'Kaltura\Client\Type\CEError',
		'KalturaCaptionAsset' => 'Kaltura\Client\Plugin\Caption\Type\CaptionAsset',
		'KalturaCaptionAssetItem' => 'Kaltura\Client\Plugin\CaptionSearch\Type\CaptionAssetItem',
		'KalturaCaptionParams' => 'Kaltura\Client\Plugin\Caption\Type\CaptionParams',
		'KalturaCategory' => 'Kaltura\Client\Type\Category',
		'KalturaCategoryEntry' => 'Kaltura\Client\Type\CategoryEntry',
		'KalturaCategoryUser' => 'Kaltura\Client\Type\CategoryUser',
		'KalturaClientConfiguration' => 'Kaltura\Client\Type\ClientConfiguration',
		'KalturaClientNotification' => 'Kaltura\Client\Type\ClientNotification',
		'KalturaContext' => 'Kaltura\Client\Type\Context',
		'KalturaContextDataResult' => 'Kaltura\Client\Type\ContextDataResult',
		'KalturaControlPanelCommand' => 'Kaltura\Client\Type\ControlPanelCommand',
		'KalturaConversionAttribute' => 'Kaltura\Client\Type\ConversionAttribute',
		'KalturaCropDimensions' => 'Kaltura\Client\Type\CropDimensions',
		'KalturaConversionProfile' => 'Kaltura\Client\Type\ConversionProfile',
		'KalturaConversionProfileAssetParams' => 'Kaltura\Client\Type\ConversionProfileAssetParams',
		'KalturaConvertCollectionFlavorData' => 'Kaltura\Client\Type\ConvertCollectionFlavorData',
		'KalturaCoordinate' => 'Kaltura\Client\Type\Coordinate',
		'KalturaDataEntry' => 'Kaltura\Client\Type\DataEntry',
		'KalturaUrlRecognizer' => 'Kaltura\Client\Type\UrlRecognizer',
		'KalturaUrlTokenizer' => 'Kaltura\Client\Type\UrlTokenizer',
		'KalturaSearchItem' => 'Kaltura\Client\Type\SearchItem',
		'KalturaFilter' => 'Kaltura\Client\Type\Filter',
		'KalturaRelatedFilter' => 'Kaltura\Client\Type\RelatedFilter',
		'KalturaAssetBaseFilter' => 'Kaltura\Client\Type\AssetBaseFilter',
		'KalturaAssetFilter' => 'Kaltura\Client\Type\AssetFilter',
		'KalturaDeliveryProfile' => 'Kaltura\Client\Type\DeliveryProfile',
		'KalturaFileSyncDescriptor' => 'Kaltura\Client\Type\FileSyncDescriptor',
		'KalturaDestFileSyncDescriptor' => 'Kaltura\Client\Type\DestFileSyncDescriptor',
		'KalturaFilterPager' => 'Kaltura\Client\Type\FilterPager',
		'KalturaResponseProfileMapping' => 'Kaltura\Client\Type\ResponseProfileMapping',
		'KalturaDetachedResponseProfile' => 'Kaltura\Client\Type\DetachedResponseProfile',
		'KalturaDistributionFieldConfig' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionFieldConfig',
		'KalturaDistributionJobProviderData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionJobProviderData',
		'KalturaDistributionThumbDimensions' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionThumbDimensions',
		'KalturaDistributionProfile' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionProfile',
		'KalturaDistributionProvider' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionProvider',
		'KalturaDistributionRemoteMediaFile' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionRemoteMediaFile',
		'KalturaDistributionValidationError' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionValidationError',
		'KalturaDocumentEntry' => 'Kaltura\Client\Plugin\Document\Type\DocumentEntry',
		'KalturaDropFolderFileHandlerConfig' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderFileHandlerConfig',
		'KalturaDropFolder' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolder',
		'KalturaDropFolderFile' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderFile',
		'KalturaEmailIngestionProfile' => 'Kaltura\Client\Type\EmailIngestionProfile',
		'KalturaStringValue' => 'Kaltura\Client\Type\StringValue',
		'KalturaEmailNotificationRecipient' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationRecipient',
		'KalturaEmailNotificationRecipientJobData' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationRecipientJobData',
		'KalturaEmailNotificationRecipientProvider' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationRecipientProvider',
		'KalturaEntryDistribution' => 'Kaltura\Client\Plugin\ContentDistribution\Type\EntryDistribution',
		'KalturaPluginReplacementOptionsItem' => 'Kaltura\Client\Type\PluginReplacementOptionsItem',
		'KalturaEntryReplacementOptions' => 'Kaltura\Client\Type\EntryReplacementOptions',
		'KalturaEntryServerNode' => 'Kaltura\Client\Type\EntryServerNode',
		'KalturaEventCondition' => 'Kaltura\Client\Plugin\EventNotification\Type\EventCondition',
		'KalturaEventNotificationParameter' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationParameter',
		'KalturaEventNotificationTemplate' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationTemplate',
		'KalturaExclusiveLockKey' => 'Kaltura\Client\Type\ExclusiveLockKey',
		'KalturaObjectIdentifier' => 'Kaltura\Client\Type\ObjectIdentifier',
		'KalturaExtendingItemMrssParameter' => 'Kaltura\Client\Type\ExtendingItemMrssParameter',
		'KalturaPlayableEntry' => 'Kaltura\Client\Type\PlayableEntry',
		'KalturaStreamContainer' => 'Kaltura\Client\Type\StreamContainer',
		'KalturaMediaEntry' => 'Kaltura\Client\Type\MediaEntry',
		'KalturaExternalMediaEntry' => 'Kaltura\Client\Plugin\ExternalMedia\Type\ExternalMediaEntry',
		'KalturaFacebookCaptionDistributionInfo' => 'Kaltura\Client\Plugin\FacebookDistribution\Type\FacebookCaptionDistributionInfo',
		'KalturaFeatureStatus' => 'Kaltura\Client\Type\FeatureStatus',
		'KalturaFeedItemInfo' => 'Kaltura\Client\Plugin\FeedDropFolder\Type\FeedItemInfo',
		'KalturaFileAsset' => 'Kaltura\Client\Type\FileAsset',
		'KalturaFileExistsResponse' => 'Kaltura\Client\Type\FileExistsResponse',
		'KalturaFileSync' => 'Kaltura\Client\Plugin\FileSync\Type\FileSync',
		'KalturaFlavorAsset' => 'Kaltura\Client\Type\FlavorAsset',
		'KalturaFlavorAssetUrlOptions' => 'Kaltura\Client\Type\FlavorAssetUrlOptions',
		'KalturaFlavorParams' => 'Kaltura\Client\Type\FlavorParams',
		'KalturaFlavorAssetWithParams' => 'Kaltura\Client\Type\FlavorAssetWithParams',
		'KalturaFlavorParamsOutput' => 'Kaltura\Client\Type\FlavorParamsOutput',
		'KalturaFreeJobResponse' => 'Kaltura\Client\Type\FreeJobResponse',
		'KalturaSchedulerStatus' => 'Kaltura\Client\Type\SchedulerStatus',
		'KalturaSchedulerConfig' => 'Kaltura\Client\Type\SchedulerConfig',
		'KalturaSchedulerWorker' => 'Kaltura\Client\Type\SchedulerWorker',
		'KalturaScheduler' => 'Kaltura\Client\Type\Scheduler',
		'KalturaFullStatusResponse' => 'Kaltura\Client\Type\FullStatusResponse',
		'KalturaGenericDistributionProfileAction' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProfileAction',
		'KalturaGenericDistributionProviderAction' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProviderAction',
		'KalturaGenericDistributionProvider' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProvider',
		'KalturaGroupUser' => 'Kaltura\Client\Type\GroupUser',
		'KalturaObject' => 'Kaltura\Client\Type\Object',
		'KalturaHttpNotification' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotification',
		'KalturaHttpNotificationData' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotificationData',
		'KalturaIntegerValue' => 'Kaltura\Client\Type\IntegerValue',
		'KalturaIntegrationJobProviderData' => 'Kaltura\Client\Plugin\Integration\Type\IntegrationJobProviderData',
		'KalturaIntegrationJobTriggerData' => 'Kaltura\Client\Plugin\Integration\Type\IntegrationJobTriggerData',
		'KalturaInternalToolsSession' => 'Kaltura\Client\Plugin\KalturaInternalTools\Type\InternalToolsSession',
		'KalturaFileSyncListResponse' => 'Kaltura\Client\Plugin\FileSync\Type\FileSyncListResponse',
		'KalturaBatchJobListResponse' => 'Kaltura\Client\Type\BatchJobListResponse',
		'KalturaMediaInfo' => 'Kaltura\Client\Type\MediaInfo',
		'KalturaMediaInfoListResponse' => 'Kaltura\Client\Type\MediaInfoListResponse',
		'KalturaFlavorParamsOutputListResponse' => 'Kaltura\Client\Type\FlavorParamsOutputListResponse',
		'KalturaInvestigateFlavorAssetData' => 'Kaltura\Client\Plugin\AdminConsole\Type\InvestigateFlavorAssetData',
		'KalturaThumbAsset' => 'Kaltura\Client\Type\ThumbAsset',
		'KalturaThumbParams' => 'Kaltura\Client\Type\ThumbParams',
		'KalturaThumbParamsOutput' => 'Kaltura\Client\Type\ThumbParamsOutput',
		'KalturaThumbParamsOutputListResponse' => 'Kaltura\Client\Type\ThumbParamsOutputListResponse',
		'KalturaInvestigateThumbAssetData' => 'Kaltura\Client\Plugin\AdminConsole\Type\InvestigateThumbAssetData',
		'KalturaTrackEntry' => 'Kaltura\Client\Plugin\AdminConsole\Type\TrackEntry',
		'KalturaInvestigateEntryData' => 'Kaltura\Client\Plugin\AdminConsole\Type\InvestigateEntryData',
		'KalturaKeyBooleanValue' => 'Kaltura\Client\Type\KeyBooleanValue',
		'KalturaLike' => 'Kaltura\Client\Plugin\Like\Type\Like',
		'KalturaLiveStreamConfiguration' => 'Kaltura\Client\Type\LiveStreamConfiguration',
		'KalturaLiveStreamPushPublishConfiguration' => 'Kaltura\Client\Type\LiveStreamPushPublishConfiguration',
		'KalturaLiveEntryRecordingOptions' => 'Kaltura\Client\Type\LiveEntryRecordingOptions',
		'KalturaLiveEntry' => 'Kaltura\Client\Type\LiveEntry',
		'KalturaLiveChannel' => 'Kaltura\Client\Type\LiveChannel',
		'KalturaLiveChannelSegment' => 'Kaltura\Client\Type\LiveChannelSegment',
		'KalturaLiveReportExportParams' => 'Kaltura\Client\Type\LiveReportExportParams',
		'KalturaLiveReportExportResponse' => 'Kaltura\Client\Type\LiveReportExportResponse',
		'KalturaLiveReportInputFilter' => 'Kaltura\Client\Type\LiveReportInputFilter',
		'KalturaLiveStats' => 'Kaltura\Client\Type\LiveStats',
		'KalturaLiveStatsEvent' => 'Kaltura\Client\Type\LiveStatsEvent',
		'KalturaLiveStreamBitrate' => 'Kaltura\Client\Type\LiveStreamBitrate',
		'KalturaLiveStreamEntry' => 'Kaltura\Client\Type\LiveStreamEntry',
		'KalturaLiveStreamParams' => 'Kaltura\Client\Type\LiveStreamParams',
		'KalturaBaseEntryBaseFilter' => 'Kaltura\Client\Type\BaseEntryBaseFilter',
		'KalturaBaseEntryFilter' => 'Kaltura\Client\Type\BaseEntryFilter',
		'KalturaPlayableEntryBaseFilter' => 'Kaltura\Client\Type\PlayableEntryBaseFilter',
		'KalturaPlayableEntryFilter' => 'Kaltura\Client\Type\PlayableEntryFilter',
		'KalturaMediaEntryBaseFilter' => 'Kaltura\Client\Type\MediaEntryBaseFilter',
		'KalturaMediaEntryFilter' => 'Kaltura\Client\Type\MediaEntryFilter',
		'KalturaMediaEntryFilterForPlaylist' => 'Kaltura\Client\Type\MediaEntryFilterForPlaylist',
		'KalturaMediaServerStatus' => 'Kaltura\Client\Type\MediaServerStatus',
		'KalturaMetadata' => 'Kaltura\Client\Plugin\Metadata\Type\Metadata',
		'KalturaMetadataProfile' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataProfile',
		'KalturaMetadataProfileField' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataProfileField',
		'KalturaMixEntry' => 'Kaltura\Client\Type\MixEntry',
		'KalturaModerationFlag' => 'Kaltura\Client\Type\ModerationFlag',
		'KalturaObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ObjectTask',
		'KalturaOptionalAnswer' => 'Kaltura\Client\Plugin\Quiz\Type\OptionalAnswer',
		'KalturaPartnerStatistics' => 'Kaltura\Client\Type\PartnerStatistics',
		'KalturaPartnerUsage' => 'Kaltura\Client\Type\PartnerUsage',
		'KalturaPermission' => 'Kaltura\Client\Type\Permission',
		'KalturaPermissionItem' => 'Kaltura\Client\Type\PermissionItem',
		'KalturaPluginData' => 'Kaltura\Client\Type\PluginData',
		'KalturaDrmPlaybackPluginData' => 'Kaltura\Client\Type\DrmPlaybackPluginData',
		'KalturaPlaybackSource' => 'Kaltura\Client\Type\PlaybackSource',
		'KalturaPlaybackContext' => 'Kaltura\Client\Type\PlaybackContext',
		'KalturaPlaylist' => 'Kaltura\Client\Type\Playlist',
		'KalturaPushEventNotificationParameter' => 'Kaltura\Client\Plugin\PushNotification\Type\PushEventNotificationParameter',
		'KalturaQuiz' => 'Kaltura\Client\Plugin\Quiz\Type\Quiz',
		'KalturaRemotePath' => 'Kaltura\Client\Type\RemotePath',
		'KalturaUrlResource' => 'Kaltura\Client\Type\UrlResource',
		'KalturaRemoteStorageResource' => 'Kaltura\Client\Type\RemoteStorageResource',
		'KalturaReport' => 'Kaltura\Client\Type\Report',
		'KalturaReportBaseTotal' => 'Kaltura\Client\Type\ReportBaseTotal',
		'KalturaReportGraph' => 'Kaltura\Client\Type\ReportGraph',
		'KalturaReportInputBaseFilter' => 'Kaltura\Client\Type\ReportInputBaseFilter',
		'KalturaReportResponse' => 'Kaltura\Client\Type\ReportResponse',
		'KalturaReportTable' => 'Kaltura\Client\Type\ReportTable',
		'KalturaReportTotal' => 'Kaltura\Client\Type\ReportTotal',
		'KalturaRequestConfiguration' => 'Kaltura\Client\Type\RequestConfiguration',
		'KalturaResponseProfile' => 'Kaltura\Client\Type\ResponseProfile',
		'KalturaResponseProfileCacheRecalculateOptions' => 'Kaltura\Client\Type\ResponseProfileCacheRecalculateOptions',
		'KalturaResponseProfileCacheRecalculateResults' => 'Kaltura\Client\Type\ResponseProfileCacheRecalculateResults',
		'KalturaScheduleEventRecurrence' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEventRecurrence',
		'KalturaScheduleEvent' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEvent',
		'KalturaScheduleEventResource' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEventResource',
		'KalturaScheduleResource' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleResource',
		'KalturaScheduledTaskProfile' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ScheduledTaskProfile',
		'KalturaSchedulerStatusResponse' => 'Kaltura\Client\Type\SchedulerStatusResponse',
		'KalturaScope' => 'Kaltura\Client\Type\Scope',
		'KalturaSearch' => 'Kaltura\Client\Type\Search',
		'KalturaSearchAuthData' => 'Kaltura\Client\Type\SearchAuthData',
		'KalturaSearchResult' => 'Kaltura\Client\Type\SearchResult',
		'KalturaSearchResultResponse' => 'Kaltura\Client\Type\SearchResultResponse',
		'KalturaServerNode' => 'Kaltura\Client\Type\ServerNode',
		'KalturaSessionInfo' => 'Kaltura\Client\Type\SessionInfo',
		'KalturaShortLink' => 'Kaltura\Client\Plugin\ShortLink\Type\ShortLink',
		'KalturaSourceFileSyncDescriptor' => 'Kaltura\Client\Type\SourceFileSyncDescriptor',
		'KalturaStartWidgetSessionResponse' => 'Kaltura\Client\Type\StartWidgetSessionResponse',
		'KalturaStatsEvent' => 'Kaltura\Client\Type\StatsEvent',
		'KalturaStatsKmcEvent' => 'Kaltura\Client\Type\StatsKmcEvent',
		'KalturaStorageProfile' => 'Kaltura\Client\Type\StorageProfile',
		'KalturaSupportedSubTypes' => 'Kaltura\Client\Type\SupportedSubTypes',
		'KalturaSyndicationFeedEntryCount' => 'Kaltura\Client\Type\SyndicationFeedEntryCount',
		'KalturaSystemPartnerLimit' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerLimit',
		'KalturaSystemPartnerConfiguration' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerConfiguration',
		'KalturaSystemPartnerPackage' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerPackage',
		'KalturaSystemPartnerUsageItem' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerUsageItem',
		'KalturaTag' => 'Kaltura\Client\Plugin\TagSearch\Type\Tag',
		'KalturaTranscriptAsset' => 'Kaltura\Client\Plugin\Transcript\Type\TranscriptAsset',
		'KalturaTransformMetadataResponse' => 'Kaltura\Client\Plugin\Metadata\Type\TransformMetadataResponse',
		'KalturaTypedArray' => 'Kaltura\Client\Type\TypedArray',
		'KalturaUiConf' => 'Kaltura\Client\Type\UiConf',
		'KalturaUiConfAdmin' => 'Kaltura\Client\Plugin\AdminConsole\Type\UiConfAdmin',
		'KalturaUiConfTypeInfo' => 'Kaltura\Client\Type\UiConfTypeInfo',
		'KalturaUpgradeMetadataResponse' => 'Kaltura\Client\Plugin\Metadata\Type\UpgradeMetadataResponse',
		'KalturaUploadResponse' => 'Kaltura\Client\Type\UploadResponse',
		'KalturaUploadToken' => 'Kaltura\Client\Type\UploadToken',
		'KalturaUser' => 'Kaltura\Client\Type\User',
		'KalturaUserEntry' => 'Kaltura\Client\Type\UserEntry',
		'KalturaUserLoginData' => 'Kaltura\Client\Type\UserLoginData',
		'KalturaUserRole' => 'Kaltura\Client\Type\UserRole',
		'KalturaVarPartnerUsageItem' => 'Kaltura\Client\Plugin\VarConsole\Type\VarPartnerUsageItem',
		'KalturaVirusScanProfile' => 'Kaltura\Client\Plugin\VirusScan\Type\VirusScanProfile',
		'KalturaWidget' => 'Kaltura\Client\Type\Widget',
		'KalturaBatchJobBaseFilter' => 'Kaltura\Client\Type\BatchJobBaseFilter',
		'KalturaBatchJobFilter' => 'Kaltura\Client\Type\BatchJobFilter',
		'KalturaWorkerQueueFilter' => 'Kaltura\Client\Type\WorkerQueueFilter',
		'KalturaYouTubeApiCaptionDistributionInfo' => 'Kaltura\Client\Plugin\YoutubeApiDistribution\Type\YouTubeApiCaptionDistributionInfo',
		'KalturaAccessControlBlockAction' => 'Kaltura\Client\Type\AccessControlBlockAction',
		'KalturaAccessControlLimitDeliveryProfilesAction' => 'Kaltura\Client\Type\AccessControlLimitDeliveryProfilesAction',
		'KalturaAccessControlLimitFlavorsAction' => 'Kaltura\Client\Type\AccessControlLimitFlavorsAction',
		'KalturaAccessControlLimitThumbnailCaptureAction' => 'Kaltura\Client\Type\AccessControlLimitThumbnailCaptureAction',
		'KalturaAccessControlListResponse' => 'Kaltura\Client\Type\AccessControlListResponse',
		'KalturaAccessControlModifyRequestHostRegexAction' => 'Kaltura\Client\Type\AccessControlModifyRequestHostRegexAction',
		'KalturaAccessControlPreviewAction' => 'Kaltura\Client\Type\AccessControlPreviewAction',
		'KalturaAccessControlProfileListResponse' => 'Kaltura\Client\Type\AccessControlProfileListResponse',
		'KalturaAccessControlServeRemoteEdgeServerAction' => 'Kaltura\Client\Type\AccessControlServeRemoteEdgeServerAction',
		'KalturaAdCuePoint' => 'Kaltura\Client\Plugin\AdCuePoint\Type\AdCuePoint',
		'KalturaAdminUser' => 'Kaltura\Client\Type\AdminUser',
		'KalturaAmazonS3StorageProfile' => 'Kaltura\Client\Type\AmazonS3StorageProfile',
		'KalturaAnnotationListResponse' => 'Kaltura\Client\Plugin\Annotation\Type\AnnotationListResponse',
		'KalturaAnswerCuePoint' => 'Kaltura\Client\Plugin\Quiz\Type\AnswerCuePoint',
		'KalturaApiActionPermissionItem' => 'Kaltura\Client\Type\ApiActionPermissionItem',
		'KalturaApiParameterPermissionItem' => 'Kaltura\Client\Type\ApiParameterPermissionItem',
		'KalturaAppTokenBaseFilter' => 'Kaltura\Client\Type\AppTokenBaseFilter',
		'KalturaAppTokenListResponse' => 'Kaltura\Client\Type\AppTokenListResponse',
		'KalturaAssetDistributionPropertyCondition' => 'Kaltura\Client\Plugin\ContentDistribution\Type\AssetDistributionPropertyCondition',
		'KalturaAssetParamsOutput' => 'Kaltura\Client\Type\AssetParamsOutput',
		'KalturaAssetPropertiesCompareCondition' => 'Kaltura\Client\Type\AssetPropertiesCompareCondition',
		'KalturaAssetsParamsResourceContainers' => 'Kaltura\Client\Type\AssetsParamsResourceContainers',
		'KalturaAttachmentAssetListResponse' => 'Kaltura\Client\Plugin\Attachment\Type\AttachmentAssetListResponse',
		'KalturaAttachmentServeOptions' => 'Kaltura\Client\Plugin\Attachment\Type\AttachmentServeOptions',
		'KalturaAttributeCondition' => 'Kaltura\Client\Type\AttributeCondition',
		'KalturaAuthenticatedCondition' => 'Kaltura\Client\Type\AuthenticatedCondition',
		'KalturaBaseEntryCloneOptionComponent' => 'Kaltura\Client\Type\BaseEntryCloneOptionComponent',
		'KalturaBaseEntryListResponse' => 'Kaltura\Client\Type\BaseEntryListResponse',
		'KalturaBaseSyndicationFeedBaseFilter' => 'Kaltura\Client\Type\BaseSyndicationFeedBaseFilter',
		'KalturaBaseSyndicationFeedListResponse' => 'Kaltura\Client\Type\BaseSyndicationFeedListResponse',
		'KalturaBulkDownloadJobData' => 'Kaltura\Client\Type\BulkDownloadJobData',
		'KalturaBulkServiceFilterData' => 'Kaltura\Client\Plugin\BulkUploadFilter\Type\BulkServiceFilterData',
		'KalturaBulkUploadBaseFilter' => 'Kaltura\Client\Type\BulkUploadBaseFilter',
		'KalturaBulkUploadCategoryData' => 'Kaltura\Client\Type\BulkUploadCategoryData',
		'KalturaBulkUploadCategoryEntryData' => 'Kaltura\Client\Type\BulkUploadCategoryEntryData',
		'KalturaBulkUploadCategoryUserData' => 'Kaltura\Client\Type\BulkUploadCategoryUserData',
		'KalturaBulkUploadEntryData' => 'Kaltura\Client\Type\BulkUploadEntryData',
		'KalturaBulkUploadJobData' => 'Kaltura\Client\Type\BulkUploadJobData',
		'KalturaBulkUploadListResponse' => 'Kaltura\Client\Type\BulkUploadListResponse',
		'KalturaBulkUploadResultCategory' => 'Kaltura\Client\Type\BulkUploadResultCategory',
		'KalturaBulkUploadResultCategoryEntry' => 'Kaltura\Client\Type\BulkUploadResultCategoryEntry',
		'KalturaBulkUploadResultCategoryUser' => 'Kaltura\Client\Type\BulkUploadResultCategoryUser',
		'KalturaBulkUploadResultEntry' => 'Kaltura\Client\Type\BulkUploadResultEntry',
		'KalturaBulkUploadResultScheduleEvent' => 'Kaltura\Client\Plugin\ScheduleBulkUpload\Type\BulkUploadResultScheduleEvent',
		'KalturaBulkUploadResultScheduleResource' => 'Kaltura\Client\Plugin\ScheduleBulkUpload\Type\BulkUploadResultScheduleResource',
		'KalturaBulkUploadResultUser' => 'Kaltura\Client\Type\BulkUploadResultUser',
		'KalturaBulkUploadUserData' => 'Kaltura\Client\Type\BulkUploadUserData',
		'KalturaCameraScheduleResource' => 'Kaltura\Client\Plugin\Schedule\Type\CameraScheduleResource',
		'KalturaCaptionAssetItemListResponse' => 'Kaltura\Client\Plugin\CaptionSearch\Type\CaptionAssetItemListResponse',
		'KalturaCaptionAssetListResponse' => 'Kaltura\Client\Plugin\Caption\Type\CaptionAssetListResponse',
		'KalturaCaptionParamsListResponse' => 'Kaltura\Client\Plugin\Caption\Type\CaptionParamsListResponse',
		'KalturaCaptureThumbJobData' => 'Kaltura\Client\Type\CaptureThumbJobData',
		'KalturaCategoryEntryAdvancedFilter' => 'Kaltura\Client\Type\CategoryEntryAdvancedFilter',
		'KalturaCategoryEntryListResponse' => 'Kaltura\Client\Type\CategoryEntryListResponse',
		'KalturaCategoryIdentifier' => 'Kaltura\Client\Type\CategoryIdentifier',
		'KalturaCategoryListResponse' => 'Kaltura\Client\Type\CategoryListResponse',
		'KalturaCategoryUserAdvancedFilter' => 'Kaltura\Client\Type\CategoryUserAdvancedFilter',
		'KalturaCategoryUserListResponse' => 'Kaltura\Client\Type\CategoryUserListResponse',
		'KalturaCategoryUserProviderFilter' => 'Kaltura\Client\Plugin\EmailNotification\Type\CategoryUserProviderFilter',
		'KalturaCielo24JobProviderData' => 'Kaltura\Client\Plugin\Cielo24\Type\Cielo24JobProviderData',
		'KalturaClipAttributes' => 'Kaltura\Client\Type\ClipAttributes',
		'KalturaCodeCuePoint' => 'Kaltura\Client\Plugin\CodeCuePoint\Type\CodeCuePoint',
		'KalturaCompareCondition' => 'Kaltura\Client\Type\CompareCondition',
		'KalturaDataCenterContentResource' => 'Kaltura\Client\Type\DataCenterContentResource',
		'KalturaConcatAttributes' => 'Kaltura\Client\Type\ConcatAttributes',
		'KalturaConcatJobData' => 'Kaltura\Client\Type\ConcatJobData',
		'KalturaConfigurableDistributionJobProviderData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\ConfigurableDistributionJobProviderData',
		'KalturaConfigurableDistributionProfile' => 'Kaltura\Client\Plugin\ContentDistribution\Type\ConfigurableDistributionProfile',
		'KalturaContentDistributionSearchItem' => 'Kaltura\Client\Plugin\ContentDistribution\Type\ContentDistributionSearchItem',
		'KalturaControlPanelCommandBaseFilter' => 'Kaltura\Client\Type\ControlPanelCommandBaseFilter',
		'KalturaControlPanelCommandListResponse' => 'Kaltura\Client\Type\ControlPanelCommandListResponse',
		'KalturaConvartableJobData' => 'Kaltura\Client\Type\ConvartableJobData',
		'KalturaConversionProfileAssetParamsListResponse' => 'Kaltura\Client\Type\ConversionProfileAssetParamsListResponse',
		'KalturaConversionProfileListResponse' => 'Kaltura\Client\Type\ConversionProfileListResponse',
		'KalturaConvertEntryFlavorsObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ConvertEntryFlavorsObjectTask',
		'KalturaConvertLiveSegmentJobData' => 'Kaltura\Client\Type\ConvertLiveSegmentJobData',
		'KalturaConvertProfileJobData' => 'Kaltura\Client\Type\ConvertProfileJobData',
		'KalturaCopyJobData' => 'Kaltura\Client\Type\CopyJobData',
		'KalturaCopyPartnerJobData' => 'Kaltura\Client\Type\CopyPartnerJobData',
		'KalturaCountryRestriction' => 'Kaltura\Client\Type\CountryRestriction',
		'KalturaCuePointListResponse' => 'Kaltura\Client\Plugin\CuePoint\Type\CuePointListResponse',
		'KalturaDataListResponse' => 'Kaltura\Client\Type\DataListResponse',
		'KalturaDeleteEntryFlavorsObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\DeleteEntryFlavorsObjectTask',
		'KalturaDeleteEntryObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\DeleteEntryObjectTask',
		'KalturaDeleteFileJobData' => 'Kaltura\Client\Type\DeleteFileJobData',
		'KalturaDeleteJobData' => 'Kaltura\Client\Type\DeleteJobData',
		'KalturaDeleteLocalContentObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\DeleteLocalContentObjectTask',
		'KalturaDeliveryProfileAkamaiAppleHttpManifest' => 'Kaltura\Client\Type\DeliveryProfileAkamaiAppleHttpManifest',
		'KalturaDeliveryProfileAkamaiHds' => 'Kaltura\Client\Type\DeliveryProfileAkamaiHds',
		'KalturaDeliveryProfileAkamaiHttp' => 'Kaltura\Client\Type\DeliveryProfileAkamaiHttp',
		'KalturaDeliveryProfileBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileBaseFilter',
		'KalturaDeliveryProfileCondition' => 'Kaltura\Client\Type\DeliveryProfileCondition',
		'KalturaDeliveryProfileGenericAppleHttp' => 'Kaltura\Client\Type\DeliveryProfileGenericAppleHttp',
		'KalturaDeliveryProfileGenericHds' => 'Kaltura\Client\Type\DeliveryProfileGenericHds',
		'KalturaDeliveryProfileGenericHttp' => 'Kaltura\Client\Type\DeliveryProfileGenericHttp',
		'KalturaDeliveryProfileGenericSilverLight' => 'Kaltura\Client\Type\DeliveryProfileGenericSilverLight',
		'KalturaDeliveryProfileListResponse' => 'Kaltura\Client\Type\DeliveryProfileListResponse',
		'KalturaDeliveryProfileLiveAppleHttp' => 'Kaltura\Client\Type\DeliveryProfileLiveAppleHttp',
		'KalturaDeliveryProfileRtmp' => 'Kaltura\Client\Type\DeliveryProfileRtmp',
		'KalturaDeliveryProfileVodPackagerPlayServer' => 'Kaltura\Client\Type\DeliveryProfileVodPackagerPlayServer',
		'KalturaDeliveryServerNode' => 'Kaltura\Client\Type\DeliveryServerNode',
		'KalturaDirectoryRestriction' => 'Kaltura\Client\Type\DirectoryRestriction',
		'KalturaDispatchEventNotificationObjectTask' => 'Kaltura\Client\Plugin\ScheduledTaskEventNotification\Type\DispatchEventNotificationObjectTask',
		'KalturaDistributeObjectTask' => 'Kaltura\Client\Plugin\ScheduledTaskContentDistribution\Type\DistributeObjectTask',
		'KalturaDistributionJobData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionJobData',
		'KalturaDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionProfileBaseFilter',
		'KalturaDistributionProfileListResponse' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionProfileListResponse',
		'KalturaDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionProviderBaseFilter',
		'KalturaDistributionProviderListResponse' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionProviderListResponse',
		'KalturaDistributionValidationErrorConditionNotMet' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionValidationErrorConditionNotMet',
		'KalturaDistributionValidationErrorInvalidData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionValidationErrorInvalidData',
		'KalturaDistributionValidationErrorMissingAsset' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionValidationErrorMissingAsset',
		'KalturaDistributionValidationErrorMissingFlavor' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionValidationErrorMissingFlavor',
		'KalturaDistributionValidationErrorMissingMetadata' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionValidationErrorMissingMetadata',
		'KalturaDistributionValidationErrorMissingThumbnail' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionValidationErrorMissingThumbnail',
		'KalturaDocumentListResponse' => 'Kaltura\Client\Plugin\Document\Type\DocumentListResponse',
		'KalturaDrmEntryContextPluginData' => 'Kaltura\Client\Type\DrmEntryContextPluginData',
		'KalturaDropFolderBaseFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderBaseFilter',
		'KalturaDropFolderContentFileHandlerConfig' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderContentFileHandlerConfig',
		'KalturaDropFolderContentProcessorJobData' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderContentProcessorJobData',
		'KalturaDropFolderFileBaseFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderFileBaseFilter',
		'KalturaDropFolderFileListResponse' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderFileListResponse',
		'KalturaDropFolderICalBulkUploadFileHandlerConfig' => 'Kaltura\Client\Plugin\ScheduleDropFolder\Type\DropFolderICalBulkUploadFileHandlerConfig',
		'KalturaDropFolderListResponse' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderListResponse',
		'KalturaDropFolderXmlBulkUploadFileHandlerConfig' => 'Kaltura\Client\Plugin\DropFolderXmlBulkUpload\Type\DropFolderXmlBulkUploadFileHandlerConfig',
		'KalturaCategoryUserBaseFilter' => 'Kaltura\Client\Type\CategoryUserBaseFilter',
		'KalturaCategoryUserFilter' => 'Kaltura\Client\Type\CategoryUserFilter',
		'KalturaEmailNotificationCategoryRecipientJobData' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationCategoryRecipientJobData',
		'KalturaEmailNotificationCategoryRecipientProvider' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationCategoryRecipientProvider',
		'KalturaEmailNotificationParameter' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationParameter',
		'KalturaEmailNotificationStaticRecipientJobData' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationStaticRecipientJobData',
		'KalturaEmailNotificationStaticRecipientProvider' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationStaticRecipientProvider',
		'KalturaEmailNotificationTemplate' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationTemplate',
		'KalturaUserBaseFilter' => 'Kaltura\Client\Type\UserBaseFilter',
		'KalturaUserFilter' => 'Kaltura\Client\Type\UserFilter',
		'KalturaEmailNotificationUserRecipientJobData' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationUserRecipientJobData',
		'KalturaEmailNotificationUserRecipientProvider' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationUserRecipientProvider',
		'KalturaEntryCaptionAssetSearchItem' => 'Kaltura\Client\Plugin\CaptionSearch\Type\EntryCaptionAssetSearchItem',
		'KalturaEntryContext' => 'Kaltura\Client\Type\EntryContext',
		'KalturaEntryContextDataParams' => 'Kaltura\Client\Type\EntryContextDataParams',
		'KalturaEntryContextDataResult' => 'Kaltura\Client\Type\EntryContextDataResult',
		'KalturaEntryCuePointSearchFilter' => 'Kaltura\Client\Type\EntryCuePointSearchFilter',
		'KalturaEntryDistributionListResponse' => 'Kaltura\Client\Plugin\ContentDistribution\Type\EntryDistributionListResponse',
		'KalturaEntryIdentifier' => 'Kaltura\Client\Type\EntryIdentifier',
		'KalturaEntryLiveStats' => 'Kaltura\Client\Type\EntryLiveStats',
		'KalturaEntryScheduleEvent' => 'Kaltura\Client\Plugin\Schedule\Type\EntryScheduleEvent',
		'KalturaEntryServerNodeBaseFilter' => 'Kaltura\Client\Type\EntryServerNodeBaseFilter',
		'KalturaEntryServerNodeListResponse' => 'Kaltura\Client\Type\EntryServerNodeListResponse',
		'KalturaEntryTranscriptAssetSearchItem' => 'Kaltura\Client\Plugin\Transcript\Type\EntryTranscriptAssetSearchItem',
		'KalturaEventCuePoint' => 'Kaltura\Client\Plugin\EventCuePoint\Type\EventCuePoint',
		'KalturaBooleanField' => 'Kaltura\Client\Type\BooleanField',
		'KalturaEventFieldCondition' => 'Kaltura\Client\Plugin\EventNotification\Type\EventFieldCondition',
		'KalturaEventNotificationArrayParameter' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationArrayParameter',
		'KalturaEventNotificationDispatchJobData' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationDispatchJobData',
		'KalturaEventNotificationScope' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationScope',
		'KalturaEventNotificationTemplateBaseFilter' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationTemplateBaseFilter',
		'KalturaEventNotificationTemplateListResponse' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationTemplateListResponse',
		'KalturaEventObjectChangedCondition' => 'Kaltura\Client\Plugin\EventNotification\Type\EventObjectChangedCondition',
		'KalturaExecuteMetadataXsltObjectTask' => 'Kaltura\Client\Plugin\ScheduledTaskMetadata\Type\ExecuteMetadataXsltObjectTask',
		'KalturaExternalMediaEntryListResponse' => 'Kaltura\Client\Plugin\ExternalMedia\Type\ExternalMediaEntryListResponse',
		'KalturaFacebookDistributionProvider' => 'Kaltura\Client\Plugin\FacebookDistribution\Type\FacebookDistributionProvider',
		'KalturaFeatureStatusListResponse' => 'Kaltura\Client\Type\FeatureStatusListResponse',
		'KalturaFeedDropFolder' => 'Kaltura\Client\Plugin\FeedDropFolder\Type\FeedDropFolder',
		'KalturaFeedDropFolderFile' => 'Kaltura\Client\Plugin\FeedDropFolder\Type\FeedDropFolderFile',
		'KalturaFileAssetListResponse' => 'Kaltura\Client\Type\FileAssetListResponse',
		'KalturaFileSyncBaseFilter' => 'Kaltura\Client\Plugin\FileSync\Type\FileSyncBaseFilter',
		'KalturaFlattenJobData' => 'Kaltura\Client\Type\FlattenJobData',
		'KalturaFlavorAssetListResponse' => 'Kaltura\Client\Type\FlavorAssetListResponse',
		'KalturaFlavorParamsListResponse' => 'Kaltura\Client\Type\FlavorParamsListResponse',
		'KalturaGenericDistributionJobProviderData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionJobProviderData',
		'KalturaGenericDistributionProfile' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProfile',
		'KalturaGenericDistributionProviderActionBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProviderActionBaseFilter',
		'KalturaGenericDistributionProviderActionListResponse' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProviderActionListResponse',
		'KalturaGenericDistributionProviderListResponse' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProviderListResponse',
		'KalturaGenericSyndicationFeed' => 'Kaltura\Client\Type\GenericSyndicationFeed',
		'KalturaGoogleVideoSyndicationFeed' => 'Kaltura\Client\Type\GoogleVideoSyndicationFeed',
		'KalturaGroupUserListResponse' => 'Kaltura\Client\Type\GroupUserListResponse',
		'KalturaHashCondition' => 'Kaltura\Client\Type\HashCondition',
		'KalturaHttpNotificationDataFields' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotificationDataFields',
		'KalturaHttpNotificationDataText' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotificationDataText',
		'KalturaHttpNotificationObjectData' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotificationObjectData',
		'KalturaHttpNotificationTemplate' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotificationTemplate',
		'KalturaITunesSyndicationFeed' => 'Kaltura\Client\Type\ITunesSyndicationFeed',
		'KalturaIdeticDistributionProvider' => 'Kaltura\Client\Plugin\IdeticDistribution\Type\IdeticDistributionProvider',
		'KalturaImportJobData' => 'Kaltura\Client\Type\ImportJobData',
		'KalturaImportMetadataJobData' => 'Kaltura\Client\Plugin\Metadata\Type\ImportMetadataJobData',
		'KalturaIndexAdvancedFilter' => 'Kaltura\Client\Type\IndexAdvancedFilter',
		'KalturaIndexJobData' => 'Kaltura\Client\Type\IndexJobData',
		'KalturaIndexTagsByPrivacyContextJobData' => 'Kaltura\Client\Plugin\TagSearch\Type\IndexTagsByPrivacyContextJobData',
		'KalturaIntegrationJobData' => 'Kaltura\Client\Plugin\Integration\Type\IntegrationJobData',
		'KalturaIpAddressRestriction' => 'Kaltura\Client\Type\IpAddressRestriction',
		'KalturaKontikiStorageProfile' => 'Kaltura\Client\Plugin\Kontiki\Type\KontikiStorageProfile',
		'KalturaLikeListResponse' => 'Kaltura\Client\Plugin\Like\Type\LikeListResponse',
		'KalturaLimitFlavorsRestriction' => 'Kaltura\Client\Type\LimitFlavorsRestriction',
		'KalturaLiveChannelListResponse' => 'Kaltura\Client\Type\LiveChannelListResponse',
		'KalturaLiveChannelSegmentListResponse' => 'Kaltura\Client\Type\LiveChannelSegmentListResponse',
		'KalturaLiveEntryScheduleResource' => 'Kaltura\Client\Plugin\Schedule\Type\LiveEntryScheduleResource',
		'KalturaLiveEntryServerNode' => 'Kaltura\Client\Type\LiveEntryServerNode',
		'KalturaLiveReportExportJobData' => 'Kaltura\Client\Type\LiveReportExportJobData',
		'KalturaLiveStatsListResponse' => 'Kaltura\Client\Type\LiveStatsListResponse',
		'KalturaLiveStreamListResponse' => 'Kaltura\Client\Type\LiveStreamListResponse',
		'KalturaLiveStreamPushPublishRTMPConfiguration' => 'Kaltura\Client\Type\LiveStreamPushPublishRTMPConfiguration',
		'KalturaLiveToVodJobData' => 'Kaltura\Client\Type\LiveToVodJobData',
		'KalturaLocationScheduleResource' => 'Kaltura\Client\Plugin\Schedule\Type\LocationScheduleResource',
		'KalturaMailJobData' => 'Kaltura\Client\Type\MailJobData',
		'KalturaMailNotificationObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\MailNotificationObjectTask',
		'KalturaMatchCondition' => 'Kaltura\Client\Type\MatchCondition',
		'KalturaMediaInfoBaseFilter' => 'Kaltura\Client\Type\MediaInfoBaseFilter',
		'KalturaMediaListResponse' => 'Kaltura\Client\Type\MediaListResponse',
		'KalturaMetadataListResponse' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataListResponse',
		'KalturaMetadataProfileBaseFilter' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataProfileBaseFilter',
		'KalturaMetadataProfileFieldListResponse' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataProfileFieldListResponse',
		'KalturaMetadataProfileListResponse' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataProfileListResponse',
		'KalturaMetadataReplacementOptionsItem' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataReplacementOptionsItem',
		'KalturaMetadataResponseProfileMapping' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataResponseProfileMapping',
		'KalturaMixListResponse' => 'Kaltura\Client\Type\MixListResponse',
		'KalturaModerationFlagListResponse' => 'Kaltura\Client\Type\ModerationFlagListResponse',
		'KalturaModifyCategoriesObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ModifyCategoriesObjectTask',
		'KalturaModifyEntryObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ModifyEntryObjectTask',
		'KalturaMoveCategoryEntriesJobData' => 'Kaltura\Client\Type\MoveCategoryEntriesJobData',
		'KalturaNotificationJobData' => 'Kaltura\Client\Type\NotificationJobData',
		'KalturaObjectListResponse' => 'Kaltura\Client\Type\ObjectListResponse',
		'KalturaOrCondition' => 'Kaltura\Client\Type\OrCondition',
		'KalturaParseCaptionAssetJobData' => 'Kaltura\Client\Plugin\VirusScan\Type\ParseCaptionAssetJobData',
		'KalturaParseMultiLanguageCaptionAssetJobData' => 'Kaltura\Client\Plugin\Caption\Type\ParseMultiLanguageCaptionAssetJobData',
		'KalturaPartnerBaseFilter' => 'Kaltura\Client\Type\PartnerBaseFilter',
		'KalturaPartnerListResponse' => 'Kaltura\Client\Type\PartnerListResponse',
		'KalturaPartnerUsageListResponse' => 'Kaltura\Client\Plugin\VarConsole\Type\PartnerUsageListResponse',
		'KalturaPermissionItemListResponse' => 'Kaltura\Client\Type\PermissionItemListResponse',
		'KalturaPermissionListResponse' => 'Kaltura\Client\Type\PermissionListResponse',
		'KalturaPlaylistListResponse' => 'Kaltura\Client\Type\PlaylistListResponse',
		'KalturaProvisionJobData' => 'Kaltura\Client\Type\ProvisionJobData',
		'KalturaQuestionCuePoint' => 'Kaltura\Client\Plugin\Quiz\Type\QuestionCuePoint',
		'KalturaQuizAdvancedFilter' => 'Kaltura\Client\Plugin\Quiz\Type\QuizAdvancedFilter',
		'KalturaQuizListResponse' => 'Kaltura\Client\Plugin\Quiz\Type\QuizListResponse',
		'KalturaQuizUserEntry' => 'Kaltura\Client\Type\QuizUserEntry',
		'KalturaRecalculateCacheJobData' => 'Kaltura\Client\Type\RecalculateCacheJobData',
		'KalturaRemoteDropFolder' => 'Kaltura\Client\Plugin\DropFolder\Type\RemoteDropFolder',
		'KalturaRemotePathListResponse' => 'Kaltura\Client\Type\RemotePathListResponse',
		'KalturaReportBaseFilter' => 'Kaltura\Client\Type\ReportBaseFilter',
		'KalturaReportInputFilter' => 'Kaltura\Client\Type\ReportInputFilter',
		'KalturaReportListResponse' => 'Kaltura\Client\Type\ReportListResponse',
		'KalturaResponseProfileBaseFilter' => 'Kaltura\Client\Type\ResponseProfileBaseFilter',
		'KalturaResponseProfileHolder' => 'Kaltura\Client\Type\ResponseProfileHolder',
		'KalturaResponseProfileListResponse' => 'Kaltura\Client\Type\ResponseProfileListResponse',
		'KalturaScheduleEventListResponse' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEventListResponse',
		'KalturaScheduleEventResourceListResponse' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEventResourceListResponse',
		'KalturaScheduleResourceListResponse' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleResourceListResponse',
		'KalturaScheduledTaskJobData' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ScheduledTaskJobData',
		'KalturaScheduledTaskProfileBaseFilter' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ScheduledTaskProfileBaseFilter',
		'KalturaScheduledTaskProfileListResponse' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ScheduledTaskProfileListResponse',
		'KalturaSchedulerListResponse' => 'Kaltura\Client\Type\SchedulerListResponse',
		'KalturaSchedulerWorkerListResponse' => 'Kaltura\Client\Type\SchedulerWorkerListResponse',
		'KalturaSearchCondition' => 'Kaltura\Client\Type\SearchCondition',
		'KalturaSearchOperator' => 'Kaltura\Client\Type\SearchOperator',
		'KalturaServerNodeBaseFilter' => 'Kaltura\Client\Type\ServerNodeBaseFilter',
		'KalturaServerNodeListResponse' => 'Kaltura\Client\Type\ServerNodeListResponse',
		'KalturaSessionRestriction' => 'Kaltura\Client\Type\SessionRestriction',
		'KalturaShortLinkBaseFilter' => 'Kaltura\Client\Plugin\ShortLink\Type\ShortLinkBaseFilter',
		'KalturaShortLinkListResponse' => 'Kaltura\Client\Plugin\ShortLink\Type\ShortLinkListResponse',
		'KalturaSiteRestriction' => 'Kaltura\Client\Type\SiteRestriction',
		'KalturaStorageAddAction' => 'Kaltura\Client\Type\StorageAddAction',
		'KalturaStorageExportObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\StorageExportObjectTask',
		'KalturaStorageJobData' => 'Kaltura\Client\Type\StorageJobData',
		'KalturaStorageProfileBaseFilter' => 'Kaltura\Client\Type\StorageProfileBaseFilter',
		'KalturaStorageProfileListResponse' => 'Kaltura\Client\Type\StorageProfileListResponse',
		'KalturaSyncCategoryPrivacyContextJobData' => 'Kaltura\Client\Type\SyncCategoryPrivacyContextJobData',
		'KalturaSyndicationDistributionProfile' => 'Kaltura\Client\Plugin\ContentDistribution\Type\SyndicationDistributionProfile',
		'KalturaSyndicationDistributionProvider' => 'Kaltura\Client\Plugin\ContentDistribution\Type\SyndicationDistributionProvider',
		'KalturaSystemPartnerOveragedLimit' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerOveragedLimit',
		'KalturaSystemPartnerUsageFilter' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerUsageFilter',
		'KalturaSystemPartnerUsageListResponse' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerUsageListResponse',
		'KalturaTagFilter' => 'Kaltura\Client\Plugin\TagSearch\Type\TagFilter',
		'KalturaTagListResponse' => 'Kaltura\Client\Plugin\TagSearch\Type\TagListResponse',
		'KalturaThumbAssetListResponse' => 'Kaltura\Client\Type\ThumbAssetListResponse',
		'KalturaThumbCuePoint' => 'Kaltura\Client\Plugin\ThumbCuePoint\Type\ThumbCuePoint',
		'KalturaThumbParamsListResponse' => 'Kaltura\Client\Type\ThumbParamsListResponse',
		'KalturaThumbnailServeOptions' => 'Kaltura\Client\Type\ThumbnailServeOptions',
		'KalturaTrackEntryListResponse' => 'Kaltura\Client\Plugin\AdminConsole\Type\TrackEntryListResponse',
		'KalturaTranscriptAssetListResponse' => 'Kaltura\Client\Plugin\Transcript\Type\TranscriptAssetListResponse',
		'KalturaTransformMetadataJobData' => 'Kaltura\Client\Plugin\Metadata\Type\TransformMetadataJobData',
		'KalturaTubeMogulSyndicationFeed' => 'Kaltura\Client\Type\TubeMogulSyndicationFeed',
		'KalturaUiConfAdminListResponse' => 'Kaltura\Client\Plugin\AdminConsole\Type\UiConfAdminListResponse',
		'KalturaUiConfBaseFilter' => 'Kaltura\Client\Type\UiConfBaseFilter',
		'KalturaUiConfListResponse' => 'Kaltura\Client\Type\UiConfListResponse',
		'KalturaUploadTokenBaseFilter' => 'Kaltura\Client\Type\UploadTokenBaseFilter',
		'KalturaUploadTokenListResponse' => 'Kaltura\Client\Type\UploadTokenListResponse',
		'KalturaUrlRecognizerAkamaiG2O' => 'Kaltura\Client\Type\UrlRecognizerAkamaiG2O',
		'KalturaUrlTokenizerAkamaiHttp' => 'Kaltura\Client\Type\UrlTokenizerAkamaiHttp',
		'KalturaUrlTokenizerAkamaiRtmp' => 'Kaltura\Client\Type\UrlTokenizerAkamaiRtmp',
		'KalturaUrlTokenizerAkamaiRtsp' => 'Kaltura\Client\Type\UrlTokenizerAkamaiRtsp',
		'KalturaUrlTokenizerAkamaiSecureHd' => 'Kaltura\Client\Type\UrlTokenizerAkamaiSecureHd',
		'KalturaUrlTokenizerBitGravity' => 'Kaltura\Client\Type\UrlTokenizerBitGravity',
		'KalturaUrlTokenizerChinaCache' => 'Kaltura\Client\Type\UrlTokenizerChinaCache',
		'KalturaUrlTokenizerCht' => 'Kaltura\Client\Type\UrlTokenizerCht',
		'KalturaUrlTokenizerCloudFront' => 'Kaltura\Client\Type\UrlTokenizerCloudFront',
		'KalturaUrlTokenizerKs' => 'Kaltura\Client\Type\UrlTokenizerKs',
		'KalturaUrlTokenizerLevel3' => 'Kaltura\Client\Type\UrlTokenizerLevel3',
		'KalturaUrlTokenizerLimeLight' => 'Kaltura\Client\Type\UrlTokenizerLimeLight',
		'KalturaUrlTokenizerVelocix' => 'Kaltura\Client\Type\UrlTokenizerVelocix',
		'KalturaUrlTokenizerVnpt' => 'Kaltura\Client\Type\UrlTokenizerVnpt',
		'KalturaUserAgentRestriction' => 'Kaltura\Client\Type\UserAgentRestriction',
		'KalturaUserEntryListResponse' => 'Kaltura\Client\Type\UserEntryListResponse',
		'KalturaUserListResponse' => 'Kaltura\Client\Type\UserListResponse',
		'KalturaUserLoginDataListResponse' => 'Kaltura\Client\Type\UserLoginDataListResponse',
		'KalturaUserRoleCondition' => 'Kaltura\Client\Type\UserRoleCondition',
		'KalturaUserRoleListResponse' => 'Kaltura\Client\Type\UserRoleListResponse',
		'KalturaValidateActiveEdgeCondition' => 'Kaltura\Client\Type\ValidateActiveEdgeCondition',
		'KalturaVarPartnerUsageTotalItem' => 'Kaltura\Client\Plugin\VarConsole\Type\VarPartnerUsageTotalItem',
		'KalturaViewHistoryUserEntry' => 'Kaltura\Client\Plugin\ViewHistory\Type\ViewHistoryUserEntry',
		'KalturaViewHistoryUserEntryAdvancedFilter' => 'Kaltura\Client\Plugin\ViewHistory\Type\ViewHistoryUserEntryAdvancedFilter',
		'KalturaVirusScanJobData' => 'Kaltura\Client\Plugin\VirusScan\Type\VirusScanJobData',
		'KalturaVirusScanProfileBaseFilter' => 'Kaltura\Client\Plugin\VirusScan\Type\VirusScanProfileBaseFilter',
		'KalturaVirusScanProfileListResponse' => 'Kaltura\Client\Plugin\VirusScan\Type\VirusScanProfileListResponse',
		'KalturaVoicebaseJobProviderData' => 'Kaltura\Client\Plugin\Voicebase\Type\VoicebaseJobProviderData',
		'KalturaWidgetBaseFilter' => 'Kaltura\Client\Type\WidgetBaseFilter',
		'KalturaWidgetListResponse' => 'Kaltura\Client\Type\WidgetListResponse',
		'KalturaYahooSyndicationFeed' => 'Kaltura\Client\Type\YahooSyndicationFeed',
		'KalturaYoutubeApiDistributionProvider' => 'Kaltura\Client\Plugin\YoutubeApiDistribution\Type\YoutubeApiDistributionProvider',
		'KalturaAccessControlBaseFilter' => 'Kaltura\Client\Type\AccessControlBaseFilter',
		'KalturaAccessControlProfileBaseFilter' => 'Kaltura\Client\Type\AccessControlProfileBaseFilter',
		'KalturaAkamaiProvisionJobData' => 'Kaltura\Client\Type\AkamaiProvisionJobData',
		'KalturaAkamaiUniversalProvisionJobData' => 'Kaltura\Client\Type\AkamaiUniversalProvisionJobData',
		'KalturaAnonymousIPCondition' => 'Kaltura\Client\Type\AnonymousIPCondition',
		'KalturaAppTokenFilter' => 'Kaltura\Client\Type\AppTokenFilter',
		'KalturaAssetParamsBaseFilter' => 'Kaltura\Client\Type\AssetParamsBaseFilter',
		'KalturaAssetResource' => 'Kaltura\Client\Type\AssetResource',
		'KalturaBaseSyndicationFeedFilter' => 'Kaltura\Client\Type\BaseSyndicationFeedFilter',
		'KalturaBulkUploadCsvJobData' => 'Kaltura\Client\Plugin\BulkUploadCsv\Type\BulkUploadCsvJobData',
		'KalturaBulkUploadFilter' => 'Kaltura\Client\Type\BulkUploadFilter',
		'KalturaBulkUploadFilterJobData' => 'Kaltura\Client\Plugin\BulkUploadFilter\Type\BulkUploadFilterJobData',
		'KalturaBulkUploadICalJobData' => 'Kaltura\Client\Plugin\ScheduleBulkUpload\Type\BulkUploadICalJobData',
		'KalturaBulkUploadXmlJobData' => 'Kaltura\Client\Plugin\BulkUploadXml\Type\BulkUploadXmlJobData',
		'KalturaCategoryBaseFilter' => 'Kaltura\Client\Type\CategoryBaseFilter',
		'KalturaCategoryEntryBaseFilter' => 'Kaltura\Client\Type\CategoryEntryBaseFilter',
		'KalturaCompareMetadataCondition' => 'Kaltura\Client\Plugin\Metadata\Type\CompareMetadataCondition',
		'KalturaControlPanelCommandFilter' => 'Kaltura\Client\Type\ControlPanelCommandFilter',
		'KalturaConversionProfileAssetParamsBaseFilter' => 'Kaltura\Client\Type\ConversionProfileAssetParamsBaseFilter',
		'KalturaConversionProfileBaseFilter' => 'Kaltura\Client\Type\ConversionProfileBaseFilter',
		'KalturaConvertCollectionJobData' => 'Kaltura\Client\Type\ConvertCollectionJobData',
		'KalturaConvertJobData' => 'Kaltura\Client\Type\ConvertJobData',
		'KalturaCountryCondition' => 'Kaltura\Client\Type\CountryCondition',
		'KalturaCuePointBaseFilter' => 'Kaltura\Client\Plugin\CuePoint\Type\CuePointBaseFilter',
		'KalturaDeliveryProfileFilter' => 'Kaltura\Client\Type\DeliveryProfileFilter',
		'KalturaDeliveryProfileGenericRtmp' => 'Kaltura\Client\Type\DeliveryProfileGenericRtmp',
		'KalturaDeliveryProfileVodPackagerHls' => 'Kaltura\Client\Type\DeliveryProfileVodPackagerHls',
		'KalturaDistributionDeleteJobData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionDeleteJobData',
		'KalturaDistributionFetchReportJobData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionFetchReportJobData',
		'KalturaDistributionProfileFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionProfileFilter',
		'KalturaDistributionProviderFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionProviderFilter',
		'KalturaDistributionSubmitJobData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionSubmitJobData',
		'KalturaDistributionUpdateJobData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionUpdateJobData',
		'KalturaDistributionValidationErrorInvalidMetadata' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionValidationErrorInvalidMetadata',
		'KalturaDocumentFlavorParams' => 'Kaltura\Client\Plugin\Document\Type\DocumentFlavorParams',
		'KalturaDropFolderFileFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderFileFilter',
		'KalturaDropFolderFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderFilter',
		'KalturaDynamicObjectSearchItem' => 'Kaltura\Client\Plugin\Metadata\Type\DynamicObjectSearchItem',
		'KalturaEdgeServerNode' => 'Kaltura\Client\Type\EdgeServerNode',
		'KalturaEmailNotificationDispatchJobData' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationDispatchJobData',
		'KalturaEndUserReportInputFilter' => 'Kaltura\Client\Type\EndUserReportInputFilter',
		'KalturaEntryDistributionBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\EntryDistributionBaseFilter',
		'KalturaEntryReferrerLiveStats' => 'Kaltura\Client\Type\EntryReferrerLiveStats',
		'KalturaEntryResource' => 'Kaltura\Client\Type\EntryResource',
		'KalturaEntryServerNodeFilter' => 'Kaltura\Client\Type\EntryServerNodeFilter',
		'KalturaEventNotificationTemplateFilter' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationTemplateFilter',
		'KalturaExtractMediaJobData' => 'Kaltura\Client\Type\ExtractMediaJobData',
		'KalturaFacebookDistributionJobProviderData' => 'Kaltura\Client\Plugin\FacebookDistribution\Type\FacebookDistributionJobProviderData',
		'KalturaFacebookDistributionProfile' => 'Kaltura\Client\Plugin\FacebookDistribution\Type\FacebookDistributionProfile',
		'KalturaFairPlayPlaybackPluginData' => 'Kaltura\Client\Type\FairPlayPlaybackPluginData',
		'KalturaIntegerField' => 'Kaltura\Client\Type\IntegerField',
		'KalturaFieldCompareCondition' => 'Kaltura\Client\Type\FieldCompareCondition',
		'KalturaStringField' => 'Kaltura\Client\Type\StringField',
		'KalturaFieldMatchCondition' => 'Kaltura\Client\Type\FieldMatchCondition',
		'KalturaFileAssetBaseFilter' => 'Kaltura\Client\Type\FileAssetBaseFilter',
		'KalturaFileSyncFilter' => 'Kaltura\Client\Plugin\FileSync\Type\FileSyncFilter',
		'KalturaFileSyncResource' => 'Kaltura\Client\Type\FileSyncResource',
		'KalturaFtpDropFolder' => 'Kaltura\Client\Plugin\DropFolder\Type\FtpDropFolder',
		'KalturaGenericDistributionProviderActionFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProviderActionFilter',
		'KalturaGenericXsltSyndicationFeed' => 'Kaltura\Client\Type\GenericXsltSyndicationFeed',
		'KalturaGeoDistanceCondition' => 'Kaltura\Client\Type\GeoDistanceCondition',
		'KalturaGeoTimeLiveStats' => 'Kaltura\Client\Type\GeoTimeLiveStats',
		'KalturaGroupUserBaseFilter' => 'Kaltura\Client\Type\GroupUserBaseFilter',
		'KalturaHttpNotificationDispatchJobData' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotificationDispatchJobData',
		'KalturaIdeticDistributionJobProviderData' => 'Kaltura\Client\Plugin\IdeticDistribution\Type\IdeticDistributionJobProviderData',
		'KalturaIdeticDistributionProfile' => 'Kaltura\Client\Plugin\IdeticDistribution\Type\IdeticDistributionProfile',
		'KalturaImageFlavorParams' => 'Kaltura\Client\Plugin\Document\Type\ImageFlavorParams',
		'KalturaIpAddressCondition' => 'Kaltura\Client\Type\IpAddressCondition',
		'KalturaLikeBaseFilter' => 'Kaltura\Client\Plugin\Like\Type\LikeBaseFilter',
		'KalturaLiveAsset' => 'Kaltura\Client\Type\LiveAsset',
		'KalturaLiveChannelSegmentBaseFilter' => 'Kaltura\Client\Type\LiveChannelSegmentBaseFilter',
		'KalturaLiveParams' => 'Kaltura\Client\Type\LiveParams',
		'KalturaLiveStreamScheduleEvent' => 'Kaltura\Client\Plugin\Schedule\Type\LiveStreamScheduleEvent',
		'KalturaMatchMetadataCondition' => 'Kaltura\Client\Plugin\Metadata\Type\MatchMetadataCondition',
		'KalturaMediaFlavorParams' => 'Kaltura\Client\Type\MediaFlavorParams',
		'KalturaMediaInfoFilter' => 'Kaltura\Client\Type\MediaInfoFilter',
		'KalturaMediaServerNode' => 'Kaltura\Client\Type\MediaServerNode',
		'KalturaMetadataBaseFilter' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataBaseFilter',
		'KalturaMetadataFieldChangedCondition' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataFieldChangedCondition',
		'KalturaMetadataProfileFilter' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataProfileFilter',
		'KalturaMetadataSearchItem' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataSearchItem',
		'KalturaOperationResource' => 'Kaltura\Client\Type\OperationResource',
		'KalturaPartnerFilter' => 'Kaltura\Client\Type\PartnerFilter',
		'KalturaPdfFlavorParams' => 'Kaltura\Client\Plugin\Document\Type\PdfFlavorParams',
		'KalturaPermissionBaseFilter' => 'Kaltura\Client\Type\PermissionBaseFilter',
		'KalturaPermissionItemBaseFilter' => 'Kaltura\Client\Type\PermissionItemBaseFilter',
		'KalturaPlaybackContextOptions' => 'Kaltura\Client\Type\PlaybackContextOptions',
		'KalturaPostConvertJobData' => 'Kaltura\Client\Type\PostConvertJobData',
		'KalturaPreviewRestriction' => 'Kaltura\Client\Type\PreviewRestriction',
		'KalturaQuizFilter' => 'Kaltura\Client\Plugin\Quiz\Type\QuizFilter',
		'KalturaRecalculateResponseProfileCacheJobData' => 'Kaltura\Client\Type\RecalculateResponseProfileCacheJobData',
		'KalturaRecordScheduleEvent' => 'Kaltura\Client\Plugin\Schedule\Type\RecordScheduleEvent',
		'KalturaRegexCondition' => 'Kaltura\Client\Type\RegexCondition',
		'KalturaRemoteStorageResources' => 'Kaltura\Client\Type\RemoteStorageResources',
		'KalturaResponseProfileFilter' => 'Kaltura\Client\Type\ResponseProfileFilter',
		'KalturaScheduleEventBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEventBaseFilter',
		'KalturaScheduleEventResourceBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEventResourceBaseFilter',
		'KalturaScheduleResourceBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleResourceBaseFilter',
		'KalturaScheduledTaskProfileFilter' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ScheduledTaskProfileFilter',
		'KalturaSearchComparableAttributeCondition' => 'Kaltura\Client\Type\SearchComparableAttributeCondition',
		'KalturaSearchComparableCondition' => 'Kaltura\Client\Type\SearchComparableCondition',
		'KalturaSearchMatchAttributeCondition' => 'Kaltura\Client\Type\SearchMatchAttributeCondition',
		'KalturaSearchMatchCondition' => 'Kaltura\Client\Type\SearchMatchCondition',
		'KalturaServerNodeFilter' => 'Kaltura\Client\Type\ServerNodeFilter',
		'KalturaShortLinkFilter' => 'Kaltura\Client\Plugin\ShortLink\Type\ShortLinkFilter',
		'KalturaSiteCondition' => 'Kaltura\Client\Type\SiteCondition',
		'KalturaSshDropFolder' => 'Kaltura\Client\Plugin\DropFolder\Type\SshDropFolder',
		'KalturaSshImportJobData' => 'Kaltura\Client\Type\SshImportJobData',
		'KalturaStorageDeleteJobData' => 'Kaltura\Client\Type\StorageDeleteJobData',
		'KalturaStorageExportJobData' => 'Kaltura\Client\Type\StorageExportJobData',
		'KalturaStorageProfileFilter' => 'Kaltura\Client\Type\StorageProfileFilter',
		'KalturaStringResource' => 'Kaltura\Client\Type\StringResource',
		'KalturaSwfFlavorParams' => 'Kaltura\Client\Plugin\Document\Type\SwfFlavorParams',
		'KalturaTimedThumbAsset' => 'Kaltura\Client\Plugin\ThumbCuePoint\Type\TimedThumbAsset',
		'KalturaUiConfFilter' => 'Kaltura\Client\Type\UiConfFilter',
		'KalturaUploadTokenFilter' => 'Kaltura\Client\Type\UploadTokenFilter',
		'KalturaUserEntryBaseFilter' => 'Kaltura\Client\Type\UserEntryBaseFilter',
		'KalturaUserLoginDataBaseFilter' => 'Kaltura\Client\Type\UserLoginDataBaseFilter',
		'KalturaUserRoleBaseFilter' => 'Kaltura\Client\Type\UserRoleBaseFilter',
		'KalturaVelocixProvisionJobData' => 'Kaltura\Client\Plugin\Velocix\Type\VelocixProvisionJobData',
		'KalturaVirusScanProfileFilter' => 'Kaltura\Client\Plugin\VirusScan\Type\VirusScanProfileFilter',
		'KalturaWidgetFilter' => 'Kaltura\Client\Type\WidgetFilter',
		'KalturaYoutubeApiDistributionJobProviderData' => 'Kaltura\Client\Plugin\YoutubeApiDistribution\Type\YoutubeApiDistributionJobProviderData',
		'KalturaYoutubeApiDistributionProfile' => 'Kaltura\Client\Plugin\YoutubeApiDistribution\Type\YoutubeApiDistributionProfile',
		'KalturaAccessControlFilter' => 'Kaltura\Client\Type\AccessControlFilter',
		'KalturaAccessControlProfileFilter' => 'Kaltura\Client\Type\AccessControlProfileFilter',
		'KalturaAmazonS3StorageExportJobData' => 'Kaltura\Client\Type\AmazonS3StorageExportJobData',
		'KalturaAmazonS3StorageProfileBaseFilter' => 'Kaltura\Client\Type\AmazonS3StorageProfileBaseFilter',
		'KalturaAnonymousIPContextField' => 'Kaltura\Client\Type\AnonymousIPContextField',
		'KalturaAssetParamsFilter' => 'Kaltura\Client\Type\AssetParamsFilter',
		'KalturaBaseEntryCompareAttributeCondition' => 'Kaltura\Client\Type\BaseEntryCompareAttributeCondition',
		'KalturaBaseEntryMatchAttributeCondition' => 'Kaltura\Client\Type\BaseEntryMatchAttributeCondition',
		'KalturaBatchJobFilterExt' => 'Kaltura\Client\Type\BatchJobFilterExt',
		'KalturaCategoryEntryFilter' => 'Kaltura\Client\Type\CategoryEntryFilter',
		'KalturaCategoryFilter' => 'Kaltura\Client\Type\CategoryFilter',
		'KalturaConfigurableDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\ConfigurableDistributionProfileBaseFilter',
		'KalturaConstantXsltSyndicationFeed' => 'Kaltura\Client\Type\ConstantXsltSyndicationFeed',
		'KalturaConversionProfileFilter' => 'Kaltura\Client\Type\ConversionProfileFilter',
		'KalturaConversionProfileAssetParamsFilter' => 'Kaltura\Client\Type\ConversionProfileAssetParamsFilter',
		'KalturaCoordinatesContextField' => 'Kaltura\Client\Type\CoordinatesContextField',
		'KalturaCountryContextField' => 'Kaltura\Client\Type\CountryContextField',
		'KalturaCuePointFilter' => 'Kaltura\Client\Plugin\CuePoint\Type\CuePointFilter',
		'KalturaDataEntryCompareAttributeCondition' => 'Kaltura\Client\Type\DataEntryCompareAttributeCondition',
		'KalturaDataEntryMatchAttributeCondition' => 'Kaltura\Client\Type\DataEntryMatchAttributeCondition',
		'KalturaDeliveryProfileAkamaiAppleHttpManifestBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileAkamaiAppleHttpManifestBaseFilter',
		'KalturaDeliveryProfileAkamaiHdsBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileAkamaiHdsBaseFilter',
		'KalturaDeliveryProfileAkamaiHttpBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileAkamaiHttpBaseFilter',
		'KalturaDeliveryProfileGenericAppleHttpBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericAppleHttpBaseFilter',
		'KalturaDeliveryProfileGenericHdsBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericHdsBaseFilter',
		'KalturaDeliveryProfileGenericHttpBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericHttpBaseFilter',
		'KalturaDeliveryProfileGenericSilverLightBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericSilverLightBaseFilter',
		'KalturaDeliveryProfileLiveAppleHttpBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileLiveAppleHttpBaseFilter',
		'KalturaDeliveryProfileRtmpBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileRtmpBaseFilter',
		'KalturaDeliveryServerNodeBaseFilter' => 'Kaltura\Client\Type\DeliveryServerNodeBaseFilter',
		'KalturaDistributionDisableJobData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionDisableJobData',
		'KalturaDistributionEnableJobData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionEnableJobData',
		'KalturaDocumentEntryCompareAttributeCondition' => 'Kaltura\Client\Type\DocumentEntryCompareAttributeCondition',
		'KalturaDocumentEntryMatchAttributeCondition' => 'Kaltura\Client\Type\DocumentEntryMatchAttributeCondition',
		'KalturaDocumentFlavorParamsOutput' => 'Kaltura\Client\Plugin\Document\Type\DocumentFlavorParamsOutput',
		'KalturaDropFolderFileResource' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderFileResource',
		'KalturaDropFolderImportJobData' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderImportJobData',
		'KalturaEmailNotificationTemplateBaseFilter' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationTemplateBaseFilter',
		'KalturaEntryDistributionFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\EntryDistributionFilter',
		'KalturaEvalBooleanField' => 'Kaltura\Client\Type\EvalBooleanField',
		'KalturaEvalStringField' => 'Kaltura\Client\Type\EvalStringField',
		'KalturaExternalMediaEntryCompareAttributeCondition' => 'Kaltura\Client\Type\ExternalMediaEntryCompareAttributeCondition',
		'KalturaExternalMediaEntryMatchAttributeCondition' => 'Kaltura\Client\Type\ExternalMediaEntryMatchAttributeCondition',
		'KalturaFacebookDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\FacebookDistribution\Type\FacebookDistributionProviderBaseFilter',
		'KalturaFileAssetFilter' => 'Kaltura\Client\Type\FileAssetFilter',
		'KalturaGenericDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProfileBaseFilter',
		'KalturaGenericDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProviderBaseFilter',
		'KalturaGenericSyndicationFeedBaseFilter' => 'Kaltura\Client\Type\GenericSyndicationFeedBaseFilter',
		'KalturaGoogleVideoSyndicationFeedBaseFilter' => 'Kaltura\Client\Type\GoogleVideoSyndicationFeedBaseFilter',
		'KalturaGroupUserFilter' => 'Kaltura\Client\Type\GroupUserFilter',
		'KalturaHttpNotificationTemplateBaseFilter' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotificationTemplateBaseFilter',
		'KalturaITunesSyndicationFeedBaseFilter' => 'Kaltura\Client\Type\ITunesSyndicationFeedBaseFilter',
		'KalturaIdeticDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\IdeticDistribution\Type\IdeticDistributionProviderBaseFilter',
		'KalturaImageFlavorParamsOutput' => 'Kaltura\Client\Plugin\Document\Type\ImageFlavorParamsOutput',
		'KalturaIpAddressContextField' => 'Kaltura\Client\Type\IpAddressContextField',
		'KalturaKontikiStorageDeleteJobData' => 'Kaltura\Client\Plugin\Kontiki\Type\KontikiStorageDeleteJobData',
		'KalturaKontikiStorageExportJobData' => 'Kaltura\Client\Plugin\Kontiki\Type\KontikiStorageExportJobData',
		'KalturaKontikiStorageProfileBaseFilter' => 'Kaltura\Client\Plugin\Kontiki\Type\KontikiStorageProfileBaseFilter',
		'KalturaLikeFilter' => 'Kaltura\Client\Plugin\Like\Type\LikeFilter',
		'KalturaLiveChannelCompareAttributeCondition' => 'Kaltura\Client\Type\LiveChannelCompareAttributeCondition',
		'KalturaLiveChannelMatchAttributeCondition' => 'Kaltura\Client\Type\LiveChannelMatchAttributeCondition',
		'KalturaLiveChannelSegmentFilter' => 'Kaltura\Client\Type\LiveChannelSegmentFilter',
		'KalturaLiveEntryCompareAttributeCondition' => 'Kaltura\Client\Type\LiveEntryCompareAttributeCondition',
		'KalturaLiveEntryMatchAttributeCondition' => 'Kaltura\Client\Type\LiveEntryMatchAttributeCondition',
		'KalturaLiveStreamAdminEntryCompareAttributeCondition' => 'Kaltura\Client\Type\LiveStreamAdminEntryCompareAttributeCondition',
		'KalturaLiveStreamAdminEntryMatchAttributeCondition' => 'Kaltura\Client\Type\LiveStreamAdminEntryMatchAttributeCondition',
		'KalturaLiveStreamEntryCompareAttributeCondition' => 'Kaltura\Client\Type\LiveStreamEntryCompareAttributeCondition',
		'KalturaLiveStreamEntryMatchAttributeCondition' => 'Kaltura\Client\Type\LiveStreamEntryMatchAttributeCondition',
		'KalturaMediaEntryCompareAttributeCondition' => 'Kaltura\Client\Type\MediaEntryCompareAttributeCondition',
		'KalturaMediaEntryMatchAttributeCondition' => 'Kaltura\Client\Type\MediaEntryMatchAttributeCondition',
		'KalturaMediaFlavorParamsOutput' => 'Kaltura\Client\Type\MediaFlavorParamsOutput',
		'KalturaMetadataField' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataField',
		'KalturaMetadataFilter' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataFilter',
		'KalturaMixEntryCompareAttributeCondition' => 'Kaltura\Client\Type\MixEntryCompareAttributeCondition',
		'KalturaMixEntryMatchAttributeCondition' => 'Kaltura\Client\Type\MixEntryMatchAttributeCondition',
		'KalturaObjectIdField' => 'Kaltura\Client\Type\ObjectIdField',
		'KalturaPdfFlavorParamsOutput' => 'Kaltura\Client\Plugin\Document\Type\PdfFlavorParamsOutput',
		'KalturaPermissionFilter' => 'Kaltura\Client\Type\PermissionFilter',
		'KalturaPermissionItemFilter' => 'Kaltura\Client\Type\PermissionItemFilter',
		'KalturaPlayableEntryCompareAttributeCondition' => 'Kaltura\Client\Type\PlayableEntryCompareAttributeCondition',
		'KalturaPlayableEntryMatchAttributeCondition' => 'Kaltura\Client\Type\PlayableEntryMatchAttributeCondition',
		'KalturaPlaylistCompareAttributeCondition' => 'Kaltura\Client\Type\PlaylistCompareAttributeCondition',
		'KalturaPlaylistMatchAttributeCondition' => 'Kaltura\Client\Type\PlaylistMatchAttributeCondition',
		'KalturaRemoteDropFolderBaseFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\RemoteDropFolderBaseFilter',
		'KalturaScheduleEventFilter' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEventFilter',
		'KalturaScheduleEventResourceFilter' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEventResourceFilter',
		'KalturaScheduleResourceFilter' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleResourceFilter',
		'KalturaScpDropFolder' => 'Kaltura\Client\Plugin\DropFolder\Type\ScpDropFolder',
		'KalturaServerFileResource' => 'Kaltura\Client\Type\ServerFileResource',
		'KalturaSftpDropFolder' => 'Kaltura\Client\Plugin\DropFolder\Type\SftpDropFolder',
		'KalturaSshUrlResource' => 'Kaltura\Client\Type\SshUrlResource',
		'KalturaSwfFlavorParamsOutput' => 'Kaltura\Client\Plugin\Document\Type\SwfFlavorParamsOutput',
		'KalturaSyndicationDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\SyndicationDistributionProfileBaseFilter',
		'KalturaSyndicationDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\SyndicationDistributionProviderBaseFilter',
		'KalturaSystemPartnerFilter' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerFilter',
		'KalturaTimeContextField' => 'Kaltura\Client\Type\TimeContextField',
		'KalturaTubeMogulSyndicationFeedBaseFilter' => 'Kaltura\Client\Type\TubeMogulSyndicationFeedBaseFilter',
		'KalturaUiConfAdminBaseFilter' => 'Kaltura\Client\Plugin\AdminConsole\Type\UiConfAdminBaseFilter',
		'KalturaUploadedFileResource' => 'Kaltura\Client\Type\UploadedFileResource',
		'KalturaUploadedFileTokenResource' => 'Kaltura\Client\Type\UploadedFileTokenResource',
		'KalturaUserAgentCondition' => 'Kaltura\Client\Type\UserAgentCondition',
		'KalturaUserAgentContextField' => 'Kaltura\Client\Type\UserAgentContextField',
		'KalturaUserEmailContextField' => 'Kaltura\Client\Type\UserEmailContextField',
		'KalturaUserEntryFilter' => 'Kaltura\Client\Type\UserEntryFilter',
		'KalturaUserLoginDataFilter' => 'Kaltura\Client\Type\UserLoginDataFilter',
		'KalturaUserRoleFilter' => 'Kaltura\Client\Type\UserRoleFilter',
		'KalturaVarConsolePartnerFilter' => 'Kaltura\Client\Plugin\VarConsole\Type\VarConsolePartnerFilter',
		'KalturaWebcamTokenResource' => 'Kaltura\Client\Type\WebcamTokenResource',
		'KalturaWowzaMediaServerNode' => 'Kaltura\Client\Plugin\Wowza\Type\WowzaMediaServerNode',
		'KalturaYahooSyndicationFeedBaseFilter' => 'Kaltura\Client\Type\YahooSyndicationFeedBaseFilter',
		'KalturaYoutubeApiDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\YoutubeApiDistribution\Type\YoutubeApiDistributionProviderBaseFilter',
		'KalturaAdCuePointBaseFilter' => 'Kaltura\Client\Plugin\AdCuePoint\Type\AdCuePointBaseFilter',
		'KalturaAdminUserBaseFilter' => 'Kaltura\Client\Type\AdminUserBaseFilter',
		'KalturaAmazonS3StorageProfileFilter' => 'Kaltura\Client\Type\AmazonS3StorageProfileFilter',
		'KalturaAnnotationBaseFilter' => 'Kaltura\Client\Plugin\Annotation\Type\AnnotationBaseFilter',
		'KalturaAnswerCuePointBaseFilter' => 'Kaltura\Client\Plugin\Quiz\Type\AnswerCuePointBaseFilter',
		'KalturaApiActionPermissionItemBaseFilter' => 'Kaltura\Client\Type\ApiActionPermissionItemBaseFilter',
		'KalturaApiParameterPermissionItemBaseFilter' => 'Kaltura\Client\Type\ApiParameterPermissionItemBaseFilter',
		'KalturaAssetParamsOutputBaseFilter' => 'Kaltura\Client\Type\AssetParamsOutputBaseFilter',
		'KalturaAttachmentAssetBaseFilter' => 'Kaltura\Client\Plugin\Attachment\Type\AttachmentAssetBaseFilter',
		'KalturaCameraScheduleResourceBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\CameraScheduleResourceBaseFilter',
		'KalturaCaptionAssetBaseFilter' => 'Kaltura\Client\Plugin\Caption\Type\CaptionAssetBaseFilter',
		'KalturaCaptionParamsBaseFilter' => 'Kaltura\Client\Plugin\Caption\Type\CaptionParamsBaseFilter',
		'KalturaCodeCuePointBaseFilter' => 'Kaltura\Client\Plugin\CodeCuePoint\Type\CodeCuePointBaseFilter',
		'KalturaConfigurableDistributionProfileFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\ConfigurableDistributionProfileFilter',
		'KalturaDataEntryBaseFilter' => 'Kaltura\Client\Type\DataEntryBaseFilter',
		'KalturaDeliveryProfileAkamaiAppleHttpManifestFilter' => 'Kaltura\Client\Type\DeliveryProfileAkamaiAppleHttpManifestFilter',
		'KalturaDeliveryProfileAkamaiHdsFilter' => 'Kaltura\Client\Type\DeliveryProfileAkamaiHdsFilter',
		'KalturaDeliveryProfileAkamaiHttpFilter' => 'Kaltura\Client\Type\DeliveryProfileAkamaiHttpFilter',
		'KalturaDeliveryProfileGenericAppleHttpFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericAppleHttpFilter',
		'KalturaDeliveryProfileGenericHdsFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericHdsFilter',
		'KalturaDeliveryProfileGenericHttpFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericHttpFilter',
		'KalturaDeliveryProfileGenericSilverLightFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericSilverLightFilter',
		'KalturaDeliveryProfileLiveAppleHttpFilter' => 'Kaltura\Client\Type\DeliveryProfileLiveAppleHttpFilter',
		'KalturaDeliveryProfileRtmpFilter' => 'Kaltura\Client\Type\DeliveryProfileRtmpFilter',
		'KalturaDeliveryServerNodeFilter' => 'Kaltura\Client\Type\DeliveryServerNodeFilter',
		'KalturaDocumentEntryBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\DocumentEntryBaseFilter',
		'KalturaEmailNotificationTemplateFilter' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationTemplateFilter',
		'KalturaEntryScheduleEventBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\EntryScheduleEventBaseFilter',
		'KalturaEventCuePointBaseFilter' => 'Kaltura\Client\Plugin\EventCuePoint\Type\EventCuePointBaseFilter',
		'KalturaFacebookDistributionProviderFilter' => 'Kaltura\Client\Plugin\FacebookDistribution\Type\FacebookDistributionProviderFilter',
		'KalturaFlavorAssetBaseFilter' => 'Kaltura\Client\Type\FlavorAssetBaseFilter',
		'KalturaFlavorParamsBaseFilter' => 'Kaltura\Client\Type\FlavorParamsBaseFilter',
		'KalturaGenericDistributionProfileFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProfileFilter',
		'KalturaGenericDistributionProviderFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProviderFilter',
		'KalturaGenericSyndicationFeedFilter' => 'Kaltura\Client\Type\GenericSyndicationFeedFilter',
		'KalturaGoogleVideoSyndicationFeedFilter' => 'Kaltura\Client\Type\GoogleVideoSyndicationFeedFilter',
		'KalturaHttpNotificationTemplateFilter' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotificationTemplateFilter',
		'KalturaITunesSyndicationFeedFilter' => 'Kaltura\Client\Type\ITunesSyndicationFeedFilter',
		'KalturaIdeticDistributionProviderFilter' => 'Kaltura\Client\Plugin\IdeticDistribution\Type\IdeticDistributionProviderFilter',
		'KalturaKontikiStorageProfileFilter' => 'Kaltura\Client\Plugin\Kontiki\Type\KontikiStorageProfileFilter',
		'KalturaLiveEntryScheduleResourceBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\LiveEntryScheduleResourceBaseFilter',
		'KalturaLocationScheduleResourceBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\LocationScheduleResourceBaseFilter',
		'KalturaOperaSyndicationFeed' => 'Kaltura\Client\Type\OperaSyndicationFeed',
		'KalturaPlaylistBaseFilter' => 'Kaltura\Client\Type\PlaylistBaseFilter',
		'KalturaQuestionCuePointBaseFilter' => 'Kaltura\Client\Plugin\Quiz\Type\QuestionCuePointBaseFilter',
		'KalturaQuizUserEntryBaseFilter' => 'Kaltura\Client\Type\QuizUserEntryBaseFilter',
		'KalturaRemoteDropFolderFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\RemoteDropFolderFilter',
		'KalturaRokuSyndicationFeed' => 'Kaltura\Client\Type\RokuSyndicationFeed',
		'KalturaSyndicationDistributionProfileFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\SyndicationDistributionProfileFilter',
		'KalturaThumbAssetBaseFilter' => 'Kaltura\Client\Type\ThumbAssetBaseFilter',
		'KalturaThumbCuePointBaseFilter' => 'Kaltura\Client\Plugin\ThumbCuePoint\Type\ThumbCuePointBaseFilter',
		'KalturaThumbParamsBaseFilter' => 'Kaltura\Client\Type\ThumbParamsBaseFilter',
		'KalturaTubeMogulSyndicationFeedFilter' => 'Kaltura\Client\Type\TubeMogulSyndicationFeedFilter',
		'KalturaUiConfAdminFilter' => 'Kaltura\Client\Plugin\AdminConsole\Type\UiConfAdminFilter',
		'KalturaViewHistoryUserEntryFilter' => 'Kaltura\Client\Plugin\ViewHistory\Type\ViewHistoryUserEntryFilter',
		'KalturaYahooSyndicationFeedFilter' => 'Kaltura\Client\Type\YahooSyndicationFeedFilter',
		'KalturaYoutubeApiDistributionProviderFilter' => 'Kaltura\Client\Plugin\YoutubeApiDistribution\Type\YoutubeApiDistributionProviderFilter',
		'KalturaAdCuePointFilter' => 'Kaltura\Client\Plugin\AdCuePoint\Type\AdCuePointFilter',
		'KalturaAdminUserFilter' => 'Kaltura\Client\Type\AdminUserFilter',
		'KalturaAnnotationFilter' => 'Kaltura\Client\Plugin\Annotation\Type\AnnotationFilter',
		'KalturaAnswerCuePointFilter' => 'Kaltura\Client\Plugin\Quiz\Type\AnswerCuePointFilter',
		'KalturaApiActionPermissionItemFilter' => 'Kaltura\Client\Type\ApiActionPermissionItemFilter',
		'KalturaApiParameterPermissionItemFilter' => 'Kaltura\Client\Type\ApiParameterPermissionItemFilter',
		'KalturaAssetParamsOutputFilter' => 'Kaltura\Client\Type\AssetParamsOutputFilter',
		'KalturaAttachmentAssetFilter' => 'Kaltura\Client\Plugin\Attachment\Type\AttachmentAssetFilter',
		'KalturaCameraScheduleResourceFilter' => 'Kaltura\Client\Plugin\Schedule\Type\CameraScheduleResourceFilter',
		'KalturaCaptionAssetFilter' => 'Kaltura\Client\Plugin\Caption\Type\CaptionAssetFilter',
		'KalturaCaptionParamsFilter' => 'Kaltura\Client\Plugin\Caption\Type\CaptionParamsFilter',
		'KalturaCodeCuePointFilter' => 'Kaltura\Client\Plugin\CodeCuePoint\Type\CodeCuePointFilter',
		'KalturaDataEntryFilter' => 'Kaltura\Client\Type\DataEntryFilter',
		'KalturaDeliveryProfileGenericRtmpBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericRtmpBaseFilter',
		'KalturaDocumentEntryFilter' => 'Kaltura\Client\Plugin\Document\Type\DocumentEntryFilter',
		'KalturaEdgeServerNodeBaseFilter' => 'Kaltura\Client\Type\EdgeServerNodeBaseFilter',
		'KalturaEntryScheduleEventFilter' => 'Kaltura\Client\Plugin\Schedule\Type\EntryScheduleEventFilter',
		'KalturaEventCuePointFilter' => 'Kaltura\Client\Plugin\EventCuePoint\Type\EventCuePointFilter',
		'KalturaFacebookDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\FacebookDistribution\Type\FacebookDistributionProfileBaseFilter',
		'KalturaFlavorAssetFilter' => 'Kaltura\Client\Type\FlavorAssetFilter',
		'KalturaFlavorParamsFilter' => 'Kaltura\Client\Type\FlavorParamsFilter',
		'KalturaFtpDropFolderBaseFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\FtpDropFolderBaseFilter',
		'KalturaGenericXsltSyndicationFeedBaseFilter' => 'Kaltura\Client\Type\GenericXsltSyndicationFeedBaseFilter',
		'KalturaIdeticDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\IdeticDistribution\Type\IdeticDistributionProfileBaseFilter',
		'KalturaLiveEntryScheduleResourceFilter' => 'Kaltura\Client\Plugin\Schedule\Type\LiveEntryScheduleResourceFilter',
		'KalturaLiveStreamAdminEntry' => 'Kaltura\Client\Type\LiveStreamAdminEntry',
		'KalturaLocationScheduleResourceFilter' => 'Kaltura\Client\Plugin\Schedule\Type\LocationScheduleResourceFilter',
		'KalturaMediaServerNodeBaseFilter' => 'Kaltura\Client\Type\MediaServerNodeBaseFilter',
		'KalturaPlaylistFilter' => 'Kaltura\Client\Type\PlaylistFilter',
		'KalturaQuestionCuePointFilter' => 'Kaltura\Client\Plugin\Quiz\Type\QuestionCuePointFilter',
		'KalturaQuizUserEntryFilter' => 'Kaltura\Client\Plugin\Quiz\Type\QuizUserEntryFilter',
		'KalturaSshDropFolderBaseFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\SshDropFolderBaseFilter',
		'KalturaThumbAssetFilter' => 'Kaltura\Client\Type\ThumbAssetFilter',
		'KalturaThumbCuePointFilter' => 'Kaltura\Client\Plugin\ThumbCuePoint\Type\ThumbCuePointFilter',
		'KalturaThumbParamsFilter' => 'Kaltura\Client\Type\ThumbParamsFilter',
		'KalturaYoutubeApiDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\YoutubeApiDistribution\Type\YoutubeApiDistributionProfileBaseFilter',
		'KalturaCaptionAssetItemFilter' => 'Kaltura\Client\Plugin\CaptionSearch\Type\CaptionAssetItemFilter',
		'KalturaDeliveryProfileGenericRtmpFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericRtmpFilter',
		'KalturaDocumentFlavorParamsBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\DocumentFlavorParamsBaseFilter',
		'KalturaEdgeServerNodeFilter' => 'Kaltura\Client\Type\EdgeServerNodeFilter',
		'KalturaFacebookDistributionProfileFilter' => 'Kaltura\Client\Plugin\FacebookDistribution\Type\FacebookDistributionProfileFilter',
		'KalturaFlavorParamsOutputBaseFilter' => 'Kaltura\Client\Type\FlavorParamsOutputBaseFilter',
		'KalturaFtpDropFolderFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\FtpDropFolderFilter',
		'KalturaGenericXsltSyndicationFeedFilter' => 'Kaltura\Client\Type\GenericXsltSyndicationFeedFilter',
		'KalturaIdeticDistributionProfileFilter' => 'Kaltura\Client\Plugin\IdeticDistribution\Type\IdeticDistributionProfileFilter',
		'KalturaImageFlavorParamsBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\ImageFlavorParamsBaseFilter',
		'KalturaLiveAssetBaseFilter' => 'Kaltura\Client\Type\LiveAssetBaseFilter',
		'KalturaLiveParamsBaseFilter' => 'Kaltura\Client\Type\LiveParamsBaseFilter',
		'KalturaLiveStreamScheduleEventBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\LiveStreamScheduleEventBaseFilter',
		'KalturaMediaFlavorParamsBaseFilter' => 'Kaltura\Client\Type\MediaFlavorParamsBaseFilter',
		'KalturaMediaServerNodeFilter' => 'Kaltura\Client\Type\MediaServerNodeFilter',
		'KalturaMixEntryBaseFilter' => 'Kaltura\Client\Type\MixEntryBaseFilter',
		'KalturaPdfFlavorParamsBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\PdfFlavorParamsBaseFilter',
		'KalturaRecordScheduleEventBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\RecordScheduleEventBaseFilter',
		'KalturaSshDropFolderFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\SshDropFolderFilter',
		'KalturaSwfFlavorParamsBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\SwfFlavorParamsBaseFilter',
		'KalturaThumbParamsOutputBaseFilter' => 'Kaltura\Client\Type\ThumbParamsOutputBaseFilter',
		'KalturaTimedThumbAssetBaseFilter' => 'Kaltura\Client\Plugin\ThumbCuePoint\Type\TimedThumbAssetBaseFilter',
		'KalturaTranscriptAssetBaseFilter' => 'Kaltura\Client\Plugin\Transcript\Type\TranscriptAssetBaseFilter',
		'KalturaYoutubeApiDistributionProfileFilter' => 'Kaltura\Client\Plugin\YoutubeApiDistribution\Type\YoutubeApiDistributionProfileFilter',
		'KalturaDocumentFlavorParamsFilter' => 'Kaltura\Client\Plugin\Document\Type\DocumentFlavorParamsFilter',
		'KalturaFlavorParamsOutputFilter' => 'Kaltura\Client\Type\FlavorParamsOutputFilter',
		'KalturaImageFlavorParamsFilter' => 'Kaltura\Client\Plugin\Document\Type\ImageFlavorParamsFilter',
		'KalturaLiveAssetFilter' => 'Kaltura\Client\Type\LiveAssetFilter',
		'KalturaLiveParamsFilter' => 'Kaltura\Client\Type\LiveParamsFilter',
		'KalturaLiveStreamScheduleEventFilter' => 'Kaltura\Client\Plugin\Schedule\Type\LiveStreamScheduleEventFilter',
		'KalturaMediaFlavorParamsFilter' => 'Kaltura\Client\Type\MediaFlavorParamsFilter',
		'KalturaMixEntryFilter' => 'Kaltura\Client\Type\MixEntryFilter',
		'KalturaPdfFlavorParamsFilter' => 'Kaltura\Client\Plugin\Document\Type\PdfFlavorParamsFilter',
		'KalturaRecordScheduleEventFilter' => 'Kaltura\Client\Plugin\Schedule\Type\RecordScheduleEventFilter',
		'KalturaScpDropFolderBaseFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\ScpDropFolderBaseFilter',
		'KalturaSftpDropFolderBaseFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\SftpDropFolderBaseFilter',
		'KalturaSwfFlavorParamsFilter' => 'Kaltura\Client\Plugin\Document\Type\SwfFlavorParamsFilter',
		'KalturaThumbParamsOutputFilter' => 'Kaltura\Client\Type\ThumbParamsOutputFilter',
		'KalturaTimedThumbAssetFilter' => 'Kaltura\Client\Plugin\ThumbCuePoint\Type\TimedThumbAssetFilter',
		'KalturaTranscriptAssetFilter' => 'Kaltura\Client\Plugin\Transcript\Type\TranscriptAssetFilter',
		'KalturaWowzaMediaServerNodeBaseFilter' => 'Kaltura\Client\Plugin\Wowza\Type\WowzaMediaServerNodeBaseFilter',
		'KalturaDocumentFlavorParamsOutputBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\DocumentFlavorParamsOutputBaseFilter',
		'KalturaExternalMediaEntryBaseFilter' => 'Kaltura\Client\Plugin\ExternalMedia\Type\ExternalMediaEntryBaseFilter',
		'KalturaImageFlavorParamsOutputBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\ImageFlavorParamsOutputBaseFilter',
		'KalturaLiveEntryBaseFilter' => 'Kaltura\Client\Type\LiveEntryBaseFilter',
		'KalturaMediaFlavorParamsOutputBaseFilter' => 'Kaltura\Client\Type\MediaFlavorParamsOutputBaseFilter',
		'KalturaPdfFlavorParamsOutputBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\PdfFlavorParamsOutputBaseFilter',
		'KalturaScpDropFolderFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\ScpDropFolderFilter',
		'KalturaSftpDropFolderFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\SftpDropFolderFilter',
		'KalturaSwfFlavorParamsOutputBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\SwfFlavorParamsOutputBaseFilter',
		'KalturaWowzaMediaServerNodeFilter' => 'Kaltura\Client\Plugin\Wowza\Type\WowzaMediaServerNodeFilter',
		'KalturaDocumentFlavorParamsOutputFilter' => 'Kaltura\Client\Plugin\Document\Type\DocumentFlavorParamsOutputFilter',
		'KalturaExternalMediaEntryFilter' => 'Kaltura\Client\Plugin\ExternalMedia\Type\ExternalMediaEntryFilter',
		'KalturaImageFlavorParamsOutputFilter' => 'Kaltura\Client\Plugin\Document\Type\ImageFlavorParamsOutputFilter',
		'KalturaLiveEntryFilter' => 'Kaltura\Client\Type\LiveEntryFilter',
		'KalturaMediaFlavorParamsOutputFilter' => 'Kaltura\Client\Type\MediaFlavorParamsOutputFilter',
		'KalturaPdfFlavorParamsOutputFilter' => 'Kaltura\Client\Plugin\Document\Type\PdfFlavorParamsOutputFilter',
		'KalturaSwfFlavorParamsOutputFilter' => 'Kaltura\Client\Plugin\Document\Type\SwfFlavorParamsOutputFilter',
		'KalturaLiveChannelBaseFilter' => 'Kaltura\Client\Type\LiveChannelBaseFilter',
		'KalturaLiveStreamEntryBaseFilter' => 'Kaltura\Client\Type\LiveStreamEntryBaseFilter',
		'KalturaLiveChannelFilter' => 'Kaltura\Client\Type\LiveChannelFilter',
		'KalturaLiveStreamEntryFilter' => 'Kaltura\Client\Type\LiveStreamEntryFilter',
		'KalturaLiveStreamAdminEntryBaseFilter' => 'Kaltura\Client\Type\LiveStreamAdminEntryBaseFilter',
		'KalturaLiveStreamAdminEntryFilter' => 'Kaltura\Client\Type\LiveStreamAdminEntryFilter',
	);
	
	public static function getZendType($kalturaType)
	{
		if(isset(self::$map[$kalturaType]))
			return self::$map[$kalturaType];
		return null;
	}
}
