<?php
/**
 * File containing the ezcWebdavOptionsResponse class.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 * @package Webdav
 * @version //autogentag//
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 */
/**
 * Class generated by the backend to respond to OPTIONS requests.
 *
 * If a {@link ezcWebdavBackend} receives an instance of {@link
 * ezcWebdavOptionsRequest} it might react with an instance of {@link
 * ezcWebdavOptionsResponse} or with producing an error.
 *
 * @version //autogentag//
 * @package Webdav
 */
class ezcWebdavOptionsResponse extends ezcWebdavResponse
{

    const VERSION_ONE = '1';
    const VERSION_TWO = '2';
    const VERSION_ONE_EXTENDED = '1#extended';

    /**
     * Creates a new response object.
     *
     * Creates a new response object, that indicates the given WebDAV $version
     * to be supported by the server.
     * 
     * @param string $version 
     * @return void
     */
    public function __construct( $version = null )
    {
        parent::__construct( ezcWebdavResponse::STATUS_200 );
        $this->setHeader( 'DAV', ( $version === null ? '1' : $version ) );
    }

    /**
     * Validates the headers set in this response.
     *
     * This method is called by {@link ezcWebdavServer} after the response
     * object has been created by an {@link ezcWebdavBackend}. It validates all
     * headers, specific to this response, for existance of required headers
     * and validity of all headers used. The call of the parent method is
     * *mandatory* to have common WebDAV and HTTP headers validated, too.
     *
     * @return void
     *
     * @throws ezcWebdavMissingHeaderException
     *         if a required header is missing.
     * @throws ezcWebdavInvalidHeaderException
     *         if a header is present, but its content does not validate.
     */
    public function validateHeaders()
    {
        if ( !isset( $this->headers['DAV'] ) )
        {
            throw new ezcWebdavMissingHeaderException( 'DAV' );
        }
        $dav = array_map( 'trim', explode( ',', $this->headers['DAV'] ) );
        foreach ( $dav as $number )
        {
            if ( $number !== self::VERSION_ONE && $number !== self::VERSION_TWO && $number !== self::VERSION_ONE_EXTENDED )
            {
                throw new ezcWebdavInvalidHeaderException(
                    'DAV',
                    $this->headers['DAV'],
                    'Components must be ezcWebdavOptionsResponse::VERSION_ONE, ezcWebdavOptionsResponse::VERSION_TWO or ezcWebdavOptionsResponse::VERSION_ONE_EXTENDED'
                );
            }
        }
        // Unified spaces
        $this->headers['DAV'] = implode( ', ', $dav );
        
        // Validate common HTTP/WebDAV headers
        parent::validateHeaders();
    }
}

?>
